/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.envisat;

import org.esa.beam.framework.datamodel.Pointing;
import org.esa.beam.framework.datamodel.PointingFactory;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.TiePointGridPointing;

public class AatsrPointingFactory
implements PointingFactory {
    private static final String[] PRODUCT_TYPES = new String[]{"ATS_NR__2P", "ATS_TOA_1P"};

    public String[] getSupportedProductTypes() {
        return PRODUCT_TYPES;
    }

    public Pointing createPointing(RasterDataNode raster) {
        Product product = raster.getProduct();
        if (raster.getName().toLowerCase().indexOf("_nadir") != -1) {
            return new TiePointGridPointing(raster.getGeoCoding(), this.toZenithTiePointGrid(product, "sun_elev_nadir"), product.getTiePointGrid("sun_azimuth_nadir"), this.toZenithTiePointGrid(product, "view_elev_nadir"), product.getTiePointGrid("view_azimuth_nadir"), product.getTiePointGrid("altitude"));
        }
        if (raster.getName().toLowerCase().indexOf("_fward") != -1) {
            return new TiePointGridPointing(raster.getGeoCoding(), this.toZenithTiePointGrid(product, "sun_elev_fward"), product.getTiePointGrid("sun_azimuth_fward"), this.toZenithTiePointGrid(product, "view_elev_fward"), product.getTiePointGrid("view_azimuth_fward"), product.getTiePointGrid("altitude"));
        }
        return null;
    }

    private TiePointGrid toZenithTiePointGrid(Product product, String name) {
        TiePointGrid base = product.getTiePointGrid(name);
        return base != null ? TiePointGrid.createZenithFromElevationAngleTiePointGrid((TiePointGrid)base) : null;
    }
}

