/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.binning.VariableContext;

public class VariableContextImpl
implements VariableContext {
    private final ArrayList<String> names = new ArrayList();
    private final Map<String, Definition> entries = new HashMap<String, Definition>();
    private String maskExpr;

    public void defineVariable(String name) {
        this.defineVariable(name, null, null);
    }

    public void defineVariable(String name, String expr) {
        this.defineVariable(name, expr, null);
    }

    public void defineVariable(String name, String expr, String validExpr) {
        if (!this.names.contains(name)) {
            this.names.add(name);
        }
        if (expr != null) {
            this.entries.put(name, new Definition(expr, validExpr));
        }
    }

    @Override
    public String getValidMaskExpression() {
        return this.maskExpr;
    }

    public void setMaskExpr(String maskExpr) {
        this.maskExpr = maskExpr;
    }

    @Override
    public int getVariableCount() {
        return this.names.size();
    }

    @Override
    public String getVariableName(int i) {
        return this.names.get(i);
    }

    @Override
    public String getVariableExpression(int i) {
        Definition definition = this.entries.get(this.names.get(i));
        return definition != null ? definition.expr : null;
    }

    @Override
    public String getVariableValidExpression(int i) {
        Definition definition = this.entries.get(this.names.get(i));
        return definition != null ? definition.validExpr : null;
    }

    @Override
    public int getVariableIndex(String name) {
        return this.names.indexOf(name);
    }

    private static class Definition {
        private String expr;
        private String validExpr;

        private Definition(String expr, String validExpr) {
            this.expr = expr;
            this.validExpr = validExpr;
        }
    }
}

