/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.support;

import org.esa.beam.binning.support.PlateCarreeGrid;
import org.esa.beam.framework.datamodel.Rotator;

public class RotatedLatLonGrid
extends PlateCarreeGrid {
    private final Rotator rotator;

    public RotatedLatLonGrid(int numRows, double rotatedLat, double rotatedLon) {
        super(numRows);
        this.rotator = new Rotator(rotatedLon, rotatedLat);
    }

    @Override
    public long getBinIndex(double lat, double lon) {
        double[] lons = new double[]{lon};
        double[] lats = new double[]{lat};
        this.rotator.transform(lons, lats);
        return super.getBinIndex(lats[0], lons[0]);
    }

    @Override
    public double[] getCenterLatLon(long bin) {
        double[] centerLatLon = super.getCenterLatLon(bin);
        double[] lons = new double[]{centerLatLon[1]};
        double[] lats = new double[]{centerLatLon[0]};
        this.rotator.transformInversely(lons, lats);
        centerLatLon[0] = lats[0];
        centerLatLon[1] = lons[0];
        return centerLatLon;
    }

    public static double normalizeLat(double lat) {
        while (lat > 90.0) {
            lat -= 180.0;
        }
        while (lat < -90.0) {
            lat += 180.0;
        }
        return lat;
    }

    public static double normalizeLon(double lon) {
        while (lon > 180.0) {
            lon -= 360.0;
        }
        while (lon < -180.0) {
            lon += 360.0;
        }
        return lon;
    }
}

