/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.support;

import org.esa.beam.binning.support.AbstractGaussianGrid;
import org.esa.beam.binning.support.GaussianGridConfig;

public final class ReducedGaussianGrid
extends AbstractGaussianGrid {
    private final long numBins;
    private long lastBinIndex;
    private int lastRow;

    public ReducedGaussianGrid(int numRows) {
        super(numRows);
        int lastRowIndex = this.getNumRows() - 1;
        GaussianGridConfig config = this.getConfig();
        int lastRowStartIndex = config.getReducedFirstBinIndex(lastRowIndex);
        this.numBins = lastRowStartIndex + config.getReducedColumnCount(lastRowIndex);
    }

    @Override
    public int getRowIndex(long binIndex) {
        if (binIndex == this.lastBinIndex) {
            return this.lastRow;
        }
        int minRow = 0;
        int maxRow = this.getNumRows() - 1;
        while (true) {
            int midRow = (minRow + maxRow) / 2;
            long lowBinIndex = this.getFirstBinIndex(midRow);
            long highBinIndex = lowBinIndex + (long)(this.getNumCols(midRow) - 1);
            if (binIndex < lowBinIndex) {
                maxRow = midRow - 1;
                continue;
            }
            if (binIndex >= lowBinIndex && binIndex <= highBinIndex) {
                this.lastBinIndex = binIndex;
                this.lastRow = midRow;
                return midRow;
            }
            if (binIndex <= highBinIndex) continue;
            minRow = midRow + 1;
        }
    }

    @Override
    public long getNumBins() {
        return this.numBins;
    }

    @Override
    protected int getNumColsUnchecked(int rowIndex) {
        return this.getConfig().getReducedColumnCount(rowIndex);
    }

    @Override
    protected long getFirstBinIndexUnchecked(int rowIndex) {
        return this.getConfig().getReducedFirstBinIndex(rowIndex);
    }

    @Override
    protected double getCenterLon(int rowIndex, int colIndex) {
        return this.getConfig().getReducedLongitudePoints(rowIndex)[colIndex];
    }
}

