/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.support;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.esa.beam.binning.PlanetaryGrid;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.gpf.operators.standard.reproject.ReprojectionOp;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.ProductUtils;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class PlateCarreeGrid
implements PlanetaryGrid {
    private final int numRows;
    private final int numCols;
    private final double pixelSize;
    private final double[] latBin;
    private GeometryFactory geometryFactory;

    public PlateCarreeGrid() {
        this(2160);
    }

    public PlateCarreeGrid(int numRows) {
        if (numRows < 2) {
            throw new IllegalArgumentException("numRows < 2");
        }
        if (numRows % 2 != 0) {
            throw new IllegalArgumentException("numRows % 2 != 0");
        }
        this.numRows = numRows;
        this.numCols = numRows * 2;
        this.pixelSize = 360.0 / (double)this.numCols;
        this.latBin = new double[numRows];
        for (int row = 0; row < numRows; ++row) {
            this.latBin[row] = 90.0 - ((double)row + 0.5) * 180.0 / (double)numRows;
        }
        this.geometryFactory = new GeometryFactory();
    }

    @Override
    public long getBinIndex(double lat, double lon) {
        long row = this.getRowIndex(lat);
        long col = this.getColIndex(lon);
        return row * (long)this.numCols + col;
    }

    @Override
    public int getRowIndex(long binIndex) {
        return (int)(binIndex / (long)this.numCols);
    }

    @Override
    public long getNumBins() {
        return (long)this.numRows * (long)this.numCols;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols(int row) {
        return this.numCols;
    }

    @Override
    public long getFirstBinIndex(int row) {
        return (long)row * (long)this.numCols;
    }

    @Override
    public double getCenterLat(int row) {
        return this.latBin[row];
    }

    @Override
    public double[] getCenterLatLon(long binIndex) {
        int row = this.getRowIndex(binIndex);
        return new double[]{this.getCenterLat(row), this.getCenterLon((int)(binIndex % (long)this.numCols))};
    }

    private double getCenterLon(int col) {
        return 360.0 * ((double)col + 0.5) / (double)this.numCols - 180.0;
    }

    private int getColIndex(double lon) {
        if (lon <= -180.0) {
            return 0;
        }
        if (lon >= 180.0) {
            return this.numCols - 1;
        }
        return (int)((180.0 + lon) * (double)this.numCols / 360.0);
    }

    public int getRowIndex(double lat) {
        if (lat <= -90.0) {
            return this.numRows - 1;
        }
        if (lat >= 90.0) {
            return 0;
        }
        return this.numRows - 1 - (int)((90.0 + lat) * ((double)this.numRows / 180.0));
    }

    public Product reprojectToPlateCareeGrid(Product sourceProduct) {
        ReprojectionOp repro = new ReprojectionOp();
        repro.setParameter("resampling", (Object)"Nearest");
        repro.setParameter("includeTiePointGrids", (Object)true);
        repro.setParameter("orientation", (Object)0.0);
        repro.setParameter("pixelSizeX", (Object)this.pixelSize);
        repro.setParameter("pixelSizeY", (Object)this.pixelSize);
        repro.setParameter("crs", (Object)DefaultGeographicCRS.WGS84.toString());
        Dimension tileSize = ImageManager.getPreferredTileSize((Product)sourceProduct);
        repro.setParameter("tileSizeX", (Object)tileSize.width);
        repro.setParameter("tileSizeY", (Object)tileSize.height);
        int width = this.numCols;
        int height = this.numRows;
        double x = (double)width / 2.0;
        double y = (double)height / 2.0;
        repro.setParameter("easting", (Object)0.0);
        repro.setParameter("northing", (Object)0.0);
        repro.setParameter("referencePixelX", (Object)x);
        repro.setParameter("referencePixelY", (Object)y);
        repro.setParameter("width", (Object)width);
        repro.setParameter("height", (Object)height);
        repro.setSourceProduct(sourceProduct);
        Product targetProduct = repro.getTargetProduct();
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
        return targetProduct;
    }

    public Rectangle[] getDataSliceRectangles(Geometry productGeometry, Dimension tileSize) {
        Rectangle productBoundingBox = this.computeBounds(productGeometry);
        Rectangle gridAlignedBoundingBox = this.alignToTileGrid(productBoundingBox, tileSize);
        int xStart = gridAlignedBoundingBox.x / tileSize.width;
        int yStart = gridAlignedBoundingBox.y / tileSize.height;
        int width = gridAlignedBoundingBox.width / tileSize.width;
        int height = gridAlignedBoundingBox.height / tileSize.height;
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>(width * height);
        for (int y = yStart; y < yStart + height; ++y) {
            for (int x = xStart; x < xStart + width; ++x) {
                Geometry tileGeometry = this.getTileGeometry(x, y, tileSize);
                Geometry intersection = productGeometry.intersection(tileGeometry);
                if (intersection.isEmpty() || intersection.getDimension() != 2) continue;
                Rectangle tileRect = new Rectangle(x * tileSize.width, y * tileSize.height, tileSize.width, tileSize.height);
                rectangles.add(productBoundingBox.intersection(tileRect));
            }
        }
        return rectangles.toArray(new Rectangle[rectangles.size()]);
    }

    private Rectangle computeBounds(Geometry roiGeometry) {
        Rectangle region = new Rectangle(this.numCols, this.numRows);
        if (roiGeometry != null) {
            Coordinate[] coordinates = roiGeometry.getBoundary().getCoordinates();
            double gxmin = Double.POSITIVE_INFINITY;
            double gxmax = Double.NEGATIVE_INFINITY;
            double gymin = Double.POSITIVE_INFINITY;
            double gymax = Double.NEGATIVE_INFINITY;
            for (Coordinate coordinate : coordinates) {
                gxmin = Math.min(gxmin, coordinate.x);
                gxmax = Math.max(gxmax, coordinate.x);
                gymin = Math.min(gymin, coordinate.y);
                gymax = Math.max(gymax, coordinate.y);
            }
            int x = (int)Math.floor((180.0 + gxmin) / this.pixelSize);
            int y = (int)Math.floor((90.0 - gymax) / this.pixelSize);
            int width = (int)Math.ceil((gxmax - gxmin) / this.pixelSize);
            int height = (int)Math.ceil((gymax - gymin) / this.pixelSize);
            Rectangle unclippedOutputRegion = new Rectangle(x, y, width, height);
            region = unclippedOutputRegion.intersection(region);
        }
        return region;
    }

    private Rectangle alignToTileGrid(Rectangle rectangle, Dimension tileSize) {
        int minX = rectangle.x / tileSize.width * tileSize.width;
        int maxX = (rectangle.x + rectangle.width + tileSize.width - 1) / tileSize.width * tileSize.width;
        int minY = rectangle.y / tileSize.height * tileSize.height;
        int maxY = (rectangle.y + rectangle.height + tileSize.height - 1) / tileSize.height * tileSize.height;
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private Geometry getTileGeometry(int tileX, int tileY, Dimension tileSize) {
        int tileWidth = tileSize.width;
        int tileHeight = tileSize.height;
        double x1 = this.tileXToDegree(tileX, tileWidth);
        double x2 = this.tileXToDegree(tileX + 1, tileWidth);
        double y1 = this.tileYToDegree(tileY, tileHeight);
        double y2 = this.tileYToDegree(tileY + 1, tileHeight);
        return this.geometryFactory.toGeometry(new Envelope(x1, x2, y1, y2));
    }

    private double tileXToDegree(int tileX, int tileWidth) {
        return (double)(tileX * tileWidth) * 360.0 / (double)this.numCols - 180.0;
    }

    private double tileYToDegree(int tileY, int tileHeight) {
        return 90.0 - (double)(tileY * tileHeight) * 180.0 / (double)this.numRows;
    }

    public Geometry computeProductGeometry(Product product) {
        try {
            GeneralPath[] paths = ProductUtils.createGeoBoundaryPaths((Product)product);
            Polygon[] polygons = new Polygon[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                polygons[i] = this.convertToJtsPolygon(paths[i].getPathIterator(null));
            }
            DouglasPeuckerSimplifier peuckerSimplifier = new DouglasPeuckerSimplifier((Geometry)(polygons.length == 1 ? polygons[0] : this.geometryFactory.createMultiPolygon(polygons)));
            return peuckerSimplifier.getResultGeometry();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Polygon convertToJtsPolygon(PathIterator pathIterator) {
        ArrayList<Object> coordList = new ArrayList<Object>();
        int lastOpenIndex = 0;
        while (!pathIterator.isDone()) {
            double[] coords = new double[6];
            int segType = pathIterator.currentSegment(coords);
            if (segType == 4) {
                coordList.add(coordList.get(lastOpenIndex));
                lastOpenIndex = coordList.size();
            } else {
                coordList.add(coords);
            }
            pathIterator.next();
        }
        Coordinate[] coordinates = new Coordinate[coordList.size()];
        for (int i1 = 0; i1 < coordinates.length; ++i1) {
            double[] coord = (double[])coordList.get(i1);
            coordinates[i1] = new Coordinate(coord[0], coord[1]);
        }
        return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(coordinates), null);
    }
}

