/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.support;

import java.io.IOException;
import org.esa.beam.binning.PlanetaryGrid;
import org.esa.beam.binning.support.GaussianGridConfig;

abstract class AbstractGaussianGrid
implements PlanetaryGrid {
    private final int numRows;
    private final GaussianGridConfig config;

    protected AbstractGaussianGrid(int numRows) {
        this.numRows = numRows;
        try {
            this.config = GaussianGridConfig.load(numRows / 2);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create gaussian grid: " + e.getMessage(), e);
        }
    }

    protected final GaussianGridConfig getConfig() {
        return this.config;
    }

    @Override
    public final long getBinIndex(double lat, double lon) {
        int rowIndex = this.getRowIndex(lat);
        int colIndex = this.getColIndex(rowIndex, lon);
        return this.getFirstBinIndex(rowIndex) + (long)colIndex;
    }

    @Override
    public final int getNumRows() {
        return this.numRows;
    }

    @Override
    public final int getNumCols(int rowIndex) {
        this.validateRowIndex(rowIndex);
        return this.getNumColsUnchecked(rowIndex);
    }

    @Override
    public final long getFirstBinIndex(int rowIndex) {
        this.validateRowIndex(rowIndex);
        return this.getFirstBinIndexUnchecked(rowIndex);
    }

    @Override
    public final double getCenterLat(int rowIndex) {
        this.validateRowIndex(rowIndex);
        return this.config.getLatitude(rowIndex);
    }

    @Override
    public final double[] getCenterLatLon(long binIndex) {
        int rowIndex = this.getRowIndex(binIndex);
        int colIndex = this.getColIndex(binIndex, rowIndex);
        double lat = this.getCenterLat(rowIndex);
        double lon = this.getCenterLon(rowIndex, colIndex);
        return new double[]{lat, lon > 180.0 ? lon - 360.0 : lon};
    }

    protected abstract int getNumColsUnchecked(int var1);

    protected abstract long getFirstBinIndexUnchecked(int var1);

    protected abstract double getCenterLon(int var1, int var2);

    private int getRowIndex(double lat) {
        return AbstractGaussianGrid.findNearest(this.config.getLatitudePoints(), lat);
    }

    private int getColIndex(int rowIndex, double lon) {
        int index;
        int numColsInRow = this.getNumColsUnchecked(rowIndex);
        double delta = 360.0 / (double)numColsInRow;
        if (lon < 0.0) {
            lon += 360.0;
        }
        return (index = (int)(lon / delta + 0.5)) == numColsInRow ? 0 : index;
    }

    private int getColIndex(long binIndex, int rowIndex) {
        return (int)(binIndex - this.getFirstBinIndex(rowIndex));
    }

    private void validateRowIndex(int rowIndex) {
        int maxRowIndex = this.getNumRows() - 1;
        if (rowIndex > maxRowIndex) {
            String msg = String.format("Invalid row index. Maximum allowed is %d, but was %d.", maxRowIndex, rowIndex);
            throw new IllegalArgumentException(msg);
        }
    }

    static int findNearest(double[] values, double value) {
        int l = 0;
        int h = values.length - 1;
        while (l <= h) {
            int m = h + l >> 1;
            if (values[m] >= value) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        if (h == -1) {
            return 0;
        }
        if (h == values.length - 1) {
            return h;
        }
        if (values[h] - value < value - values[h + 1]) {
            return h;
        }
        return h + 1;
    }
}

