/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.reader;

import java.io.IOException;
import org.esa.beam.binning.reader.AbstractGridAccessor;
import org.esa.beam.binning.reader.CacheEntry;
import org.esa.beam.binning.reader.NcArrayCache;
import org.esa.beam.binning.reader.VariableReader;
import org.esa.beam.framework.datamodel.Band;
import ucar.ma2.Array;
import ucar.nc2.NetcdfFile;

class FullGridAccessor
extends AbstractGridAccessor {
    private final NcArrayCache ncArrayCache;
    private final NetcdfFile netcdfFile;

    FullGridAccessor(NetcdfFile netcdfFile) {
        this.netcdfFile = netcdfFile;
        this.ncArrayCache = new NcArrayCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Array getLineValues(Band destBand, VariableReader variableReader, int lineIndex) throws IOException {
        Array lineValues;
        NcArrayCache ncArrayCache = this.ncArrayCache;
        synchronized (ncArrayCache) {
            CacheEntry cacheEntry = this.ncArrayCache.get(destBand);
            if (cacheEntry != null) {
                lineValues = cacheEntry.getData();
            } else {
                NetcdfFile netcdfFile = this.netcdfFile;
                synchronized (netcdfFile) {
                    lineValues = variableReader.readFully();
                }
                this.ncArrayCache.put(destBand, new CacheEntry(lineValues));
            }
        }
        return lineValues;
    }

    @Override
    int getStartBinIndex(int sourceOffsetX, int lineIndex) {
        return this.getBinIndexInPlanetaryGrid(sourceOffsetX, lineIndex);
    }

    @Override
    int getEndBinIndex(int sourceOffsetX, int sourceWidth, int lineIndex) {
        return this.getBinIndexInPlanetaryGrid(sourceOffsetX + sourceWidth - 1, lineIndex) + 1;
    }

    @Override
    int getBinIndexInGrid(int binIndex, int lineIndex) {
        return binIndex;
    }

    @Override
    void dispose() {
        this.ncArrayCache.dispose();
    }

    private int getBinIndexInPlanetaryGrid(int x, int y) {
        int numberOfBinsInRow = this.planetaryGrid.getNumCols(y);
        double longitudeExtentPerBin = 360.0 / (double)numberOfBinsInRow;
        double pixelCenterLongitude = (double)x * this.pixelSizeX + this.pixelSizeX / 2.0;
        int firstBinIndex = (int)this.planetaryGrid.getFirstBinIndex(y);
        return (int)(pixelCenterLongitude / longitudeExtentPerBin) + firstBinIndex;
    }
}

