/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator.ui;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.Enablement;
import com.bc.ceres.swing.binding.internal.AbstractButtonAdapter;
import com.jidesoft.swing.AutoResizingTextArea;
import com.jidesoft.swing.TitledSeparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.esa.beam.binning.operator.BinningOp;
import org.esa.beam.binning.operator.ui.BinningFormModel;
import org.esa.beam.framework.ui.RegionBoundsInputUI;

class BinningFilterPanel
extends JPanel {
    private static final String TIME_FILTER_METHOD_NONE = "ignore pixel observation time, use all source pixels";
    private static final String TIME_FILTER_METHOD_TIME_RANGE = "use all pixels that have been acquired in the given binning period";
    private static final String TIME_FILTER_METHOD_SPATIOTEMPORAL_DATA_DAY = "<html>use a sensor-dependent, spatial \"data-day\" definition with the goal to minimise the<br>time between the first and last observation contributing to the same bin in the given binning period.</html>";
    private final Map<BinningOp.TimeFilterMethod, String> timeFilterMethodDescriptions = new HashMap<BinningOp.TimeFilterMethod, String>();
    private final BindingContext bindingContext;
    private BinningFormModel binningFormModel;

    BinningFilterPanel(BinningFormModel binningFormModel) {
        this.timeFilterMethodDescriptions.put(BinningOp.TimeFilterMethod.NONE, TIME_FILTER_METHOD_NONE);
        this.timeFilterMethodDescriptions.put(BinningOp.TimeFilterMethod.TIME_RANGE, TIME_FILTER_METHOD_TIME_RANGE);
        this.timeFilterMethodDescriptions.put(BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY, TIME_FILTER_METHOD_SPATIOTEMPORAL_DATA_DAY);
        this.binningFormModel = binningFormModel;
        this.bindingContext = binningFormModel.getBindingContext();
        this.init();
    }

    private void init() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton computeOption = new JRadioButton("Compute the geographical region according to extents of input products");
        JRadioButton globalOption = new JRadioButton("Use the whole globe as region");
        JRadioButton regionOption = new JRadioButton("Specify region:");
        JRadioButton wktOption = new JRadioButton("Enter WKT:");
        this.bindingContext.bind("compute", (ComponentAdapter)new RadioButtonAdapter(computeOption));
        this.bindingContext.bind("global", (ComponentAdapter)new RadioButtonAdapter(globalOption));
        this.bindingContext.bind("manualWktKey", (ComponentAdapter)new RadioButtonAdapter(wktOption));
        this.bindingContext.bind("bounds", (ComponentAdapter)new RadioButtonAdapter(regionOption));
        buttonGroup.add(computeOption);
        buttonGroup.add(globalOption);
        buttonGroup.add(wktOption);
        buttonGroup.add(regionOption);
        computeOption.setSelected(true);
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.NORTHEAST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTablePadding(4, 3);
        this.setLayout((LayoutManager)layout);
        this.add((Component)new TitledSeparator("Spatial Filter / Region", 0));
        this.add(computeOption);
        this.add(globalOption);
        this.add(wktOption);
        this.add(this.createWktInputPanel());
        this.add(regionOption);
        this.add(this.createAndInitBoundsUI());
        this.add((Component)new TitledSeparator("Temporal Filter", 0));
        this.add(this.createTemporalFilterPanel());
        this.add(layout.createVerticalSpacer());
    }

    private JComponent createWktInputPanel() {
        AutoResizingTextArea textArea = new AutoResizingTextArea(3, 30);
        textArea.addPropertyChangeListener(new PropertyChangeListener((JTextArea)textArea){
            final /* synthetic */ JTextArea val$textArea;
            {
                this.val$textArea = jTextArea;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.val$textArea.isEnabled()) {
                    this.val$textArea.setBackground(Color.WHITE);
                } else {
                    this.val$textArea.setBackground(new Color(240, 240, 240));
                }
            }
        });
        this.bindingContext.bind("manualWkt", (JTextComponent)textArea);
        this.bindingContext.bindEnabledState("manualWkt", false, "manualWktKey", (Object)false);
        textArea.setEnabled(false);
        return new JScrollPane((Component)textArea);
    }

    private JPanel createAndInitBoundsUI() {
        final RegionBoundsInputUI regionBoundsInputUI = new RegionBoundsInputUI(this.bindingContext);
        this.bindingContext.addPropertyChangeListener("bounds", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = (Boolean)evt.getNewValue();
                regionBoundsInputUI.setEnabled(enabled);
            }
        });
        regionBoundsInputUI.setEnabled(false);
        return regionBoundsInputUI.getUI();
    }

    private Component createTemporalFilterPanel() {
        TableLayout layout = new TableLayout(3);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTableWeightX(Double.valueOf(0.0));
        layout.setTableWeightY(Double.valueOf(0.0));
        layout.setTablePadding(10, 5);
        layout.setCellColspan(0, 1, Integer.valueOf(2));
        layout.setCellColspan(3, 1, Integer.valueOf(2));
        layout.setCellWeightX(2, 1, Double.valueOf(1.0));
        layout.setCellWeightX(2, 2, Double.valueOf(0.0));
        layout.setColumnWeightX(1, Double.valueOf(1.0));
        JPanel panel = new JPanel((LayoutManager)layout);
        JLabel temporalFilterLabel = new JLabel("Time filter method:");
        JLabel startDateLabel = new JLabel("Start date:");
        JLabel startDateFormatLabel = new JLabel("yyyy-MM-dd( HH:mm:ss)");
        JLabel periodDurationLabel = new JLabel("Period duration:");
        JLabel minDataHourLabel = new JLabel("Min data hour:");
        JLabel periodDurationUnitLabel = new JLabel("days");
        final JComboBox<BinningOp.TimeFilterMethod> temporalFilterComboBox = new JComboBox<BinningOp.TimeFilterMethod>(new BinningOp.TimeFilterMethod[]{BinningOp.TimeFilterMethod.NONE, BinningOp.TimeFilterMethod.TIME_RANGE, BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY});
        temporalFilterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinningOp.TimeFilterMethod method = (BinningOp.TimeFilterMethod)((Object)temporalFilterComboBox.getSelectedItem());
                if (method != null) {
                    temporalFilterComboBox.setToolTipText((String)BinningFilterPanel.this.timeFilterMethodDescriptions.get((Object)method));
                }
            }
        });
        JTextField startDateTextField = new JTextField();
        JTextField periodDurationTextField = new JTextField();
        JTextField minDataHourTextField = new JTextField();
        startDateLabel.setEnabled(false);
        periodDurationLabel.setEnabled(false);
        temporalFilterLabel.setToolTipText("The method that is used to decide which source pixels are used with respect to their observation time.");
        startDateLabel.setToolTipText("The UTC start date of the binning period. If only the date part is given, the time 00:00:00 is assumed.");
        periodDurationLabel.setToolTipText("Duration of the binning period in days.");
        minDataHourLabel.setToolTipText("A sensor-dependent constant given in hours of a day (0 to 24) at which a sensor has a minimum number of observations at the date line (the 180 degree meridian).");
        BindingContext bindingContext = this.binningFormModel.getBindingContext();
        bindingContext.bind("timeFilterMethod", temporalFilterComboBox);
        bindingContext.bind("startDateTime", startDateTextField);
        bindingContext.bind("periodDuration", periodDurationTextField);
        bindingContext.bind("minDataHour", minDataHourTextField);
        bindingContext.getBinding("startDateTime").addComponent((JComponent)startDateLabel);
        bindingContext.getBinding("startDateTime").addComponent((JComponent)startDateFormatLabel);
        bindingContext.getBinding("periodDuration").addComponent((JComponent)periodDurationLabel);
        bindingContext.getBinding("periodDuration").addComponent((JComponent)periodDurationUnitLabel);
        bindingContext.getBinding("minDataHour").addComponent((JComponent)minDataHourLabel);
        temporalFilterComboBox.setSelectedIndex(0);
        bindingContext.bindEnabledState("startDateTime", true, BinningFilterPanel.hasTimeInformation(BinningOp.TimeFilterMethod.TIME_RANGE, BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY));
        bindingContext.bindEnabledState("periodDuration", true, BinningFilterPanel.hasTimeInformation(BinningOp.TimeFilterMethod.TIME_RANGE, BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY));
        bindingContext.bindEnabledState("minDataHour", true, BinningFilterPanel.hasTimeInformation(BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY));
        temporalFilterComboBox.setSelectedIndex(0);
        panel.add(temporalFilterLabel);
        panel.add(temporalFilterComboBox);
        panel.add(startDateLabel);
        panel.add(startDateTextField);
        panel.add(startDateFormatLabel);
        panel.add(periodDurationLabel);
        panel.add(periodDurationTextField);
        panel.add(periodDurationUnitLabel);
        panel.add(minDataHourLabel);
        panel.add(minDataHourTextField);
        return panel;
    }

    private static Enablement.Condition hasTimeInformation(final BinningOp.TimeFilterMethod ... conditions) {
        return new Enablement.Condition(){

            public boolean evaluate(BindingContext bindingContext) {
                BinningOp.TimeFilterMethod chosenMethod = (BinningOp.TimeFilterMethod)((Object)bindingContext.getPropertySet().getProperty("timeFilterMethod").getValue());
                for (BinningOp.TimeFilterMethod condition : conditions) {
                    if (condition != chosenMethod) continue;
                    return true;
                }
                return false;
            }

            public void install(BindingContext bindingContext, Enablement enablement) {
                bindingContext.addPropertyChangeListener("timeFilterMethod", (PropertyChangeListener)enablement);
            }

            public void uninstall(BindingContext bindingContext, Enablement enablement) {
                bindingContext.removePropertyChangeListener("timeFilterMethod", (PropertyChangeListener)enablement);
            }
        };
    }

    private static class RadioButtonAdapter
    extends AbstractButtonAdapter
    implements ItemListener {
        RadioButtonAdapter(AbstractButton button) {
            super(button);
        }

        public void bindComponents() {
            this.getButton().addItemListener(this);
        }

        public void unbindComponents() {
            this.getButton().removeItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.getBinding().setPropertyValue((Object)this.getButton().isSelected());
        }
    }
}

