/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.esa.beam.binning.AggregatorConfig;
import org.esa.beam.binning.AggregatorDescriptor;
import org.esa.beam.binning.TypedDescriptorsRegistry;
import org.esa.beam.binning.operator.ui.AggregatorItem;
import org.esa.beam.binning.operator.ui.AggregatorTableController;
import org.esa.beam.framework.gpf.annotations.ParameterDescriptorFactory;
import org.esa.beam.framework.ui.ModalDialog;

class AggregatorItemDialog
extends ModalDialog {
    private final AggregatorItem aggregatorItem;
    private final String[] sourceVarNames;
    private AggregatorConfig aggregatorConfig;
    private AggregatorDescriptor aggregatorDescriptor;
    private PropertySet aggregatorPropertySet;
    private JComboBox<String> aggregatorComboBox;

    public AggregatorItemDialog(Window parent, String[] sourceVarNames, AggregatorItem aggregatorItem, boolean initWithDefaults) {
        super(parent, "Edit Aggregator", 33, null);
        this.sourceVarNames = sourceVarNames;
        this.aggregatorItem = aggregatorItem;
        this.aggregatorConfig = aggregatorItem.aggregatorConfig;
        this.aggregatorDescriptor = aggregatorItem.aggregatorDescriptor;
        this.aggregatorPropertySet = this.createPropertySet(this.aggregatorConfig);
        if (initWithDefaults) {
            this.aggregatorPropertySet.setDefaultValues();
        } else {
            Property[] objectProperties;
            PropertyContainer objectPropertySet = PropertyContainer.createObjectBacked((Object)((Object)this.aggregatorConfig));
            for (Property objectProperty : objectProperties = objectPropertySet.getProperties()) {
                this.aggregatorPropertySet.setValue(objectProperty.getName(), objectProperty.getValue());
            }
        }
    }

    public int show() {
        this.setContent(this.createUI());
        this.getJDialog().getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AggregatorItemDialog.this.hide();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getJDialog().setResizable(false);
        return super.show();
    }

    protected boolean verifyUserInput() {
        try {
            for (Property property : this.aggregatorPropertySet.getProperties()) {
                property.validate(property.getValue());
            }
        }
        catch (ValidationException e) {
            JOptionPane.showMessageDialog(this.getContent(), "Aggregator properties are not valid.\n" + e.getMessage(), "Invalid Aggregator Properties", 0);
            return false;
        }
        return true;
    }

    protected void onOK() {
        Property[] mapProperties;
        AggregatorConfig config = (AggregatorConfig)((Object)this.aggregatorDescriptor.createConfig());
        PropertySet objectPropertySet = config.asPropertySet();
        for (Property mapProperty : mapProperties = this.aggregatorPropertySet.getProperties()) {
            objectPropertySet.setValue(mapProperty.getName(), mapProperty.getValue());
        }
        objectPropertySet.setValue("type", (Object)this.aggregatorDescriptor.getName());
        this.aggregatorItem.aggregatorConfig = config;
        this.aggregatorItem.aggregatorDescriptor = this.aggregatorDescriptor;
        super.onOK();
    }

    private Component createUI() {
        final JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        List<AggregatorDescriptor> aggregatorDescriptors = registry.getDescriptors(AggregatorDescriptor.class);
        ArrayList<String> aggregatorNames = new ArrayList<String>();
        for (AggregatorDescriptor aggregatorDescriptor1 : aggregatorDescriptors) {
            aggregatorNames.add(aggregatorDescriptor1.getName());
        }
        Collections.sort(aggregatorNames);
        this.aggregatorComboBox = new JComboBox<String>(aggregatorNames.toArray(new String[aggregatorNames.size()]));
        this.aggregatorComboBox.setSelectedItem(this.aggregatorConfig.getName());
        this.aggregatorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AggregatorItemDialog.this.aggregatorDescriptor = AggregatorItemDialog.this.getDescriptorFromComboBox();
                AggregatorItemDialog.this.aggregatorConfig = (AggregatorConfig)((Object)AggregatorItemDialog.this.aggregatorDescriptor.createConfig());
                AggregatorItemDialog.this.aggregatorPropertySet = AggregatorItemDialog.this.createPropertySet(AggregatorItemDialog.this.aggregatorConfig);
                JPanel aggrPropertyPanel = AggregatorItemDialog.this.createPropertyPanel(AggregatorItemDialog.this.aggregatorPropertySet);
                mainPanel.remove(1);
                mainPanel.add((Component)aggrPropertyPanel, "Center");
                AggregatorItemDialog.this.getJDialog().getContentPane().revalidate();
                AggregatorItemDialog.this.getJDialog().pack();
            }
        });
        JPanel aggrPropertyPanel = this.createPropertyPanel(this.aggregatorPropertySet);
        mainPanel.add(this.aggregatorComboBox, "North");
        mainPanel.add((Component)aggrPropertyPanel, "Center");
        return mainPanel;
    }

    private PropertySet createPropertySet(AggregatorConfig config) {
        return PropertyContainer.createMapBacked(new HashMap(), ((Object)((Object)config)).getClass(), (PropertyDescriptorFactory)new ParameterDescriptorFactory());
    }

    private AggregatorDescriptor getDescriptorFromComboBox() {
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        String aggrType = (String)this.aggregatorComboBox.getSelectedItem();
        return registry.getDescriptor(AggregatorDescriptor.class, aggrType);
    }

    private JPanel createPropertyPanel(PropertySet propertySet) {
        Property[] properties;
        for (Property property : properties = propertySet.getProperties()) {
            String propertyName = property.getName();
            if ("type".equals(propertyName)) {
                property.getDescriptor().setAttribute("visible", (Object)false);
            }
            if (!AggregatorTableController.isSourcePropertyName(propertyName)) continue;
            property.getDescriptor().setValueSet(new ValueSet((Object[])this.sourceVarNames));
        }
        return new PropertyPane(propertySet).createPanel();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JFrame jFrame = new JFrame();
                jFrame.setDefaultCloseOperation(3);
                JButton aggregatorComboBox = new JButton("Show Dialog...");
                aggregatorComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AggregatorItemDialog dialog = new AggregatorItemDialog(jFrame, new String[]{"stein", "papier", "schere", "echse", "spock"}, new AggregatorItem(), true);
                        dialog.getJDialog().setLocation(550, 300);
                        dialog.show();
                    }
                });
                jFrame.setContentPane(aggregatorComboBox);
                jFrame.setBounds(300, 300, 200, 80);
                jFrame.setVisible(true);
            }
        });
    }
}

