/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator.metadata;

import org.esa.beam.binning.operator.metadata.AllHistoriesMetaAggregator;
import org.esa.beam.binning.operator.metadata.FirstHistoryMetaAggregator;
import org.esa.beam.binning.operator.metadata.MetadataAggregator;
import org.esa.beam.binning.operator.metadata.ProductNameMetaAggregator;

public class MetadataAggregatorFactory {
    private static final String NAME = "NAME";
    private static final String FIRST_HISTORY = "FIRST_HISTORY";
    private static final String ALL_HISTORIES = "ALL_HISTORIES";

    public static MetadataAggregator create(String name) {
        if (NAME.equalsIgnoreCase(name)) {
            return new ProductNameMetaAggregator();
        }
        if (FIRST_HISTORY.equalsIgnoreCase(name)) {
            return new FirstHistoryMetaAggregator();
        }
        if (ALL_HISTORIES.equalsIgnoreCase(name)) {
            return new AllHistoriesMetaAggregator();
        }
        throw new IllegalArgumentException("Unknown metadata aggregator name: " + name);
    }
}

