/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator.metadata;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.esa.beam.binning.AggregatorConfig;
import org.esa.beam.binning.operator.BinningConfig;
import org.esa.beam.binning.operator.BinningOp;
import org.esa.beam.binning.operator.VariableConfig;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.descriptor.OperatorDescriptor;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.io.FileUtils;

public class GlobalMetadata {
    private static final String DATETIME_OUTPUT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final SimpleDateFormat DATETIME_OUTPUT_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final double RE = 6378.145;
    private final SortedMap<String, String> metaProperties = new TreeMap<String, String>();

    public static GlobalMetadata create(BinningOp operator) {
        GlobalMetadata globalMetadata = new GlobalMetadata();
        OperatorSpi spi = operator.getSpi();
        if (spi != null) {
            globalMetadata.extractSpiMetadata(spi);
        }
        BinningConfig config = operator.createConfig();
        globalMetadata.extractConfigMetadata(config);
        return globalMetadata;
    }

    public static GlobalMetadata create(BinningConfig config) {
        GlobalMetadata globalMetadata = new GlobalMetadata();
        globalMetadata.extractConfigMetadata(config);
        return globalMetadata;
    }

    public void processMetadataTemplates(File metadataTemplateDir, BinningOp operator, Product targetProduct, Logger logger) {
        File absTemplateDir = metadataTemplateDir.getAbsoluteFile();
        File[] files = absTemplateDir.listFiles(new VelocityTemplateFilter());
        if (files == null || files.length == 0) {
            return;
        }
        VelocityEngine ve = GlobalMetadata.createVelocityEngine(absTemplateDir, logger);
        if (ve == null) {
            return;
        }
        VelocityContext vc = new VelocityContext(this.metaProperties);
        vc.put("operator", (Object)operator);
        vc.put("targetProduct", (Object)targetProduct);
        vc.put("metadataProperties", this.metaProperties);
        for (File file : files) {
            GlobalMetadata.processMetadataTemplate(file, ve, vc, logger);
        }
    }

    public SortedMap<String, String> asSortedMap() {
        return this.metaProperties;
    }

    public MetadataElement asMetadataElement() {
        MetadataElement processingGraph = new MetadataElement("Processing_Graph");
        MetadataElement node_0 = new MetadataElement("node.0");
        MetadataElement parameters = new MetadataElement("parameters");
        for (String name : this.metaProperties.keySet()) {
            String value = (String)this.metaProperties.get(name);
            parameters.addAttribute(new MetadataAttribute(name, ProductData.createInstance((String)value), true));
        }
        ProductData processingTime = ProductData.createInstance((String)DATETIME_OUTPUT_FORMAT.format(new Date()));
        node_0.addAttribute(new MetadataAttribute("processingTime", processingTime, false));
        node_0.addElement(parameters);
        processingGraph.addElement(node_0);
        return processingGraph;
    }

    public void load(File propertiesFile, Logger logger) {
        if (propertiesFile == null) {
            return;
        }
        if (!propertiesFile.isFile()) {
            logger.warning(String.format("Metadata properties file '%s' not found", propertiesFile));
            return;
        }
        logger.info(String.format("Reading metadata properties file '%s'...", propertiesFile));
        try (FileReader reader = new FileReader(propertiesFile);){
            Properties properties = new Properties();
            properties.load(reader);
            for (String name : properties.stringPropertyNames()) {
                this.metaProperties.put(name, properties.getProperty(name));
            }
        }
        catch (IOException e) {
            String msgPattern = "Failed to load metadata properties file '%s': %s";
            logger.warning(String.format("Failed to load metadata properties file '%s': %s", propertiesFile, e.getMessage()));
        }
    }

    private static VelocityEngine createVelocityEngine(File absTemplateDir, Logger logger) {
        Properties veConfig = new Properties();
        if (absTemplateDir.equals(new File(".").getAbsoluteFile())) {
            veConfig.setProperty("file.resource.loader.path", absTemplateDir.getPath());
        }
        VelocityEngine ve = new VelocityEngine();
        try {
            ve.init(veConfig);
        }
        catch (Exception e) {
            String msgPattern = "Can't generate metadata file(s): Failed to initialise Velocity engine: %s";
            logger.log(Level.SEVERE, String.format("Can't generate metadata file(s): Failed to initialise Velocity engine: %s", e.getMessage()), e);
            return null;
        }
        return ve;
    }

    private static void processMetadataTemplate(File templateFile, VelocityEngine ve, VelocityContext vc, Logger logger) {
        String templateName = templateFile.getName();
        String outputName = templateName.substring(0, templateName.lastIndexOf(46));
        logger.info(String.format("Writing metadata file '%s'...", outputName));
        try (FileWriter writer = new FileWriter(outputName);){
            ve.mergeTemplate(templateName, "ISO-8859-1", (Context)vc, (Writer)writer);
        }
        catch (Exception e) {
            String msgPattern = "Failed to generate metadata file from template '%s': %s";
            logger.log(Level.SEVERE, String.format("Failed to generate metadata file from template '%s': %s", templateName, e.getMessage()), e);
        }
    }

    private void extractConfigMetadata(BinningConfig config) {
        String aggregatorName;
        AggregatorConfig[] aggregatorConfigs;
        String maskExpr;
        Integer superSampling;
        int numRows;
        BinningOp.TimeFilterMethod timeFilterMethod;
        Geometry region;
        Double periodDuration;
        String startDateTime;
        String outputPath = config.getOutputFile();
        if (StringUtils.isNotNullAndNotEmpty((String)outputPath)) {
            File outputFile = new File(outputPath);
            this.metaProperties.put("product_name", FileUtils.getFilenameWithoutExtension((String)outputFile.getName()));
        }
        if (StringUtils.isNotNullAndNotEmpty((String)(startDateTime = config.getStartDateTime()))) {
            this.metaProperties.put("aggregation_period_start", startDateTime);
        }
        if ((periodDuration = config.getPeriodDuration()) != null) {
            this.metaProperties.put("aggregation_period_duration", Double.toString(periodDuration) + " day(s)");
        }
        if ((region = config.getRegion()) != null) {
            this.metaProperties.put("region", region.toString());
        }
        if (GlobalMetadata.isTimeFilterMetadataRequired(timeFilterMethod = config.getTimeFilterMethod())) {
            Double minDataHour;
            this.metaProperties.put("time_filter_method", timeFilterMethod.toString());
            if (timeFilterMethod == BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY && (minDataHour = config.getMinDataHour()) != null) {
                this.metaProperties.put("min_data_hour", Double.toString(minDataHour));
            }
        }
        if ((numRows = config.getNumRows()) > 0) {
            this.metaProperties.put("num_rows", Integer.toString(numRows));
            this.metaProperties.put("pixel_size_in_km", GlobalMetadata.toPixelSizeString(numRows));
        }
        if ((superSampling = config.getSuperSampling()) != null) {
            this.metaProperties.put("super_sampling", Integer.toString(superSampling));
        }
        if (StringUtils.isNullOrEmpty((String)(maskExpr = config.getMaskExpr()))) {
            this.metaProperties.put("mask_expression", "");
        } else {
            this.metaProperties.put("mask_expression", maskExpr);
        }
        VariableConfig[] variableConfigs = config.getVariableConfigs();
        if (variableConfigs != null) {
            int index = 0;
            for (VariableConfig variableConfig : variableConfigs) {
                this.metaProperties.put("variable_config." + Integer.toString(index) + ":name", variableConfig.getName());
                this.metaProperties.put("variable_config." + Integer.toString(index) + ":expr", variableConfig.getExpr());
                String validExpr = variableConfig.getValidExpr();
                if (validExpr != null) {
                    this.metaProperties.put("variable_config." + Integer.toString(index) + ":validExpr", validExpr);
                }
                ++index;
            }
        }
        if ((aggregatorConfigs = config.getAggregatorConfigs()) != null) {
            int index = 0;
            for (AggregatorConfig aggregatorConfig : aggregatorConfigs) {
                Property[] properties;
                PropertySet propertySet = aggregatorConfig.asPropertySet();
                for (Property property : properties = propertySet.getProperties()) {
                    String value = property.getValueAsText();
                    if (!StringUtils.isNotNullAndNotEmpty((String)value)) continue;
                    this.metaProperties.put("aggregator_config." + Integer.toString(index) + ":" + property.getName(), value);
                }
                ++index;
            }
        }
        if (StringUtils.isNotNullAndNotEmpty((String)(aggregatorName = config.getMetadataAggregatorName()))) {
            this.metaProperties.put("metadata_aggregator_name", aggregatorName);
        }
    }

    static boolean isTimeFilterMetadataRequired(BinningOp.TimeFilterMethod timeFilterMethod) {
        return timeFilterMethod != null && timeFilterMethod != BinningOp.TimeFilterMethod.NONE;
    }

    static String toPixelSizeString(int numRows) {
        return Double.toString(20037.533475530472 / (double)(numRows - 1));
    }

    private void extractSpiMetadata(OperatorSpi spi) {
        OperatorDescriptor descriptor = spi.getOperatorDescriptor();
        if (descriptor != null) {
            this.metaProperties.put("software_qualified_name", descriptor.getName());
            this.metaProperties.put("software_name", descriptor.getAlias());
            this.metaProperties.put("software_version", descriptor.getVersion());
        }
    }

    GlobalMetadata() {
    }

    static {
        DATETIME_OUTPUT_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private static class VelocityTemplateFilter
    implements FilenameFilter {
        private VelocityTemplateFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".vm");
        }
    }
}

