/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator.metadata;

import org.esa.beam.binning.operator.metadata.AbstractMetadataAggregator;
import org.esa.beam.binning.operator.metadata.Utilities;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.StringUtils;

class FirstHistoryMetaAggregator
extends AbstractMetadataAggregator {
    FirstHistoryMetaAggregator() {
    }

    @Override
    public void aggregateMetadata(Product product) {
        String productName = Utilities.extractProductName(product);
        MetadataElement processingGraphElement = Utilities.getProcessingGraphElement(product);
        this.aggregate(productName, processingGraphElement);
    }

    @Override
    public void aggregateMetadata(MetadataElement processingGraphElement) {
        String productName = Utilities.extractProductName(processingGraphElement);
        if (StringUtils.isNullOrEmpty((String)productName)) {
            productName = "unknown";
        }
        this.aggregate(productName, processingGraphElement);
    }

    @Override
    public MetadataElement getMetadata() {
        return this.inputsMetaElement;
    }

    private void aggregate(String productName, MetadataElement processingGraphElement) {
        MetadataElement inputMetaElement = Utilities.createSourceMetaElement(productName, this.aggregatedCount);
        if (processingGraphElement != null && this.aggregatedCount == 0) {
            inputMetaElement.addElement(processingGraphElement.createDeepClone());
        }
        this.inputsMetaElement.addElementAt(inputMetaElement, this.aggregatedCount);
        ++this.aggregatedCount;
    }
}

