/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import com.bc.ceres.core.VirtualDir;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.binning.TemporalBin;
import org.esa.beam.binning.operator.DeleteDirThread;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.util.logging.BeamLogManager;

class TemporalBinList
extends AbstractList<TemporalBin> {
    public static final int DEFAULT_MAX_CACHE_FILES = 10000;
    public static final int DEFAULT_BINS_PER_FILE = 1000;
    private static final String FILE_NAME_PATTERN = "temporal-bins-%05d.tmp";
    private static final Logger logger = BeamLogManager.getSystemLogger();
    private final long numberOfBins;
    private final int binsPerFile;
    private final List<TemporalBin> currentBinList;
    private final File tempDir = VirtualDir.createUniqueTempDir();
    private int size;
    private int lastFileIndex;
    private boolean firstGet;

    public TemporalBinList(int numberOfBins) throws IOException {
        this(numberOfBins, 10000, 1000);
    }

    TemporalBinList(int numberOfBins, int maxNumberOfCacheFiles, int preferredBinsPerFile) throws IOException {
        Runtime.getRuntime().addShutdownHook(new DeleteDirThread(this.tempDir));
        this.numberOfBins = numberOfBins;
        this.binsPerFile = TemporalBinList.computeBinsPerFile(numberOfBins, maxNumberOfCacheFiles, preferredBinsPerFile);
        this.currentBinList = new LinkedList<TemporalBin>();
        this.size = 0;
        this.lastFileIndex = 0;
        this.firstGet = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(TemporalBin temporalBin) {
        if ((long)this.size >= this.numberOfBins) {
            throw new IllegalStateException("Number of add operation exceeds maximum number of bins");
        }
        List<TemporalBin> list = this.currentBinList;
        synchronized (list) {
            try {
                int currentFileIndex = this.calculateFileIndex(this.size);
                if (currentFileIndex != this.lastFileIndex) {
                    this.writeBinList(this.lastFileIndex, this.currentBinList);
                    this.currentBinList.clear();
                    this.readBinList(currentFileIndex, this.currentBinList);
                    this.lastFileIndex = currentFileIndex;
                }
                this.currentBinList.add(temporalBin);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error adding temporal bins.", e);
                return false;
            }
        }
        ++this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemporalBin get(int index) {
        if ((long)index >= this.numberOfBins) {
            throw new IllegalStateException(String.format("Index out of range. Maximum is %d but was %d", this.numberOfBins - 1L, index));
        }
        if (this.firstGet) {
            try {
                this.writeBinList(this.lastFileIndex, this.currentBinList);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error storing temporal bins.", e);
                TemporalBin temporalBin = null;
                return temporalBin;
            }
            finally {
                this.firstGet = false;
            }
        }
        List<TemporalBin> list = this.currentBinList;
        synchronized (list) {
            try {
                int currentFileIndex = this.calculateFileIndex(index);
                if (currentFileIndex != this.lastFileIndex) {
                    this.currentBinList.clear();
                    this.readBinList(currentFileIndex, this.currentBinList);
                    this.lastFileIndex = currentFileIndex;
                }
                int fileBinOffset = this.binsPerFile * currentFileIndex;
                return this.currentBinList.get(index - fileBinOffset);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, String.format("Error getting temporal bin at index %d.", index), e);
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void close() {
        FileUtils.deleteTree((File)this.tempDir);
    }

    static int computeBinsPerFile(int numberOfBins, int maxNumberOfCacheFiles, int preferredBinsPerFile) {
        int numCacheFiles = (int)Math.ceil((float)numberOfBins / (float)preferredBinsPerFile);
        int binsPerFile = (int)Math.ceil((float)numberOfBins / (float)(numCacheFiles = Math.min(numCacheFiles, maxNumberOfCacheFiles)));
        return binsPerFile < preferredBinsPerFile ? preferredBinsPerFile : binsPerFile;
    }

    private int calculateFileIndex(int index) {
        return index / this.binsPerFile;
    }

    private File getFile(int fileIndex) throws IOException {
        return new File(this.tempDir, String.format(FILE_NAME_PATTERN, fileIndex));
    }

    private void writeBinList(int currentFileIndex, List<TemporalBin> binList) throws IOException {
        File file = this.getFile(currentFileIndex);
        TemporalBinList.writeToFile(binList, file);
    }

    private void readBinList(int currentFileIndex, List<TemporalBin> binList) throws IOException {
        File file = this.getFile(currentFileIndex);
        if (file.exists()) {
            TemporalBinList.readFromFile(file, binList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(List<TemporalBin> temporalBins, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos, 0x500000));){
            for (TemporalBin bin : temporalBins) {
                dos.writeLong(bin.getIndex());
                bin.write(dos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFromFile(File file, List<TemporalBin> temporalBins) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(fis, 0x500000));){
            while (dis.available() != 0) {
                long binIndex = dis.readLong();
                temporalBins.add(TemporalBin.read(binIndex, dis));
            }
        }
    }
}

