/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import org.esa.beam.binning.DataPeriod;
import org.esa.beam.binning.operator.BinningProductFilter;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.logging.BeamLogManager;

class SpatialDataDaySourceProductFilter
extends BinningProductFilter {
    private final DataPeriod dataPeriod;

    public SpatialDataDaySourceProductFilter(BinningProductFilter parent, DataPeriod dataPeriod) {
        this.setParent(parent);
        this.dataPeriod = dataPeriod;
    }

    @Override
    protected boolean acceptForBinning(Product product) {
        GeoCoding geoCoding = product.getGeoCoding();
        ProductData.UTC firstScanLineTime = ProductUtils.getScanLineTime((Product)product, (double)0.0);
        ProductData.UTC lastScanLineTime = ProductUtils.getScanLineTime((Product)product, (double)(product.getSceneRasterHeight() - 1));
        if (firstScanLineTime == null || lastScanLineTime == null) {
            String message = String.format("not accepting product '%s': missing time coding", product.getName());
            this.setReason(message);
            return false;
        }
        float firstLon = geoCoding.getGeoPos((PixelPos)new PixelPos((float)0.0f, (float)0.0f), null).lon;
        DataPeriod.Membership topLeft = this.dataPeriod.getObservationMembership(firstLon, firstScanLineTime.getMJD());
        float lastLon = geoCoding.getGeoPos((PixelPos)new PixelPos((float)((float)(product.getSceneRasterWidth() - 1)), (float)0.0f), null).lon;
        DataPeriod.Membership topRight = this.dataPeriod.getObservationMembership(lastLon, firstScanLineTime.getMJD());
        firstLon = geoCoding.getGeoPos((PixelPos)new PixelPos((float)0.0f, (float)((float)(product.getSceneRasterHeight() - 1))), null).lon;
        DataPeriod.Membership bottomLeft = this.dataPeriod.getObservationMembership(firstLon, lastScanLineTime.getMJD());
        lastLon = geoCoding.getGeoPos((PixelPos)new PixelPos((float)((float)(product.getSceneRasterWidth() - 1)), (float)((float)(product.getSceneRasterHeight() - 1))), null).lon;
        DataPeriod.Membership bottomRight = this.dataPeriod.getObservationMembership(lastLon, lastScanLineTime.getMJD());
        String message = String.format("accepting product '%s': topLeftMembership=%s, topRightMembership=%s, bottomLeftMembership=%s, bottomRightMembership=%s, startTime=%s, endTime=%s", new Object[]{product.getName(), topLeft, topRight, bottomLeft, bottomRight, product.getStartTime(), product.getEndTime()});
        if (topLeft == topRight && topRight == bottomLeft && bottomLeft == bottomRight && topLeft != DataPeriod.Membership.CURRENT_PERIOD) {
            String msg = "not " + message;
            BeamLogManager.getSystemLogger().finer(msg);
            this.setReason(msg);
            return false;
        }
        BeamLogManager.getSystemLogger().finer(message);
        return true;
    }
}

