/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.esa.beam.binning.ProductCustomizer;
import org.esa.beam.binning.TemporalBin;
import org.esa.beam.binning.TemporalBinRenderer;
import org.esa.beam.binning.Vector;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public final class ProductTemporalBinRenderer
implements TemporalBinRenderer {
    private final Product product;
    private final int rasterWidth;
    private final ProductData numObsLine;
    private final ProductData numPassesLine;
    private final Band[] outputBands;
    private final List<Band> customizerBands;
    private final ProductData[] outputLines;
    private final Band numObsBand;
    private final Band numPassesBand;
    private final float[] fillValues;
    private final File outputFile;
    private int yLast;
    private final ProductWriter productWriter;
    private final Rectangle outputRegion;

    public ProductTemporalBinRenderer(String[] featureNames, File outputFile, String outputFormat, Rectangle outputRegion, double pixelSize, ProductData.UTC startTime, ProductData.UTC endTime, ProductCustomizer productCustomizer, MetadataElement ... metadataElements) throws IOException {
        int i;
        this.productWriter = ProductIO.getProductWriter((String)outputFormat);
        if (this.productWriter == null) {
            throw new IllegalArgumentException("No writer found for output format " + outputFormat);
        }
        this.outputRegion = new Rectangle(outputRegion);
        this.outputFile = outputFile;
        CrsGeoCoding geoCoding = ProductTemporalBinRenderer.createMapGeoCoding(outputRegion, pixelSize);
        this.product = new Product(outputFile.getName(), "BINNED-L3", outputRegion.width, outputRegion.height);
        this.product.setProductWriter(this.productWriter);
        this.product.setPreferredTileSize(64, 64);
        this.product.setGeoCoding((GeoCoding)geoCoding);
        this.product.setStartTime(startTime);
        this.product.setEndTime(endTime);
        for (MetadataElement metadataElement : metadataElements) {
            this.product.getMetadataRoot().addElement(metadataElement);
        }
        Band localNumObsBand = this.product.addBand("num_obs", 12);
        localNumObsBand.setNoDataValue(-1.0);
        localNumObsBand.setNoDataValueUsed(true);
        Band localNumPassesBand = this.product.addBand("num_passes", 11);
        localNumPassesBand.setNoDataValue(-1.0);
        localNumPassesBand.setNoDataValueUsed(true);
        boolean numObsIsFeature = false;
        boolean numPassesIsFeature = false;
        String[] arr$ = featureNames;
        int len$ = arr$.length;
        block9: for (int i$ = 0; i$ < len$; ++i$) {
            String name;
            switch (name = arr$[i$]) {
                case "num_obs": {
                    numObsIsFeature = true;
                    continue block9;
                }
                case "num_passes": {
                    numPassesIsFeature = true;
                    continue block9;
                }
                default: {
                    Band band = this.product.addBand(name, 30);
                    band.setNoDataValue(Double.NaN);
                    band.setNoDataValueUsed(true);
                }
            }
        }
        if (productCustomizer != null) {
            productCustomizer.customizeProduct(this.product);
            this.customizerBands = new ArrayList<Band>(this.product.getNumBands());
            Collections.addAll(this.customizerBands, this.product.getBands());
        } else {
            this.customizerBands = Collections.emptyList();
        }
        this.numObsBand = this.product.getBand("num_obs");
        if (this.numObsBand != null && !numObsIsFeature) {
            this.numObsLine = this.numObsBand.createCompatibleRasterData(outputRegion.width, 1);
            if (!this.customizerBands.isEmpty()) {
                this.customizerBands.remove(this.numObsBand);
            }
        } else {
            this.numObsLine = null;
        }
        this.numPassesBand = this.product.getBand("num_passes");
        if (this.numPassesBand != null && !numPassesIsFeature) {
            this.numPassesLine = this.numPassesBand.createCompatibleRasterData(outputRegion.width, 1);
            if (!this.customizerBands.isEmpty()) {
                this.customizerBands.remove(this.numPassesBand);
            }
        } else {
            this.numPassesLine = null;
        }
        this.outputBands = new Band[featureNames.length];
        this.outputLines = new ProductData[featureNames.length];
        for (i = 0; i < featureNames.length; ++i) {
            String name = featureNames[i];
            this.outputBands[i] = this.product.getBand(name);
            this.outputLines[i] = this.outputBands[i].createCompatibleRasterData(outputRegion.width, 1);
            if (this.customizerBands.isEmpty()) continue;
            this.customizerBands.remove(this.outputBands[i]);
        }
        this.rasterWidth = outputRegion.width;
        this.fillValues = new float[this.outputBands.length];
        for (i = 0; i < this.outputBands.length; ++i) {
            this.fillValues[i] = (float)this.outputBands[i].getNoDataValue();
        }
    }

    @Override
    public Rectangle getRasterRegion() {
        return this.outputRegion;
    }

    @Override
    public void begin() throws IOException {
        File parentFile = this.outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        this.productWriter.writeProductNodes(this.product, (Object)this.outputFile);
        this.initLine();
        this.yLast = 0;
    }

    @Override
    public void end() throws IOException {
        this.completeLine();
        for (Band band : this.customizerBands) {
            if (!this.productWriter.shouldWrite((ProductNode)band)) continue;
            band.writeRasterDataFully(ProgressMonitor.NULL);
        }
        this.productWriter.close();
        this.product.closeIO();
    }

    @Override
    public void renderBin(int x, int y, TemporalBin temporalBin, Vector outputVector) throws IOException {
        if (y != this.yLast) {
            this.completeLine();
            this.yLast = y;
        }
        this.setData(x, temporalBin, outputVector);
    }

    @Override
    public void renderMissingBin(int x, int y) throws IOException {
        if (y != this.yLast) {
            this.completeLine();
            this.yLast = y;
        }
        this.setNoData(x);
    }

    private void completeLine() throws IOException {
        this.writeLine(this.yLast);
        this.initLine();
    }

    private void writeLine(int y) throws IOException {
        if (this.numObsBand != null && this.numObsLine != null) {
            this.productWriter.writeBandRasterData(this.numObsBand, 0, y, this.rasterWidth, 1, this.numObsLine, ProgressMonitor.NULL);
        }
        if (this.numPassesBand != null && this.numPassesLine != null) {
            this.productWriter.writeBandRasterData(this.numPassesBand, 0, y, this.rasterWidth, 1, this.numPassesLine, ProgressMonitor.NULL);
        }
        for (int i = 0; i < this.outputBands.length; ++i) {
            this.productWriter.writeBandRasterData(this.outputBands[i], 0, y, this.rasterWidth, 1, this.outputLines[i], ProgressMonitor.NULL);
        }
    }

    private void initLine() {
        for (int x = 0; x < this.rasterWidth; ++x) {
            this.setNoData(x);
        }
    }

    private void setData(int x, TemporalBin temporalBin, Vector outputVector) {
        if (this.numObsLine != null) {
            this.numObsLine.setElemIntAt(x, temporalBin.getNumObs());
        }
        if (this.numPassesLine != null) {
            this.numPassesLine.setElemIntAt(x, temporalBin.getNumPasses());
        }
        for (int i = 0; i < this.outputBands.length; ++i) {
            this.outputLines[i].setElemFloatAt(x, outputVector.get(i));
        }
    }

    private void setNoData(int x) {
        if (this.numObsLine != null) {
            this.numObsLine.setElemIntAt(x, -1);
        }
        if (this.numPassesLine != null) {
            this.numPassesLine.setElemIntAt(x, -1);
        }
        for (int i = 0; i < this.outputBands.length; ++i) {
            this.outputLines[i].setElemFloatAt(x, this.fillValues[i]);
        }
    }

    private static CrsGeoCoding createMapGeoCoding(Rectangle outputRegion, double pixelSize) {
        CrsGeoCoding geoCoding;
        try {
            geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, outputRegion.width, outputRegion.height, -180.0 + pixelSize * (double)outputRegion.x, 90.0 - pixelSize * (double)outputRegion.y, pixelSize, pixelSize, 0.0, 0.0);
        }
        catch (FactoryException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformException e) {
            throw new IllegalStateException(e);
        }
        return geoCoding;
    }
}

