/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.esa.beam.binning.BinningContext;
import org.esa.beam.binning.SpatialBin;
import org.esa.beam.binning.operator.SpatialBinCollection;
import org.esa.beam.binning.operator.SpatialBinCollector;

class MapBackedSpatialBinCollector
implements SpatialBinCollector {
    private final SortedMap<Long, List<SpatialBin>> spatialBinMap = new TreeMap<Long, List<SpatialBin>>();
    private AtomicBoolean consumingCompleted = new AtomicBoolean(false);

    MapBackedSpatialBinCollector() {
    }

    @Override
    public SpatialBinCollection getSpatialBinCollection() {
        return new SortedMapWrappingSpatialBinCollection(this.spatialBinMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeSpatialBins(BinningContext binningContext, List<SpatialBin> spatialBins) {
        if (this.consumingCompleted.get()) {
            throw new IllegalStateException("Consuming of bins has already been completed.");
        }
        SortedMap<Long, List<SpatialBin>> sortedMap = this.spatialBinMap;
        synchronized (sortedMap) {
            for (SpatialBin spatialBin : spatialBins) {
                long spatialBinIndex = spatialBin.getIndex();
                ArrayList<SpatialBin> spatialBinList = (ArrayList<SpatialBin>)this.spatialBinMap.get(spatialBinIndex);
                if (spatialBinList == null) {
                    spatialBinList = new ArrayList<SpatialBin>();
                    this.spatialBinMap.put(spatialBinIndex, spatialBinList);
                }
                spatialBinList.add(spatialBin);
            }
        }
    }

    @Override
    public void consumingCompleted() {
        this.consumingCompleted.set(true);
    }

    @Override
    public void close() throws IOException {
        this.clearMap();
    }

    void clearMap() {
        this.spatialBinMap.clear();
    }

    private class SortedMapWrappingSpatialBinCollection
    implements SpatialBinCollection {
        private SortedMap<Long, List<SpatialBin>> map;

        private SortedMapWrappingSpatialBinCollection(SortedMap<Long, List<SpatialBin>> spatialBinMap) {
            this.map = spatialBinMap;
        }

        @Override
        public Iterable<List<SpatialBin>> getBinCollection() {
            return new Iterable<List<SpatialBin>>(){

                @Override
                public Iterator<List<SpatialBin>> iterator() {
                    return SortedMapWrappingSpatialBinCollection.this.map.values().iterator();
                }
            };
        }

        @Override
        public long size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }
    }
}

