/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.operator;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.binding.ConversionException;
import org.esa.beam.binning.ProductCustomizer;
import org.esa.beam.binning.ProductCustomizerConfig;
import org.esa.beam.binning.ProductCustomizerDescriptor;
import org.esa.beam.binning.TypedDescriptorsRegistry;
import org.esa.beam.binning.operator.BinningOp;
import org.esa.beam.binning.operator.ProductCustomizerConfigDomConverter;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.ParameterBlockConverter;

public class FormatterConfig {
    @Parameter(valueSet={"Product", "RGB", "Grey"}, defaultValue="Product")
    private String outputType;
    @Parameter
    private String outputFile;
    @Parameter(defaultValue="BEAM-DIMAP")
    private String outputFormat;
    @Parameter(alias="outputBands", itemAlias="band", description="Configures the target bands. Not needed if output type 'Product' is chosen.")
    private BinningOp.BandConfiguration[] bandConfigurations;
    @Parameter(alias="productCustomizer", domConverter=ProductCustomizerConfigDomConverter.class)
    private ProductCustomizerConfig productCustomizerConfig;
    private transient ProductCustomizer productCustomizer;

    public FormatterConfig() {
    }

    public FormatterConfig(String outputType, String outputFile, String outputFormat, BinningOp.BandConfiguration[] bandConfigurations) {
        this.outputType = outputType;
        this.outputFile = outputFile;
        this.outputFormat = outputFormat;
        this.bandConfigurations = bandConfigurations;
    }

    public static FormatterConfig fromXml(String xml) throws BindingException {
        return (FormatterConfig)new ParameterBlockConverter().convertXmlToObject(xml, (Object)new FormatterConfig());
    }

    public String toXml() {
        try {
            return new ParameterBlockConverter().convertObjectToXml((Object)this);
        }
        catch (ConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getOutputType() {
        if (this.outputType == null) {
            throw new IllegalArgumentException("No output type given");
        }
        if (!(this.outputType.equalsIgnoreCase("Product") || this.outputType.equalsIgnoreCase("RGB") || this.outputType.equalsIgnoreCase("Grey"))) {
            throw new IllegalArgumentException("Unknown output type: " + this.outputType);
        }
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public BinningOp.BandConfiguration[] getBandConfigurations() {
        return (BinningOp.BandConfiguration[])this.bandConfigurations.clone();
    }

    public void setBandConfigurations(BinningOp.BandConfiguration ... bandConfigurations) {
        this.bandConfigurations = bandConfigurations;
    }

    public ProductCustomizerConfig getProductCustomizerConfig() {
        return this.productCustomizerConfig;
    }

    public void setProductCustomizerConfig(ProductCustomizerConfig productCustomizerConfig) {
        this.productCustomizerConfig = productCustomizerConfig;
    }

    public ProductCustomizer getProductCustomizer() {
        if (this.productCustomizer == null && this.productCustomizerConfig != null) {
            TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
            ProductCustomizerDescriptor descriptor = registry.getDescriptor(ProductCustomizerDescriptor.class, this.productCustomizerConfig.getName());
            if (descriptor != null) {
                this.productCustomizer = descriptor.createProductCustomizer(this.productCustomizerConfig);
            } else {
                throw new IllegalArgumentException("Unknown cell processor type: " + this.productCustomizerConfig.getName());
            }
        }
        return this.productCustomizer;
    }
}

