/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.cellprocessor;

import org.esa.beam.binning.BinManager;
import org.esa.beam.binning.BinningContext;
import org.esa.beam.binning.TemporalBin;
import org.esa.beam.binning.WritableVector;
import org.esa.beam.binning.support.BinTracer;

public class CellProcessorChain {
    private final BinManager binManager;
    private final BinTracer binTracer;

    public CellProcessorChain(BinningContext binningContext) {
        this.binManager = binningContext.getBinManager();
        this.binTracer = this.binManager.getBinTracer();
    }

    public TemporalBin process(TemporalBin temporalBin) {
        if (this.binManager.hasPostProcessor()) {
            WritableVector temporalVector = temporalBin.toVector();
            TemporalBin processBin = this.binManager.createProcessBin(temporalBin.getIndex());
            this.binManager.postProcess(temporalVector, processBin.toVector());
            processBin.setNumObs(temporalBin.getNumObs());
            processBin.setNumPasses(temporalBin.getNumPasses());
            long binIndex = temporalBin.getIndex();
            if (BinTracer.traceThis(this.binTracer, binIndex)) {
                this.binTracer.tracePost(temporalBin, processBin);
            }
            return processBin;
        }
        return temporalBin;
    }
}

