/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning.aggregators;

import java.util.Arrays;
import org.esa.beam.binning.AbstractAggregator;
import org.esa.beam.binning.Aggregator;
import org.esa.beam.binning.AggregatorConfig;
import org.esa.beam.binning.AggregatorDescriptor;
import org.esa.beam.binning.BinContext;
import org.esa.beam.binning.Observation;
import org.esa.beam.binning.VariableContext;
import org.esa.beam.binning.Vector;
import org.esa.beam.binning.WritableVector;
import org.esa.beam.binning.support.GrowableVector;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.util.StringUtils;

public class AggregatorPercentile
extends AbstractAggregator {
    private final int varIndex;
    private final int percentage;
    private final String mlName;
    private final String icName;

    public AggregatorPercentile(VariableContext varCtx, String varName, String targetName, int percentage) {
        super("PERCENTILE", AggregatorPercentile.createFeatureNames(varName, "sum"), AggregatorPercentile.createFeatureNames(varName, "p" + percentage), AggregatorPercentile.createFeatureNames(targetName, "p" + percentage));
        if (varCtx == null) {
            throw new NullPointerException("varCtx");
        }
        if (varName == null) {
            throw new NullPointerException("varName");
        }
        if (percentage < 0 || percentage > 100) {
            throw new IllegalArgumentException("percentage < 0 || percentage > 100");
        }
        this.varIndex = varCtx.getVariableIndex(varName);
        this.percentage = percentage;
        this.mlName = "ml." + varName;
        this.icName = "ic." + varName;
    }

    @Override
    public void initSpatial(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        ctx.put(this.icName, new int[1]);
    }

    @Override
    public void aggregateSpatial(BinContext ctx, Observation observationVector, WritableVector spatialVector) {
        float value = observationVector.get(this.varIndex);
        if (!Float.isNaN(value)) {
            spatialVector.set(0, spatialVector.get(0) + value);
        } else {
            int[] nArray = (int[])ctx.get(this.icName);
            nArray[0] = nArray[0] + 1;
        }
    }

    @Override
    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
        Integer invalidCount = ((int[])ctx.get(this.icName))[0];
        int effectiveCount = numSpatialObs - invalidCount;
        if (effectiveCount > 0) {
            spatialVector.set(0, spatialVector.get(0) / (float)effectiveCount);
        } else {
            spatialVector.set(0, Float.NaN);
        }
    }

    @Override
    public void initTemporal(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        ctx.put(this.mlName, new GrowableVector(256));
    }

    @Override
    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        GrowableVector measurementsVec = (GrowableVector)ctx.get(this.mlName);
        float value = spatialVector.get(0);
        if (!Float.isNaN(value)) {
            measurementsVec.add(value);
        }
    }

    @Override
    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
        GrowableVector measurementsVec = (GrowableVector)ctx.get(this.mlName);
        float[] measurements = measurementsVec.getElements();
        if (measurements.length > 0) {
            Arrays.sort(measurements);
            temporalVector.set(0, AggregatorPercentile.computePercentile(this.percentage, measurements));
        } else {
            temporalVector.set(0, Float.NaN);
        }
    }

    @Override
    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        outputVector.set(0, temporalVector.get(0));
    }

    public String toString() {
        return "AggregatorPercentile{varIndex=" + this.varIndex + ", percentage=" + this.percentage + ", spatialFeatureNames=" + Arrays.toString(this.getSpatialFeatureNames()) + ", temporalFeatureNames=" + Arrays.toString(this.getTemporalFeatureNames()) + ", outputFeatureNames=" + Arrays.toString(this.getOutputFeatureNames()) + '}';
    }

    public static float computePercentile(int p, float[] measurements) {
        int N = measurements.length;
        float n = (float)p / 100.0f * (float)(N + 1);
        int k = (int)Math.floor(n);
        float d = n - (float)k;
        float yp = k == 0 ? measurements[0] : (k >= N ? measurements[N - 1] : measurements[k - 1] + d * (measurements[k] - measurements[k - 1]));
        return yp;
    }

    private static int getEffectivePercentage(Integer percentage) {
        return percentage != null ? percentage : 90;
    }

    public static class Descriptor
    implements AggregatorDescriptor {
        public static final String NAME = "PERCENTILE";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public AggregatorConfig createConfig() {
            return new Config();
        }

        @Override
        public Aggregator createAggregator(VariableContext varCtx, AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
            int effectivePercentage = AggregatorPercentile.getEffectivePercentage(config.percentage);
            return new AggregatorPercentile(varCtx, config.varName, targetName, effectivePercentage);
        }

        @Override
        public String[] getSourceVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            return new String[]{config.varName};
        }

        @Override
        public String[] getTargetVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
            int percentage = AggregatorPercentile.getEffectivePercentage(config.percentage);
            return AbstractAggregator.createFeatureNames(targetName, "p" + percentage);
        }
    }

    public static class Config
    extends AggregatorConfig {
        @Parameter(label="Source band name", notEmpty=true, notNull=true, description="The source band used for aggregation.")
        String varName;
        @Parameter(label="Target band name prefix (optional)", description="The name prefix for the resulting bands. If empty, the source band name is used")
        String targetName;
        @Parameter(label="Percentile", defaultValue="90", interval="[0,100]", description="The percentile to be created. Must be in the interval [0..100].")
        Integer percentage;

        public Config() {
            this(null, null, 90);
        }

        public Config(String targetName, String varName, int percentage) {
            super("PERCENTILE");
            this.targetName = targetName;
            this.varName = varName;
            this.percentage = percentage;
        }
    }
}

