/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.beam.BeamCoreActivator;
import org.esa.beam.binning.TypedDescriptor;

public class TypedDescriptorsRegistry {
    private final Map<Class, SpecificRegistry> map = new HashMap<Class, SpecificRegistry>();

    protected TypedDescriptorsRegistry() {
    }

    private synchronized <TD extends TypedDescriptor> SpecificRegistry getSpecificRegistry(Class<TD> klass) {
        SpecificRegistry<TD> specificRegistry = this.map.get(klass);
        if (specificRegistry == null) {
            specificRegistry = new SpecificRegistry<TD>(klass);
            this.map.put(klass, specificRegistry);
        }
        return specificRegistry;
    }

    public <TD extends TypedDescriptor> List<TD> getDescriptors(Class<TD> klass) {
        SpecificRegistry specificRegistry = this.getSpecificRegistry(klass);
        return specificRegistry.getDescriptors();
    }

    public <TD extends TypedDescriptor> TD getDescriptor(Class<TD> klass, String name) {
        SpecificRegistry specificRegistry = this.getSpecificRegistry(klass);
        return specificRegistry.getDescriptor(name);
    }

    public static TypedDescriptorsRegistry getInstance() {
        return Holder.instance;
    }

    private class SpecificRegistry<TD extends TypedDescriptor> {
        private final Map<String, TD> nameMap;

        SpecificRegistry(Class<TD> klass) {
            ServiceRegistryManager serviceRegistryManager = ServiceRegistryManager.getInstance();
            ServiceRegistry serviceRegistry = serviceRegistryManager.getServiceRegistry(klass);
            if (!BeamCoreActivator.isStarted()) {
                BeamCoreActivator.loadServices((ServiceRegistry)serviceRegistry);
            }
            this.nameMap = this.createNameMap(serviceRegistry);
        }

        private Map<String, TD> createNameMap(ServiceRegistry<TD> serviceRegistry) {
            HashMap<String, TypedDescriptor> map = new HashMap<String, TypedDescriptor>();
            Set descriptors = serviceRegistry.getServices();
            for (TypedDescriptor descriptor : descriptors) {
                map.put(descriptor.getName(), descriptor);
            }
            return map;
        }

        TD getDescriptor(String name) {
            return (TD)((TypedDescriptor)this.nameMap.get(name));
        }

        List<TD> getDescriptors() {
            return Collections.unmodifiableList(new ArrayList<TD>(this.nameMap.values()));
        }
    }

    private static class Holder {
        private static final TypedDescriptorsRegistry instance = new TypedDescriptorsRegistry();

        private Holder() {
        }
    }
}

