/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning;

import org.esa.beam.binning.DataPeriod;

public class TemporalDataPeriod
implements DataPeriod {
    private static final double EPS = 2.7777777777777776E-7;
    private final double startTime;
    private final double duration;

    public TemporalDataPeriod(double startTime, double duration) {
        this.startTime = startTime;
        this.duration = duration;
    }

    @Override
    public DataPeriod.Membership getObservationMembership(double lon, double time) {
        double h = 24.0 * (time - this.startTime);
        if (h - 2.7777777777777776E-7 < 0.0) {
            return DataPeriod.Membership.PREVIOUS_PERIODS;
        }
        if (h + 2.7777777777777776E-7 > 24.0 * this.duration) {
            return DataPeriod.Membership.SUBSEQUENT_PERIODS;
        }
        return DataPeriod.Membership.CURRENT_PERIOD;
    }
}

