/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.esa.beam.binning.Bin;

public class SpatialBin
extends Bin {
    public SpatialBin() {
    }

    public SpatialBin(long index, int numFeatures) {
        super(index, numFeatures);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.numObs);
        dataOutput.writeInt(this.featureValues.length);
        for (float value : this.featureValues) {
            dataOutput.writeFloat(value);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.numObs = dataInput.readInt();
        int numFeatures = dataInput.readInt();
        this.featureValues = new float[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            this.featureValues[i] = dataInput.readFloat();
        }
    }

    public static SpatialBin read(DataInput dataInput) throws IOException {
        return SpatialBin.read(-1L, dataInput);
    }

    public static SpatialBin read(long index, DataInput dataInput) throws IOException {
        SpatialBin bin = new SpatialBin();
        bin.index = index;
        bin.readFields(dataInput);
        return bin;
    }

    public String toString() {
        return String.format("%s{index=%d, numObs=%d, featureValues=%s}", this.getClass().getSimpleName(), this.index, this.numObs, Arrays.toString(this.featureValues));
    }
}

