/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.binning;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.media.jai.PlanarImage;
import org.esa.beam.binning.BinningContext;
import org.esa.beam.binning.DataPeriod;
import org.esa.beam.binning.Observation;
import org.esa.beam.binning.SamplePointer;
import org.esa.beam.binning.support.ObservationImpl;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.math.MathUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Ellipsoid;

abstract class ObservationIterator
implements Iterator<Observation> {
    private Observation next;
    private boolean nextValid;
    private SamplePointer pointer;
    private final GeoCoding gc;
    private final Product product;
    private final boolean productHasTime;
    private final DataPeriod dataPeriod;
    private final PreparedGeometry region;
    private final GeometryFactory geometryFactory;
    private int maxDistanceOnEarth;
    private double earthRadius;
    private PixelPos lastRefPP;
    private GeoPos lastRefGP;

    static ObservationIterator create(PlanarImage[] sourceImages, PlanarImage maskImage, Product product, float[] superSamplingSteps, Rectangle sliceRectangle, BinningContext binningContext) {
        SamplePointer pointer;
        if (superSamplingSteps.length == 1) {
            pointer = SamplePointer.create(sourceImages, new Rectangle[]{sliceRectangle});
        } else {
            Point2D.Float[] superSamplingPoints = SamplePointer.createSamplingPoints(superSamplingSteps);
            pointer = SamplePointer.create(sourceImages, new Rectangle[]{sliceRectangle}, superSamplingPoints);
        }
        if (maskImage == null) {
            return new NoMaskObservationIterator(product, pointer, binningContext);
        }
        return new FullObservationIterator(product, pointer, maskImage, binningContext);
    }

    private ObservationIterator(Product product, SamplePointer pointer, BinningContext binningContext) {
        this.pointer = pointer;
        this.dataPeriod = binningContext.getDataPeriod();
        Geometry geometryRegion = binningContext.getRegion();
        this.region = geometryRegion != null ? PreparedGeometryFactory.prepare((Geometry)binningContext.getRegion()) : null;
        this.product = product;
        this.productHasTime = product.getStartTime() != null || product.getEndTime() != null;
        this.gc = product.getGeoCoding();
        Ellipsoid ellipsoid = CRS.getEllipsoid((CoordinateReferenceSystem)this.gc.getMapCRS());
        this.earthRadius = ellipsoid != null ? ellipsoid.getSemiMajorAxis() : DefaultEllipsoid.WGS84.getSemiMajorAxis();
        this.geometryFactory = new GeometryFactory();
        this.maxDistanceOnEarth = binningContext.getMaxDistanceOnEarth();
    }

    public final SamplePointer getPointer() {
        return this.pointer;
    }

    @Override
    public final boolean hasNext() {
        this.ensureValidNext();
        return this.next != null;
    }

    @Override
    public final Observation next() {
        this.ensureValidNext();
        if (this.next == null) {
            throw new NoSuchElementException("EMPTY");
        }
        this.nextValid = false;
        return this.next;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Removing of elements is not allowed");
    }

    private void ensureValidNext() {
        if (!this.nextValid) {
            this.next = this.getNextObservation();
            this.nextValid = true;
        }
    }

    protected abstract Observation getNextObservation();

    protected Observation createObservation(int x, int y) {
        SamplePointer pointer = this.getPointer();
        Point2D.Float superSamplingPoint = pointer.getSuperSamplingPoint();
        PixelPos pixelPos = new PixelPos((float)x + superSamplingPoint.x, (float)y + superSamplingPoint.y);
        GeoPos geoPos = this.getGeoPos(pixelPos);
        if (!this.acceptGeoPos(geoPos)) {
            return null;
        }
        double mjd = 0.0;
        if (this.productHasTime) {
            ProductData.UTC scanLineTime = ProductUtils.getScanLineTime((Product)this.product, (double)((double)y + 0.5));
            mjd = scanLineTime.getMJD();
            if (this.dataPeriod != null && this.dataPeriod.getObservationMembership(geoPos.lon, mjd) != DataPeriod.Membership.CURRENT_PERIOD) {
                return null;
            }
        }
        if (this.maxDistanceOnEarth > 0) {
            double distance;
            PixelPos currentRefPP = new PixelPos((float)x + 0.5f, (float)y + 0.5f);
            if (!currentRefPP.equals((Object)this.lastRefPP)) {
                this.lastRefPP = currentRefPP;
                this.lastRefGP = this.getGeoPos(this.lastRefPP);
            }
            if ((distance = MathUtils.sphereDistanceDeg((double)this.earthRadius, (double)geoPos.getLon(), (double)geoPos.getLat(), (double)this.lastRefGP.getLon(), (double)this.lastRefGP.getLat())) > (double)this.maxDistanceOnEarth) {
                return null;
            }
        }
        float[] samples = pointer.createSamples();
        return new ObservationImpl(geoPos.lat, geoPos.lon, mjd, samples);
    }

    private boolean acceptGeoPos(GeoPos geoPos) {
        return this.region == null || this.region.contains((Geometry)this.geometryFactory.createPoint(new Coordinate((double)geoPos.lon, (double)geoPos.lat)));
    }

    protected GeoPos getGeoPos(PixelPos pixelPos) {
        GeoPos geoPos = new GeoPos();
        this.gc.getGeoPos(pixelPos, geoPos);
        return geoPos;
    }

    static class NoMaskObservationIterator
    extends ObservationIterator {
        NoMaskObservationIterator(Product product, SamplePointer pointer, BinningContext binningContext) {
            super(product, pointer, binningContext);
        }

        @Override
        protected Observation getNextObservation() {
            SamplePointer pointer = this.getPointer();
            while (pointer.canMove()) {
                pointer.move();
                Observation observation = this.createObservation(pointer.getX(), pointer.getY());
                if (observation == null) continue;
                return observation;
            }
            return null;
        }
    }

    static class FullObservationIterator
    extends ObservationIterator {
        private Raster maskTile;
        private final PlanarImage maskImage;

        FullObservationIterator(Product product, SamplePointer pointer, PlanarImage maskImage, BinningContext binningContext) {
            super(product, pointer, binningContext);
            this.maskImage = maskImage;
        }

        @Override
        protected Observation getNextObservation() {
            SamplePointer pointer = this.getPointer();
            while (pointer.canMove()) {
                Observation observation;
                pointer.move();
                if (!this.isSampleValid(pointer.getX(), pointer.getY()) || (observation = this.createObservation(pointer.getX(), pointer.getY())) == null) continue;
                return observation;
            }
            return null;
        }

        private boolean isSampleValid(int x, int y) {
            if (this.maskTile == null || !this.maskTile.getBounds().contains(x, y)) {
                int tileX = this.maskImage.XToTileX(x);
                int tileY = this.maskImage.YToTileY(y);
                this.maskTile = this.maskImage.getTile(tileX, tileY);
            }
            return this.maskTile.getSample(x, y, 0) != 0;
        }
    }
}

