/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import org.esa.beam.dataio.avhrr.noaa.FormatMetadata;
import org.esa.beam.dataio.avhrr.noaa.TypeUtils;

final class PodTypes {
    private static final CompoundType TIME_CODE_TYPE = TypeBuilder.COMPOUND((String)"TIME_CODE", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"YEAR_DAY", (Type)SimpleType.USHORT), TypeBuilder.MEMBER((String)"MILLISECONDS", (Type)SimpleType.UINT)});
    private static final CompoundType CALIBRATION_COEFFICIENTS_TYPE = TypeBuilder.COMPOUND((String)"", (CompoundMember[])new CompoundMember[]{TypeUtils.META_MEMBER("SLOPE", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(9.313225746154785E-10)), TypeUtils.META_MEMBER("INTERCEPT", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(2.384185791015625E-7))});
    private static final CompoundType EARTH_LOCATION_TYPE = TypeBuilder.COMPOUND((String)"", (CompoundMember[])new CompoundMember[]{TypeUtils.META_MEMBER("LAT", (Type)SimpleType.SHORT, TypeUtils.META().setScalingFactor(0.0078125).setUnits("degrees north")), TypeUtils.META_MEMBER("LON", (Type)SimpleType.SHORT, TypeUtils.META().setScalingFactor(0.0078125).setUnits("degrees east"))});
    private static final CompoundType KEPLERIAN_ORBITAL_ELEMENTS_TYPE = TypeBuilder.COMPOUND((String)"KEPLERIAN_ORBITAL_ELEMENTS", (CompoundMember[])new CompoundMember[]{TypeUtils.META_MEMBER("SEMI_MAJOR_AXIS", (Type)SimpleType.UINT, TypeUtils.META().setScalingFactor(0.001).setUnits("km")), TypeUtils.META_MEMBER("ECCENTRICITY", (Type)SimpleType.UINT, TypeUtils.META().setScalingFactor(1.0E-8)), TypeUtils.META_MEMBER("INCLINATION", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("degree")), TypeUtils.META_MEMBER("ARGUMENT_OF_PERIGEE", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("degree")), TypeUtils.META_MEMBER("RIGHT_ASCENSION_OF_THE_ASCENDING_NODE", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("degree")), TypeUtils.META_MEMBER("MEAN_ANOMALY", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-5).setUnits("degree"))});
    private static final CompoundType CARTESIAN_INERTIAL_ELEMENTS_TYPE = TypeBuilder.COMPOUND((String)"CARTESIAN_INERTIAL_ELEMENTS", (CompoundMember[])new CompoundMember[]{TypeUtils.META_MEMBER("X", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-4).setUnits("km")), TypeUtils.META_MEMBER("Y", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-4).setUnits("km")), TypeUtils.META_MEMBER("Z", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-4).setUnits("km")), TypeUtils.META_MEMBER("U", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-6).setUnits("km s-1")), TypeUtils.META_MEMBER("V", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-6).setUnits("km s-1")), TypeUtils.META_MEMBER("W", (Type)SimpleType.INT, TypeUtils.META().setScalingFactor(1.0E-6).setUnits("km s-1"))});
    private static final CompoundType DUMMY_RECORD_TYPE = TypeBuilder.COMPOUND((String)"DUMMY_RECORD", (CompoundMember[])new CompoundMember[]{TypeUtils.FILL_MEMBER(7400)});
    static final CompoundType TBM_HEADER_RECORD_TYPE = TypeBuilder.COMPOUND((String)"TBM_HEADER_RECORD", (CompoundMember[])new CompoundMember[]{TypeUtils.FILL_MEMBER(30), TypeUtils.STRING_MEMBER("DATASET_NAME", 44), TypeUtils.STRING_MEMBER("TOTAL_OR_SELECTIVE_COPY", 1), TypeUtils.STRING_MEMBER("BEGINNING_LATITUDE", 3), TypeUtils.STRING_MEMBER("ENDING_LATITUDE", 3), TypeUtils.STRING_MEMBER("BEGINNING_LONGITUDE", 4), TypeUtils.STRING_MEMBER("ENDING_LONGITUDE", 4), TypeUtils.STRING_MEMBER("START_HOUR", 2), TypeUtils.STRING_MEMBER("START_MINUTE", 2), TypeUtils.STRING_MEMBER("NUMBER_OF_MINUTES", 3), TypeUtils.STRING_MEMBER("APPENDED_DATA_SELECTION", 1), TypeBuilder.MEMBER((String)"CHANNELS_SELECTED", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.UBYTE, (int)20)), TypeUtils.STRING_MEMBER("SENSOR_DATA_WORD_SIZE", 2), TypeUtils.FILL_MEMBER(3)});
    static final CompoundType DATASET_HEADER_RECORD_TYPE = TypeBuilder.COMPOUND((String)"DATASET_HEADER_RECORD", (CompoundMember[])new CompoundMember[]{TypeUtils.STRING_MEMBER("PROCESSING_BLOCK_ID", 7), TypeBuilder.MEMBER((String)"RAMP_AUTO_CALIBRATION", (Type)SimpleType.UBYTE), TypeBuilder.MEMBER((String)"NUMBER_OF_DATA_GAPS", (Type)SimpleType.USHORT), TypeBuilder.MEMBER((String)"DACS_QUALITY", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.USHORT, (int)3)), TypeUtils.STRING_MEMBER("CALIBRATION_PARAMETER_ID", 2), TypeBuilder.MEMBER((String)"DACS_STATUS", (Type)SimpleType.UBYTE), TypeBuilder.MEMBER((String)"MOUNTING_AND_FIXED_ATTITUDE_INDICATOR", (Type)SimpleType.UBYTE), TypeBuilder.MEMBER((String)"NADIR_EARTH_LOCATION_TOLERANCE", (Type)SimpleType.UBYTE), TypeUtils.FILL_MEMBER(1), TypeBuilder.MEMBER((String)"YEAR_FOR_START_OF_DATA", (Type)SimpleType.USHORT), TypeUtils.STRING_MEMBER("DATASET_NAME", 44), TypeBuilder.MEMBER((String)"YEAR_OF_EPOCH_FOR_ORBIT_VECTOR", (Type)SimpleType.USHORT), TypeBuilder.MEMBER((String)"JULIAN_DAY_OF_EPOCH", (Type)SimpleType.USHORT), TypeBuilder.MEMBER((String)"MILLISECOND_UTC_EPOCH_TIME_OF_DAY", (Type)SimpleType.UINT), TypeBuilder.MEMBER((String)"KEPLERIAN_ORBITAL_ELEMENTS", (Type)KEPLERIAN_ORBITAL_ELEMENTS_TYPE), TypeBuilder.MEMBER((String)"CARTESIAN_INERTIAL_ELEMENTS", (Type)CARTESIAN_INERTIAL_ELEMENTS_TYPE), TypeBuilder.MEMBER((String)"YAW_FIXED_ERROR_CORRECTION", (Type)SimpleType.SHORT), TypeBuilder.MEMBER((String)"ROLL_FIXED_ERROR_CORRECTION", (Type)SimpleType.SHORT), TypeBuilder.MEMBER((String)"PITCH_FIXED_ERROR_CORRECTION", (Type)SimpleType.SHORT), TypeUtils.FILL_MEMBER(7308 - KEPLERIAN_ORBITAL_ELEMENTS_TYPE.getSize() - CARTESIAN_INERTIAL_ELEMENTS_TYPE.getSize() - 2 - 2 - 2)});
    static final CompoundType DATA_RECORD_TYPE = TypeBuilder.COMPOUND((String)"DATA_RECORD", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"SCAN_LINE_NUMBER", (Type)SimpleType.USHORT), TypeBuilder.MEMBER((String)"TIME_CODE", (Type)TIME_CODE_TYPE), TypeBuilder.MEMBER((String)"QUALITY_INDICATORS", (Type)SimpleType.UINT), TypeBuilder.MEMBER((String)"CALIBRATION_COEFFICIENTS", (Type)TypeBuilder.SEQUENCE((Type)CALIBRATION_COEFFICIENTS_TYPE, (int)5)), TypeBuilder.MEMBER((String)"NUMBER_OF_MEANINGFUL_ZENITH_ANGLES_AND_EARTH_LOCATION_POINTS", (Type)SimpleType.UBYTE), TypeUtils.META_MEMBER("SOLAR_ZENITH_ANGLES", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.UBYTE, (int)51), TypeUtils.META().setScalingFactor(0.5).setUnits("degree")), TypeBuilder.MEMBER((String)"EARTH_LOCATION", (Type)TypeBuilder.SEQUENCE((Type)EARTH_LOCATION_TYPE, (int)51)), TypeBuilder.MEMBER((String)"TELEMETRY", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.UBYTE, (int)140)), TypeBuilder.MEMBER((String)"VIDEO_DATA", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.UINT, (int)3414)), TypeBuilder.MEMBER((String)"DECIMAL_PORTION_OF_SOLAR_ZENITH_ANGLES", (Type)TypeBuilder.SEQUENCE((Type)SimpleType.UBYTE, (int)20)), TypeBuilder.MEMBER((String)"CLOCK_DRIFT_DELTA", (Type)SimpleType.USHORT), TypeUtils.FILL_MEMBER(674)});
    static final CompoundType HRPT_TYPE = TypeBuilder.COMPOUND((String)"HRPT", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"TBM_HEADER_RECORD", (Type)TBM_HEADER_RECORD_TYPE), TypeBuilder.MEMBER((String)"SPACECRAFT_ID", (Type)SimpleType.UBYTE), TypeBuilder.MEMBER((String)"DATA_TYPE", (Type)SimpleType.UBYTE), TypeBuilder.MEMBER((String)"START_TIME", (Type)TIME_CODE_TYPE), TypeBuilder.MEMBER((String)"NUMBER_OF_SCANS", (Type)SimpleType.USHORT), TypeBuilder.MEMBER((String)"END_TIME", (Type)TIME_CODE_TYPE), TypeBuilder.MEMBER((String)"DATASET_HEADER_RECORD", (Type)DATASET_HEADER_RECORD_TYPE), TypeBuilder.MEMBER((String)"DUMMY_RECORD", (Type)DUMMY_RECORD_TYPE), TypeBuilder.MEMBER((String)"DATA_RECORDS", (Type)TypeBuilder.VAR_SEQUENCE((Type)DATA_RECORD_TYPE, (String)"NUMBER_OF_SCANS"))});

    PodTypes() {
    }

    static FormatMetadata getSolarZenithAnglesMetadata() {
        return (FormatMetadata)DATA_RECORD_TYPE.getMember(5).getMetadata();
    }

    static FormatMetadata getLatMetadata() {
        return (FormatMetadata)EARTH_LOCATION_TYPE.getMember(0).getMetadata();
    }

    static FormatMetadata getLonMetadata() {
        return (FormatMetadata)EARTH_LOCATION_TYPE.getMember(1).getMetadata();
    }

    static FormatMetadata getSlopeMetadata() {
        return (FormatMetadata)CALIBRATION_COEFFICIENTS_TYPE.getMember(0).getMetadata();
    }

    static FormatMetadata getInterceptMetadata() {
        return (FormatMetadata)CALIBRATION_COEFFICIENTS_TYPE.getMember(1).getMetadata();
    }
}

