/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import org.esa.beam.dataio.avhrr.calibration.Calibrator;
import org.esa.beam.dataio.avhrr.noaa.pod.CalibratorFactory;
import org.esa.beam.dataio.avhrr.noaa.pod.CountsCalibrator;

final class CountsCalibratorFactory
implements CalibratorFactory {
    private final int channelIndex;
    private final Calibrator calibrator;

    CountsCalibratorFactory(int channelIndex) {
        this.channelIndex = channelIndex;
        this.calibrator = new CountsCalibrator(this);
    }

    @Override
    public Calibrator createCalibrator(int i) {
        return this.calibrator;
    }

    @Override
    public String getBandName() {
        return "counts_" + (this.channelIndex + 1);
    }

    @Override
    public String getBandUnit() {
        return "counts";
    }

    @Override
    public String getBandDescription() {
        return "Raw AVHRR video data";
    }
}

