/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.beam.dataio.avhrr.AvhrrFile;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.dataio.avhrr.noaa.KlmAvhrrFile;
import org.esa.beam.framework.datamodel.ProductData;

class FlagReader
implements BandReader {
    private KlmAvhrrFile avhrrFile;

    public FlagReader(KlmAvhrrFile avhrrFile) {
        this.avhrrFile = avhrrFile;
    }

    @Override
    public String getBandName() {
        return "flags";
    }

    @Override
    public String getBandUnit() {
        return null;
    }

    @Override
    public String getBandDescription() {
        return null;
    }

    @Override
    public double getScalingFactor() {
        return 1.0;
    }

    @Override
    public int getDataType() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AvhrrFile.RawCoordinates rawCoord = this.avhrrFile.getRawCoordinates(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight);
        byte[] flagsData = (byte[])destBuffer.getElems();
        int targetIdx = rawCoord.targetStart;
        pm.beginTask("Reading AVHRR band '" + this.getBandName() + "'...", rawCoord.maxY - rawCoord.minY);
        try {
            for (int sourceY = rawCoord.minY; sourceY <= rawCoord.maxY; sourceY += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                byte flag = this.readFlags(sourceY);
                for (int sourceX = rawCoord.minX; sourceX <= rawCoord.maxX; sourceX += sourceStepX) {
                    flagsData[targetIdx] = flag;
                    targetIdx += rawCoord.targetIncrement;
                }
                pm.done();
            }
        }
        finally {
            pm.done();
        }
    }

    private byte readFlags(int rawY) throws IOException {
        long[] flags = new long[6];
        CompoundData dataRecord = this.avhrrFile.getDataRecord(rawY);
        flags[0] = dataRecord.getUInt("QUALITY_INDICATOR_BIT_FIELD");
        flags[1] = dataRecord.getUInt("SCANLINE_QUALITY_FLAGS");
        flags[2] = dataRecord.getUShort("CALIBRATION_QUALITY_FLAGS_3B");
        flags[3] = dataRecord.getUShort("CALIBRATION_QUALITY_FLAGS_4");
        flags[4] = dataRecord.getUShort("CALIBRATION_QUALITY_FLAGS_5");
        flags[5] = dataRecord.getUShort("COUNT_OF_BIT_ERRORS_IN_FRAME_SYNC");
        byte flag = 0;
        for (int i = 0; i < flags.length; ++i) {
            flag = (byte)(flag | (flags[i] != 0L ? 1 : 0) << i);
        }
        return flag;
    }
}

