/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.beam.dataio.avhrr.AvhrrFile;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.dataio.avhrr.calibration.Calibrator;
import org.esa.beam.dataio.avhrr.noaa.KlmAvhrrFile;
import org.esa.beam.framework.datamodel.ProductData;

abstract class CountReader
implements BandReader {
    protected final Calibrator calibrator;
    protected final int[] calibrationData;
    protected final int[] lineOfCounts;
    protected final int channel;
    protected final KlmAvhrrFile noaaFile;

    public CountReader(int channel, KlmAvhrrFile noaaFile, Calibrator calibrator, int dataWidth) {
        this.channel = channel;
        this.noaaFile = noaaFile;
        this.calibrator = calibrator;
        this.calibrationData = new int[63];
        this.lineOfCounts = new int[dataWidth];
    }

    @Override
    public String getBandName() {
        return this.calibrator.getBandName();
    }

    @Override
    public String getBandUnit() {
        return this.calibrator.getBandUnit();
    }

    @Override
    public String getBandDescription() {
        return this.calibrator.getBandDescription();
    }

    @Override
    public double getScalingFactor() {
        return 1.0;
    }

    @Override
    public int getDataType() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AvhrrFile.RawCoordinates rawCoord = this.noaaFile.getRawCoordinates(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight);
        float[] targetData = (float[])destBuffer.getElems();
        int targetIdx = rawCoord.targetStart;
        pm.beginTask("Reading AVHRR band '" + this.getBandName() + "'...", rawCoord.maxY - rawCoord.minY);
        try {
            for (int rawY = rawCoord.minY; rawY <= rawCoord.maxY; rawY += sourceStepY) {
                int sourceX;
                if (pm.isCanceled()) {
                    break;
                }
                boolean validData = this.hasData(rawY);
                if (validData) {
                    if (this.calibrator.requiresCalibrationData()) {
                        this.readCalibrationCoefficients(rawY, this.calibrationData);
                        validData = this.calibrator.processCalibrationData(this.calibrationData);
                    }
                    if (validData) {
                        this.readData(rawY);
                        validData = this.containsValidCounts();
                        if (validData) {
                            for (sourceX = rawCoord.minX; sourceX <= rawCoord.maxX; sourceX += sourceStepX) {
                                targetData[targetIdx] = this.calibrator.calibrate(this.lineOfCounts[sourceX]);
                                targetIdx += rawCoord.targetIncrement;
                            }
                        }
                    }
                }
                if (!validData) {
                    for (sourceX = rawCoord.minX; sourceX <= rawCoord.maxX; sourceX += sourceStepX) {
                        targetData[targetIdx] = 0.0f;
                        targetIdx += rawCoord.targetIncrement;
                    }
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private boolean hasData(int rawY) throws IOException {
        if (this.channel != 2 && this.channel != 3) {
            return true;
        }
        int bitField = this.noaaFile.getScanlineBitfield(rawY);
        int channel3ab = bitField & 3;
        return channel3ab == 1 && this.channel == 2 || channel3ab == 0 && this.channel == 3;
    }

    private boolean containsValidCounts() {
        for (int i : this.lineOfCounts) {
            if (i > 0 && i < 1024) continue;
            return false;
        }
        return true;
    }

    private void readCalibrationCoefficients(int rawY, int[] calibCoeff) throws IOException {
        CompoundData dataRecord = this.noaaFile.getDataRecord(rawY);
        SequenceData calibration_coefficients = dataRecord.getSequence("CALIBRATION_COEFFICIENTS");
        for (int i = 0; i < calibCoeff.length; ++i) {
            calibCoeff[i] = calibration_coefficients.getInt(i);
        }
    }

    protected abstract void readData(int var1) throws IOException;
}

