/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.specklefilters;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.PolarimetricSpeckleFilterOp;
import org.csa.rstb.polarimetric.gpf.specklefilters.SpeckleFilter;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class RefinedLee
implements SpeckleFilter {
    private final PolarimetricSpeckleFilterOp operator;
    private final Product sourceProduct;
    private final Product targetProduct;
    private final PolBandUtils.MATRIX sourceProductType;
    private final PolBandUtils.PolSourceBand[] srcBandList;
    private final int filterSize;
    private final int halfFilterSize;
    private final int convSize;
    private final int stride;
    private final int subWindowSize;
    private final double sigmaV;
    private final double sigmaVSqr;
    private static final double NonValidPixelValue = -1.0;

    public RefinedLee(PolarimetricSpeckleFilterOp op, Product srcProduct, Product trgProduct, PolBandUtils.MATRIX sourceProductType, PolBandUtils.PolSourceBand[] srcBandList, int filterSize, int numLooks) {
        this.operator = op;
        this.sourceProduct = srcProduct;
        this.targetProduct = trgProduct;
        this.sourceProductType = sourceProductType;
        this.srcBandList = srcBandList;
        this.filterSize = filterSize;
        this.halfFilterSize = filterSize / 2;
        switch (filterSize) {
            case 5: {
                this.subWindowSize = 3;
                this.stride = 1;
                break;
            }
            case 7: {
                this.subWindowSize = 3;
                this.stride = 2;
                break;
            }
            case 9: {
                this.subWindowSize = 5;
                this.stride = 2;
                break;
            }
            case 11: {
                this.subWindowSize = 5;
                this.stride = 3;
                break;
            }
            default: {
                throw new OperatorException("Unknown window size: " + filterSize);
            }
        }
        this.convSize = filterSize * (this.halfFilterSize + 1);
        this.sigmaV = 1.0 / Math.sqrt(numLooks);
        this.sigmaVSqr = this.sigmaV * this.sigmaV;
    }

    @Override
    public void computeTiles(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        if (PolBandUtils.isFullPol((PolBandUtils.MATRIX)this.sourceProductType)) {
            this.refinedLeeFilterFullPol(targetTiles, targetRectangle, sourceRectangle);
        } else if (PolBandUtils.isQuadPol((PolBandUtils.MATRIX)this.sourceProductType)) {
            this.refinedLeeFilterC3T3C4T4(targetTiles, targetRectangle, sourceRectangle);
        } else if (PolBandUtils.isDualPol((PolBandUtils.MATRIX)this.sourceProductType)) {
            this.refinedLeeFilterC2(targetTiles, targetRectangle, sourceRectangle);
        } else {
            throw new OperatorException("For Refined Lee filtering, only C2, C3, T3, C4 and T4 are supported");
        }
    }

    private void refinedLeeFilterC2(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        double[][] data11Real = new double[sh][sw];
        double[][] data12Real = new double[sh][sw];
        double[][] data12Imag = new double[sh][sw];
        double[][] data22Real = new double[sh][sw];
        double[][] span = new double[sh][sw];
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            Tile srcTile = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[0], sourceRectangle);
            this.createC2SpanImage(srcTile, this.sourceProductType, sourceRectangle, dataBuffers, data11Real, data12Real, data12Imag, data22Real, span);
            for (Band targetBand : bandList.targetBands) {
                Tile targetTile = targetTiles.get(targetBand);
                TileIndex trgIndex = new TileIndex(targetTile);
                String trgBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (trgBandName.equals("C11")) {
                    this.computeFilteredTile(x0, y0, maxX, maxY, sourceRectangle, data11Real, span, trgIndex, dataBuffer);
                    continue;
                }
                if (trgBandName.contains("C12_real")) {
                    this.computeFilteredTile(x0, y0, maxX, maxY, sourceRectangle, data12Real, span, trgIndex, dataBuffer);
                    continue;
                }
                if (trgBandName.contains("C12_imag")) {
                    this.computeFilteredTile(x0, y0, maxX, maxY, sourceRectangle, data12Imag, span, trgIndex, dataBuffer);
                    continue;
                }
                if (!trgBandName.equals("C22")) continue;
                this.computeFilteredTile(x0, y0, maxX, maxY, sourceRectangle, data22Real, span, trgIndex, dataBuffer);
            }
        }
    }

    private void computeFilteredTile(int x0, int y0, int maxX, int maxY, Rectangle sourceRectangle, double[][] data, double[][] span, TileIndex trgIndex, ProductData dataBuffer) {
        int filterSize2 = this.filterSize * this.filterSize;
        double[][] neighborSpanValues = new double[this.filterSize][this.filterSize];
        double[][] neighborPixelValues = new double[this.filterSize][this.filterSize];
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int n = this.getLocalData(x, y, sourceRectangle, data, span, neighborPixelValues, neighborSpanValues);
                double v = n < filterSize2 ? this.computePixelValueUsingLocalStatistics(neighborPixelValues) : this.computePixelValueUsingEdgeDetection(neighborPixelValues, neighborSpanValues);
                dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)v);
            }
        }
    }

    private void refinedLeeFilterFullPol(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        double[][] data11Real = new double[sh][sw];
        double[][] data12Real = new double[sh][sw];
        double[][] data12Imag = new double[sh][sw];
        double[][] data13Real = new double[sh][sw];
        double[][] data13Imag = new double[sh][sw];
        double[][] data22Real = new double[sh][sw];
        double[][] data23Real = new double[sh][sw];
        double[][] data23Imag = new double[sh][sw];
        double[][] data33Real = new double[sh][sw];
        double[][] span = new double[sh][sw];
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        int filterSize2 = this.filterSize * this.filterSize;
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            Tile srcTile = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[0], sourceRectangle);
            this.createT3SpanImage(srcTile, this.sourceProductType, sourceRectangle, dataBuffers, data11Real, data12Real, data12Imag, data13Real, data13Imag, data22Real, data23Real, data23Imag, data33Real, span);
            double[][] neighborSpanValues = new double[this.filterSize][this.filterSize];
            double[][] neighborPixelValues = new double[this.filterSize][this.filterSize];
            ProductData[] targetDataBuffers = new ProductData[9];
            for (Band targetBand : bandList.targetBands) {
                String trgBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (targetDataBuffers[0] == null && (trgBandName.equals("T11") || trgBandName.contains("T11_"))) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[1] == null && trgBandName.contains("T12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[2] == null && trgBandName.contains("T12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[3] == null && trgBandName.contains("T13_real")) {
                    targetDataBuffers[3] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[4] == null && trgBandName.contains("T13_imag")) {
                    targetDataBuffers[4] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[5] == null && (trgBandName.equals("T22") || trgBandName.contains("T22_"))) {
                    targetDataBuffers[5] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[6] == null && trgBandName.contains("T23_real")) {
                    targetDataBuffers[6] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[7] == null && trgBandName.contains("T23_imag")) {
                    targetDataBuffers[7] = dataBuffer;
                    continue;
                }
                if (targetDataBuffers[8] != null || !trgBandName.equals("T33") && !trgBandName.contains("T33_")) continue;
                targetDataBuffers[8] = dataBuffer;
            }
            int i = 0;
            for (SpeckleFilter.T3Elem elem : SpeckleFilter.T3Elem.values()) {
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        int idx = trgIndex.getIndex(x);
                        int n = 0;
                        switch (elem) {
                            case T11: {
                                n = this.getLocalData(x, y, sourceRectangle, data11Real, span, neighborPixelValues, neighborSpanValues);
                                i = 0;
                                break;
                            }
                            case T12_real: {
                                n = this.getLocalData(x, y, sourceRectangle, data12Real, span, neighborPixelValues, neighborSpanValues);
                                i = 1;
                                break;
                            }
                            case T12_imag: {
                                n = this.getLocalData(x, y, sourceRectangle, data12Imag, span, neighborPixelValues, neighborSpanValues);
                                i = 2;
                                break;
                            }
                            case T13_real: {
                                n = this.getLocalData(x, y, sourceRectangle, data13Real, span, neighborPixelValues, neighborSpanValues);
                                i = 3;
                                break;
                            }
                            case T13_imag: {
                                n = this.getLocalData(x, y, sourceRectangle, data13Imag, span, neighborPixelValues, neighborSpanValues);
                                i = 4;
                                break;
                            }
                            case T22: {
                                n = this.getLocalData(x, y, sourceRectangle, data22Real, span, neighborPixelValues, neighborSpanValues);
                                i = 5;
                                break;
                            }
                            case T23_real: {
                                n = this.getLocalData(x, y, sourceRectangle, data23Real, span, neighborPixelValues, neighborSpanValues);
                                i = 6;
                                break;
                            }
                            case T23_imag: {
                                n = this.getLocalData(x, y, sourceRectangle, data23Imag, span, neighborPixelValues, neighborSpanValues);
                                i = 7;
                                break;
                            }
                            case T33: {
                                n = this.getLocalData(x, y, sourceRectangle, data33Real, span, neighborPixelValues, neighborSpanValues);
                                i = 8;
                                break;
                            }
                        }
                        if (n < filterSize2) {
                            targetDataBuffers[i].setElemFloatAt(idx, (float)this.computePixelValueUsingLocalStatistics(neighborPixelValues));
                            continue;
                        }
                        targetDataBuffers[i].setElemFloatAt(idx, (float)this.computePixelValueUsingEdgeDetection(neighborPixelValues, neighborSpanValues));
                    }
                }
            }
        }
    }

    private double computePixelValueUsingLocalStatistics(double[][] neighborPixelValues) {
        double meanY = this.getLocalMeanValue(neighborPixelValues);
        double varY = this.getLocalVarianceValue(meanY, neighborPixelValues);
        if (varY == 0.0) {
            return 0.0;
        }
        double varX = (varY - meanY * meanY * this.sigmaVSqr) / (1.0 + this.sigmaVSqr);
        if (varX < 0.0) {
            varX = 0.0;
        }
        double b = varX / varY;
        return meanY + b * (neighborPixelValues[this.halfFilterSize][this.halfFilterSize] - meanY);
    }

    private double computePixelValueUsingEdgeDetection(double[][] neighborPixelValues, double[][] neighborSpanValues) {
        double[][] subAreaMeans = new double[3][3];
        RefinedLee.computeSubAreaMeans(this.stride, this.subWindowSize, neighborSpanValues, subAreaMeans);
        int d = RefinedLee.getDirection(subAreaMeans);
        double[] spanPixels = new double[this.convSize];
        this.getNonEdgeAreaPixelValues(neighborSpanValues, d, spanPixels);
        double meanY = this.getMeanValue(spanPixels);
        double varY = this.getVarianceValue(spanPixels, meanY);
        if (varY == 0.0) {
            return 0.0;
        }
        double varX = (varY - meanY * meanY * this.sigmaVSqr) / (1.0 + this.sigmaVSqr);
        if (varX < 0.0) {
            varX = 0.0;
        }
        double b = varX / varY;
        double[] covElemPixels = new double[this.convSize];
        this.getNonEdgeAreaPixelValues(neighborPixelValues, d, covElemPixels);
        double meanZ = this.getMeanValue(covElemPixels);
        return meanZ + b * (neighborPixelValues[this.halfFilterSize][this.halfFilterSize] - meanZ);
    }

    private double getLocalMeanValue(double[][] neighborPixelValues) {
        int k = 0;
        double mean = 0.0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (neighborPixelValues[j][i] == -1.0) continue;
                mean += neighborPixelValues[j][i];
                ++k;
            }
        }
        return mean / (double)k;
    }

    private double getLocalVarianceValue(double mean, double[][] neighborPixelValues) {
        int k = 0;
        double var = 0.0;
        for (int j = 0; j < this.filterSize; ++j) {
            for (int i = 0; i < this.filterSize; ++i) {
                if (neighborPixelValues[j][i] == -1.0) continue;
                double diff = neighborPixelValues[j][i] - mean;
                var += diff * diff;
                ++k;
            }
        }
        return var / (double)(k - 1);
    }

    private static void computeSubAreaMeans(int stride, int subWindowSize, double[][] neighborPixelValues, double[][] subAreaMeans) {
        double subWindowSizeSqr = subWindowSize * subWindowSize;
        for (int j = 0; j < 3; ++j) {
            int y0 = j * stride;
            for (int i = 0; i < 3; ++i) {
                int x0 = i * stride;
                double mean = 0.0;
                for (int y = y0; y < y0 + subWindowSize; ++y) {
                    for (int x = x0; x < x0 + subWindowSize; ++x) {
                        mean += neighborPixelValues[y][x];
                    }
                }
                subAreaMeans[j][i] = mean / subWindowSizeSqr;
            }
        }
    }

    private static int getDirection(double[][] subAreaMeans) {
        double[] gradient = new double[]{subAreaMeans[0][2] + subAreaMeans[1][2] + subAreaMeans[2][2] - subAreaMeans[0][0] - subAreaMeans[1][0] - subAreaMeans[2][0], subAreaMeans[0][1] + subAreaMeans[0][2] + subAreaMeans[1][2] - subAreaMeans[1][0] - subAreaMeans[2][0] - subAreaMeans[2][1], subAreaMeans[0][0] + subAreaMeans[0][1] + subAreaMeans[0][2] - subAreaMeans[2][0] - subAreaMeans[2][1] - subAreaMeans[2][2], subAreaMeans[0][0] + subAreaMeans[0][1] + subAreaMeans[1][0] - subAreaMeans[1][2] - subAreaMeans[2][1] - subAreaMeans[2][2]};
        int direction = 0;
        double maxGradient = -1.0;
        for (int i = 0; i < 4; ++i) {
            double absGrad = Math.abs(gradient[i]);
            if (!(maxGradient < absGrad)) continue;
            maxGradient = absGrad;
            direction = i;
        }
        if (gradient[direction] > 0.0) {
            direction += 4;
        }
        return direction;
    }

    private void getNonEdgeAreaPixelValues(double[][] neighborPixelValues, int d, double[] pixels) {
        switch (d) {
            case 0: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = this.halfFilterSize; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 1: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = y; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 2: {
                int k = 0;
                for (int y = 0; y <= this.halfFilterSize; ++y) {
                    for (int x = 0; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 3: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = 0; x < this.filterSize - y; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 4: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = 0; x <= this.halfFilterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 5: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = 0; x < y + 1; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 6: {
                int k = 0;
                for (int y = this.halfFilterSize; y < this.filterSize; ++y) {
                    for (int x = 0; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
            case 7: {
                int k = 0;
                for (int y = 0; y < this.filterSize; ++y) {
                    for (int x = this.filterSize - 1 - y; x < this.filterSize; ++x) {
                        pixels[k] = neighborPixelValues[y][x];
                        ++k;
                    }
                }
                break;
            }
        }
    }

    private void refinedLeeFilterC3T3C4T4(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int filterSize2 = this.filterSize * this.filterSize;
        double[][] neighborSpanValues = new double[this.filterSize][this.filterSize];
        double[][] neighborPixelValues = new double[this.filterSize][this.filterSize];
        int syMax = sy0 + sh;
        int sxMax = sx0 + sw;
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            double[][] span = new double[sh][sw];
            this.createSpanImage(bandList.srcBands, sourceRectangle, span);
            for (Band targetBand : bandList.targetBands) {
                Tile targetTile = targetTiles.get(targetBand);
                Tile sourceTile = this.operator.getSourceTile((RasterDataNode)this.sourceProduct.getBand(targetBand.getName()), sourceRectangle);
                TileIndex trgIndex = new TileIndex(targetTile);
                TileIndex srcIndex = new TileIndex(sourceTile);
                ProductData dataBuffer = targetTile.getDataBuffer();
                float[] srcData = sourceTile.getDataBufferFloat();
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    int yhalf = y - this.halfFilterSize;
                    for (int x = x0; x < maxX; ++x) {
                        int xhalf = x - this.halfFilterSize;
                        int n = this.getNeighborValuesWithoutBorderExt(xhalf, yhalf, sx0, sy0, syMax, sxMax, neighborPixelValues, span, neighborSpanValues, srcIndex, srcData);
                        double v = n < filterSize2 ? this.computePixelValueUsingLocalStatistics(neighborPixelValues) : this.computePixelValueUsingEdgeDetection(neighborPixelValues, neighborSpanValues);
                        dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)v);
                    }
                }
            }
        }
    }

    private int getLocalData(int xc, int yc, Rectangle sourceRectangle, double[][] data, double[][] span, double[][] neighborPixelValues, double[][] neighborSpanValues) {
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        int syMax = sy0 + sh;
        int sxMax = sx0 + sw;
        int yhalf = yc - this.halfFilterSize;
        int xhalf = xc - this.halfFilterSize;
        int k = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            int yj = yhalf + j;
            if (yj < sy0 || yj >= syMax) {
                for (int i = 0; i < this.filterSize; ++i) {
                    neighborPixelValues[j][i] = -1.0;
                    neighborSpanValues[j][i] = -1.0;
                }
                continue;
            }
            int spanY = yj - sy0;
            for (int i = 0; i < this.filterSize; ++i) {
                int xi = xhalf + i;
                if (xi < sx0 || xi >= sxMax) {
                    neighborPixelValues[j][i] = -1.0;
                    neighborSpanValues[j][i] = -1.0;
                    continue;
                }
                neighborPixelValues[j][i] = data[spanY][xi - sx0];
                neighborSpanValues[j][i] = span[spanY][xi - sx0];
                ++k;
            }
        }
        return k;
    }

    private void createSpanImage(Band[] sourceBands, Rectangle sourceTileRectangle, double[][] span) {
        Tile[] sourceTiles;
        if (this.sourceProductType == PolBandUtils.MATRIX.C3 || this.sourceProductType == PolBandUtils.MATRIX.T3) {
            sourceTiles = new Tile[3];
        } else if (this.sourceProductType == PolBandUtils.MATRIX.C4 || this.sourceProductType == PolBandUtils.MATRIX.T4) {
            sourceTiles = new Tile[4];
        } else {
            throw new OperatorException("Polarimetric Matrix not supported");
        }
        for (Band band : sourceBands) {
            String bandName = band.getName();
            if (PolBandUtils.isBandForMatrixElement((String)bandName, (String)"11")) {
                sourceTiles[0] = this.operator.getSourceTile((RasterDataNode)band, sourceTileRectangle);
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)bandName, (String)"22")) {
                sourceTiles[1] = this.operator.getSourceTile((RasterDataNode)band, sourceTileRectangle);
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)bandName, (String)"33")) {
                sourceTiles[2] = this.operator.getSourceTile((RasterDataNode)band, sourceTileRectangle);
                continue;
            }
            if (!PolBandUtils.isBandForMatrixElement((String)bandName, (String)"44")) continue;
            sourceTiles[3] = this.operator.getSourceTile((RasterDataNode)band, sourceTileRectangle);
        }
        int sx0 = sourceTileRectangle.x;
        int sy0 = sourceTileRectangle.y;
        int sw = sourceTileRectangle.width;
        int sh = sourceTileRectangle.height;
        int maxY = sy0 + sh;
        int maxX = sx0 + sw;
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        for (int y = sy0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            int spanY = y - sy0;
            for (int x = sx0; x < maxX; ++x) {
                int index = srcIndex.getIndex(x);
                double sum = 0.0;
                for (Tile srcTile : sourceTiles) {
                    sum += srcTile.getDataBuffer().getElemDoubleAt(index);
                }
                span[spanY][x - sx0] = sum / 4.0;
            }
        }
    }

    private int getNeighborValuesWithoutBorderExt(int xhalf, int yhalf, int sx0, int sy0, int syMax, int sxMax, double[][] neighborPixelValues, double[][] span, double[][] neighborSpanValues, TileIndex srcIndex, float[] srcData) {
        int k = 0;
        for (int j = 0; j < this.filterSize; ++j) {
            int yj = yhalf + j;
            if (yj < sy0 || yj >= syMax) {
                for (int i = 0; i < this.filterSize; ++i) {
                    neighborPixelValues[j][i] = -1.0;
                    neighborSpanValues[j][i] = -1.0;
                }
                continue;
            }
            int spanY = yj - sy0;
            srcIndex.calculateStride(yj);
            for (int i = 0; i < this.filterSize; ++i) {
                int xi = xhalf + i;
                if (xi < sx0 || xi >= sxMax) {
                    neighborPixelValues[j][i] = -1.0;
                    neighborSpanValues[j][i] = -1.0;
                    continue;
                }
                neighborPixelValues[j][i] = srcData[srcIndex.getIndex(xi)];
                neighborSpanValues[j][i] = span[spanY][xi - sx0];
                ++k;
            }
        }
        return k;
    }
}

