/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class GeneralizedFreemanDurden
extends DecompositionBase
implements Decomposition {
    private int srcImageWidth = 0;
    private int srcImageHeight = 0;

    public GeneralizedFreemanDurden(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, windowSize, srcImageWidth, srcImageHeight);
        this.srcImageWidth = srcImageWidth;
        this.srcImageHeight = srcImageHeight;
    }

    @Override
    public String getSuffix() {
        return "_FD";
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"Freeman_dbl_r", "Freeman_vol_g", "Freeman_surf_b"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Freeman_dbl_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Freeman_vol_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Freeman_surf_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Tr = new double[3][3];
            double[][] Ti = new double[3][3];
            if (!bandList.spanMinMaxSet) {
                this.setSpanMinMax(op, bandList);
            }
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            PolOpUtils.getDataBuffer(op, bandList.srcBands, sourceRectangle, this.sourceProductType, sourceTiles, dataBuffers);
            TileIndex srcIndex = new TileIndex(sourceTiles[0]);
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    PolOpUtils.getMeanCoherencyMatrix(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.srcImageWidth, this.srcImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                    FDD data = GeneralizedFreemanDurden.getGeneralizedFreemanDurdenDecomposition(Tr, Ti);
                    double ps = GeneralizedFreemanDurden.scaleDb(data.ps, bandList.spanMin, bandList.spanMax);
                    double pd = GeneralizedFreemanDurden.scaleDb(data.pd, bandList.spanMin, bandList.spanMax);
                    double pv = GeneralizedFreemanDurden.scaleDb(data.pv, bandList.spanMin, bandList.spanMax);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)pd);
                            continue;
                        }
                        if (target.colour == DecompositionBase.TargetBandColour.G) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)pv);
                            continue;
                        }
                        if (target.colour != DecompositionBase.TargetBandColour.B) continue;
                        target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)ps);
                    }
                }
            }
        }
    }

    public static FDD getGeneralizedFreemanDurdenDecomposition(double[][] Tr, double[][] Ti) {
        double mv = Tr[2][2];
        double tmp1 = Tr[0][0] + Tr[1][1] - 3.0 * Tr[2][2];
        double tmp2 = Tr[0][0] - Tr[1][1] - Tr[2][2];
        double tmp3 = Math.sqrt(tmp2 * tmp2 + 4.0 * (Tr[0][1] * Tr[0][1] + Ti[0][1] * Ti[0][1]));
        double ms = 0.5 * (tmp1 + tmp3);
        double md = 0.5 * (tmp1 - tmp3);
        return new FDD(4.0 * mv, md, ms);
    }

    public static class FDD {
        public final double pv;
        public final double pd;
        public final double ps;

        public FDD(double pv, double pd, double ps) {
            this.pd = pd;
            this.ps = ps;
            this.pv = pv;
        }
    }
}

