/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class FreemanDurden
extends DecompositionBase
implements Decomposition {
    public FreemanDurden(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String getSuffix() {
        return "_FD";
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"Freeman_dbl_r", "Freeman_vol_g", "Freeman_surf_b"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        targetBand.setUnit("intensity_db");
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Freeman_dbl_r")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Freeman_vol_g")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Freeman_surf_b")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            double[][] Cr = new double[3][3];
            double[][] Ci = new double[3][3];
            if (!bandList.spanMinMaxSet) {
                this.setSpanMinMax(op, bandList);
            }
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
            PolOpUtils.getDataBuffer(op, bandList.srcBands, sourceRectangle, this.sourceProductType, sourceTiles, dataBuffers);
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    PolOpUtils.getMeanCovarianceMatrix(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                    FDD data = FreemanDurden.getFreemanDurdenDecomposition(Cr, Ci);
                    double ps = FreemanDurden.scaleDb(data.ps, bandList.spanMin, bandList.spanMax);
                    double pd = FreemanDurden.scaleDb(data.pd, bandList.spanMin, bandList.spanMax);
                    double pv = FreemanDurden.scaleDb(data.pv, bandList.spanMin, bandList.spanMax);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)pd);
                            continue;
                        }
                        if (target.colour == DecompositionBase.TargetBandColour.G) {
                            target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)pv);
                            continue;
                        }
                        if (target.colour != DecompositionBase.TargetBandColour.B) continue;
                        target.dataBuffer.setElemFloatAt(trgIndex.getIndex(x), (float)ps);
                    }
                }
            }
        }
    }

    public static FDD getFreemanDurdenDecomposition(double[][] Cr, double[][] Ci) {
        double betaIm;
        double betaRe;
        double alphaIm;
        double alphaRe;
        double fd;
        double fs;
        double fv = 4.0 * Cr[1][1];
        double c11 = Cr[0][0] - fv * 3.0 / 8.0;
        double c13Re = Cr[0][2] - fv / 8.0;
        double c13Im = Ci[0][2];
        double c33 = Cr[2][2] - fv * 3.0 / 8.0;
        double a1 = c11 * c33;
        if (c11 <= 1.0E-15 || c33 <= 1.0E-15) {
            fs = 0.0;
            fd = 0.0;
            alphaRe = 0.0;
            alphaIm = 0.0;
            betaRe = 0.0;
            betaIm = 0.0;
        } else {
            double a2 = c13Re * c13Re + c13Im * c13Im;
            if (a1 < a2) {
                double c13 = Math.sqrt(a2);
                c13Re = Math.sqrt(a1) * c13Re / c13;
                c13Im = Math.sqrt(a1) * c13Im / c13;
            }
            if (c13Re < 0.0) {
                betaRe = 1.0;
                betaIm = 0.0;
                fs = Math.abs((a1 - c13Re * c13Re - c13Im * c13Im) / (c11 + c33 - 2.0 * c13Re));
                fd = Math.abs(c33 - fs);
                alphaRe = (c13Re - fs) / fd;
                alphaIm = c13Im / fd;
            } else {
                alphaRe = -1.0;
                alphaIm = 0.0;
                fd = Math.abs((a1 - c13Re * c13Re - c13Im * c13Im) / (c11 + c33 + 2.0 * c13Re));
                fs = Math.abs(c33 - fd);
                betaRe = (c13Re + fd) / fs;
                betaIm = c13Im / fs;
            }
        }
        double ps = fs * (1.0 + betaRe * betaRe + betaIm * betaIm);
        double pd = fd * (1.0 + alphaRe * alphaRe + alphaIm * alphaIm);
        double pv = fv;
        return new FDD(pv, pd, ps);
    }

    public static class FDD {
        public final double pv;
        public final double pd;
        public final double ps;

        public FDD(double pv, double pd, double ps) {
            this.pd = pd;
            this.ps = ps;
            this.pv = pv;
        }
    }
}

