/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Dimension;
import java.awt.Rectangle;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;

public class DecompositionBase {
    protected PolBandUtils.PolSourceBand[] srcBandList;
    protected final PolBandUtils.MATRIX sourceProductType;
    protected final int sourceImageWidth;
    protected final int sourceImageHeight;
    protected final int windowSizeX;
    protected final int windowSizeY;
    protected final int halfWindowSizeX;
    protected final int halfWindowSizeY;

    public DecompositionBase(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSizeX, int windowSizeY, int srcImageWidth, int srcImageHeight) {
        this.srcBandList = srcBandList;
        this.sourceProductType = sourceProductType;
        this.windowSizeX = windowSizeX;
        this.windowSizeY = windowSizeY;
        this.sourceImageWidth = srcImageWidth;
        this.sourceImageHeight = srcImageHeight;
        this.halfWindowSizeX = windowSizeX / 2;
        this.halfWindowSizeY = windowSizeY / 2;
    }

    protected Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int x0 = Math.max(0, tx0 - this.halfWindowSizeX);
        int y0 = Math.max(0, ty0 - this.halfWindowSizeY);
        int xMax = Math.min(tx0 + tw - 1 + this.halfWindowSizeX, this.sourceImageWidth - 1);
        int yMax = Math.min(ty0 + th - 1 + this.halfWindowSizeY, this.sourceImageHeight - 1);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MinMax computeSpanMinMax(final Operator op, final PolBandUtils.PolSourceBand bandList) throws OperatorException {
        final MinMax minMaxValue = new MinMax();
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)op.getSourceProduct(), (Dimension)tileSize, (int)25);
        final double[][] Cr = new double[3][3];
        final double[][] Ci = new double[3][3];
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Computing min max span... ", tileRectangles.length);
        try {
            ThreadManager threadManager = new ThreadManager();
            for (final Rectangle rectangle : tileRectangles) {
                Thread worker = new Thread(){
                    double span = 0.0;
                    final int xMax;
                    final int yMax;
                    final Tile[] sourceTiles;
                    final ProductData[] dataBuffers;
                    {
                        this.xMax = rectangle.x + rectangle.width;
                        this.yMax = rectangle.y + rectangle.height;
                        this.sourceTiles = new Tile[bandList.srcBands.length];
                        this.dataBuffers = new ProductData[bandList.srcBands.length];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            PolOpUtils.getDataBuffer(op, bandList.srcBands, rectangle, DecompositionBase.this.sourceProductType, this.sourceTiles, this.dataBuffers);
                            for (int y = rectangle.y; y < this.yMax; ++y) {
                                for (int x = rectangle.x; x < this.xMax; ++x) {
                                    MinMax minMax;
                                    PolOpUtils.getMeanCovarianceMatrix(x, y, DecompositionBase.this.halfWindowSizeX, DecompositionBase.this.halfWindowSizeX, DecompositionBase.this.sourceProductType, this.sourceTiles, this.dataBuffers, Cr, Ci);
                                    this.span = Cr[0][0] + Cr[1][1] + Cr[2][2];
                                    if (minMaxValue.min > this.span) {
                                        minMax = minMaxValue;
                                        synchronized (minMax) {
                                            minMaxValue.min = this.span;
                                        }
                                    }
                                    if (!(minMaxValue.max < this.span)) continue;
                                    minMax = minMaxValue;
                                    synchronized (minMax) {
                                        minMaxValue.max = this.span;
                                        continue;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
            if (minMaxValue.min < 1.0E-15) {
                minMaxValue.min = 1.0E-15;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " computeMinMaxSpan "), (Throwable)e);
        }
        finally {
            status.done();
        }
        return minMaxValue;
    }

    protected static double scaleDb(double p, double spanMin, double spanMax) {
        if (p < spanMin) {
            p = spanMin;
        }
        if (p > spanMax) {
            p = spanMax;
        }
        return 10.0 * Math.log10(p);
    }

    protected synchronized void setSpanMinMax(Operator op, PolBandUtils.PolSourceBand bandList) throws OperatorException {
        if (bandList.spanMinMaxSet) {
            return;
        }
        MinMax span = this.computeSpanMinMax(op, bandList);
        bandList.spanMin = span.min;
        bandList.spanMax = span.max;
        bandList.spanMinMaxSet = true;
    }

    public static class TargetInfo {
        public final Tile tile;
        public final ProductData dataBuffer;
        public final TargetBandColour colour;

        public TargetInfo(Tile tile, TargetBandColour col) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            this.colour = col;
        }
    }

    public static class MinMax {
        public double min = 1.0E30;
        public double max = -this.min;
    }

    public static enum TargetBandColour {
        R,
        G,
        B;

    }
}

