/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.csa.rstb.polarimetric.gpf.decompositions.hAAlpha;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.FilterWindow;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Polarimetric-Parameters", category="Radar/Polarimetric", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Compute general polarimetric parameters")
public final class PolarimetricParametersOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="Use mean coherency or covariance matrix", defaultValue="true", label="Use Mean Matrix")
    private boolean useMeanMatrix = true;
    @Parameter(valueSet={"3", "5", "7", "9", "11", "13", "15", "17", "19"}, defaultValue="5", label="Window Size X")
    private String windowSizeXStr = "5";
    @Parameter(valueSet={"3", "5", "7", "9", "11", "13", "15", "17", "19"}, defaultValue="5", label="Window Size Y")
    private String windowSizeYStr = "5";
    @Parameter(description="Output Span", defaultValue="true", label="Span")
    private boolean outputSpan = true;
    @Parameter(description="Output pedestal height", defaultValue="false", label="Pedestal Height")
    private boolean outputPedestalHeight = false;
    @Parameter(description="Output RVI", defaultValue="false", label="Radar Vegetation Index")
    private boolean outputRVI = false;
    @Parameter(description="Output RFDI", defaultValue="false", label="Radar Forest Degradation Index")
    private boolean outputRFDI = false;
    @Parameter(description="Output CSI", defaultValue="false", label="Canopy Structure Index")
    private boolean outputCSI = false;
    @Parameter(description="Output VSI", defaultValue="false", label="Volume Scattering Index")
    private boolean outputVSI = false;
    @Parameter(description="Output BMI", defaultValue="false", label="Biomass Index")
    private boolean outputBMI = false;
    @Parameter(description="Output ITI", defaultValue="false", label="Interaction Index")
    private boolean outputITI = false;
    @Parameter(description="Output Co-Pol HH/VV", defaultValue="false", label="HH/VV Ratio")
    private boolean outputHHVVRatio = false;
    @Parameter(description="Output Cross-Pol HH/HV", defaultValue="false", label="HH/HV Ratio")
    private boolean outputHHHVRatio = false;
    @Parameter(description="Output Cross-Pol VV/VH", defaultValue="false", label="VV/VH Ratio")
    private boolean outputVVVHRatio = false;
    private FilterWindow window;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean isComplex;
    private PolBandUtils.MATRIX sourceProductType = null;
    private PolBandUtils.PolSourceBand[] srcBandList;
    private Band hhBand = null;
    private Band hvBand = null;
    private Band vvBand = null;
    private Band vhBand = null;
    private static final String PRODUCT_SUFFIX = "_PP";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            this.isComplex = validator.isComplex();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            if (this.outputSpan || this.outputPedestalHeight || this.outputRVI) {
                if (this.sourceProductType == PolBandUtils.MATRIX.LCHCP || this.sourceProductType == PolBandUtils.MATRIX.RCHCP || this.sourceProductType == PolBandUtils.MATRIX.C2) {
                    throw new OperatorException("A quad-pol product is expected as input.");
                }
                if (this.sourceProductType == PolBandUtils.MATRIX.C3 || this.sourceProductType == PolBandUtils.MATRIX.T3 || this.sourceProductType == PolBandUtils.MATRIX.FULL) {
                    if (!this.isComplex && (this.outputSpan || this.outputPedestalHeight)) {
                        throw new OperatorException("A T3,C3, or quad-pol slc product is expected as input for span and pedistal height.");
                    }
                } else {
                    throw new OperatorException("A quad-pol product is expected as input.");
                }
            }
            for (Band srcBand : this.sourceProduct.getBands()) {
                String unit = srcBand.getUnit();
                String bandName = srcBand.getName().toUpperCase();
                if (!unit.equals("intensity")) continue;
                if (bandName.contains("_HH")) {
                    this.hhBand = srcBand;
                    continue;
                }
                if (bandName.contains("_HV")) {
                    this.hvBand = srcBand;
                    continue;
                }
                if (bandName.contains("_VV")) {
                    this.vvBand = srcBand;
                    continue;
                }
                if (!bandName.contains("_VH")) continue;
                this.vhBand = srcBand;
            }
            if ((this.outputHHVVRatio || this.outputCSI || this.outputBMI) && (this.hhBand == null || this.vvBand == null)) {
                throw new OperatorException("Input product containing HH and VV bands is required");
            }
            if ((this.outputRFDI || this.outputHHHVRatio) && (this.hhBand == null || this.hvBand == null)) {
                throw new OperatorException("Input product containing HH and HV bands is required");
            }
            if (this.outputVVVHRatio && (this.vvBand == null || this.vhBand == null)) {
                throw new OperatorException("Input product containing VV and VH bands is required");
            }
            if (this.outputVSI && (this.hhBand == null || this.vvBand == null || this.hvBand == null || this.vhBand == null)) {
                throw new OperatorException("Input product containing HH, VV, HV and VH bands is required");
            }
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.window = new FilterWindow(Integer.parseInt(this.windowSizeXStr), Integer.parseInt(this.windowSizeYStr));
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        String[] targetBandNames = this.getTargetBandNames();
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Band[] targetBands = OperatorUtils.addBands((Product)this.targetProduct, (String[])targetBandNames, (String)bandList.suffix);
            bandList.addTargetBands(targetBands);
        }
        if (this.targetProduct.getNumBands() == 0) {
            throw new OperatorException("No output bands selected");
        }
    }

    private String[] getTargetBandNames() {
        ArrayList<String> targetBandNameList = new ArrayList<String>(13);
        if (this.outputSpan) {
            targetBandNameList.add(BandType.Span.toString());
        }
        if (this.outputPedestalHeight) {
            targetBandNameList.add(BandType.PedestalHeight.toString());
        }
        if (this.outputRVI) {
            targetBandNameList.add(BandType.RVI.toString());
        }
        if (this.outputRFDI) {
            targetBandNameList.add(BandType.RFDI.toString());
        }
        if (this.outputCSI) {
            targetBandNameList.add(BandType.CSI.toString());
        }
        if (this.outputVSI) {
            targetBandNameList.add(BandType.VSI.toString());
        }
        if (this.outputBMI) {
            targetBandNameList.add(BandType.BMI.toString());
        }
        if (this.outputITI) {
            targetBandNameList.add(BandType.ITI.toString());
        }
        if (this.outputHHVVRatio) {
            targetBandNameList.add(BandType.HHVVRatio.toString());
        }
        if (this.outputHHHVRatio) {
            targetBandNameList.add(BandType.HHHVRatio.toString());
        }
        if (this.outputVVVHRatio) {
            targetBandNameList.add(BandType.VVVHRatio.toString());
        }
        return targetBandNameList.toArray(new String[targetBandNameList.size()]);
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absRoot != null) {
            absRoot.setAttributeInt("polsar_data", 1);
        }
        PolBandUtils.saveNewBandNames((Product)this.targetProduct, (PolBandUtils.PolSourceBand[])this.srcBandList);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        Rectangle sourceRectangle = this.window.getSourceTileRectangle(x0, y0, w, h, this.sourceImageWidth, this.sourceImageHeight);
        boolean computePolarimetricParam = this.isComplex && (this.outputSpan || this.outputPedestalHeight || this.outputRVI);
        Tile hhTile = null;
        Tile hvTile = null;
        Tile vvTile = null;
        Tile vhTile = null;
        if (this.hhBand != null) {
            hhTile = this.getSourceTile((RasterDataNode)this.hhBand, sourceRectangle);
        }
        if (this.hvBand != null) {
            hvTile = this.getSourceTile((RasterDataNode)this.hvBand, sourceRectangle);
        }
        if (this.vvBand != null) {
            vvTile = this.getSourceTile((RasterDataNode)this.vvBand, sourceRectangle);
        }
        if (this.vhBand != null) {
            vhTile = this.getSourceTile((RasterDataNode)this.vhBand, sourceRectangle);
        }
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            try {
                TileData[] tileDataList = new TileData[bandList.targetBands.length];
                int i = 0;
                for (Band targetBand : bandList.targetBands) {
                    Tile targetTile = targetTiles.get(targetBand);
                    tileDataList[i++] = new TileData(targetTile, targetBand.getName());
                }
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                for (int j = 0; j < bandList.srcBands.length; ++j) {
                    Band srcBand = bandList.srcBands[j];
                    sourceTiles[j] = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle);
                    dataBuffers[j] = sourceTiles[j].getDataBuffer();
                }
                TileIndex srcIndex = new TileIndex(sourceTiles[0]);
                PolarimetricParameters param = null;
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    srcIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        int tgtIdx = trgIndex.getIndex(x);
                        if (computePolarimetricParam) {
                            if (this.useMeanMatrix) {
                                PolOpUtils.getMeanCoherencyMatrix(x, y, this.window.getHalfWindowSizeX(), this.window.getHalfWindowSizeY(), this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                            } else {
                                PolOpUtils.getCoherencyMatrixT3(srcIndex.getIndex(x), this.sourceProductType, dataBuffers, Tr, Ti);
                            }
                            param = PolarimetricParametersOp.computePolarimetricParameters(Tr, Ti);
                        }
                        float hh = 0.0f;
                        float hv = 0.0f;
                        float vv = 0.0f;
                        float vh = 0.0f;
                        if (hhTile != null) {
                            hh = (float)Math.sqrt(hhTile.getSampleFloat(x, y));
                        }
                        if (hvTile != null) {
                            hv = (float)Math.sqrt(hvTile.getSampleFloat(x, y));
                        }
                        if (vvTile != null) {
                            vv = (float)Math.sqrt(vvTile.getSampleFloat(x, y));
                        }
                        if (vhTile != null) {
                            vh = (float)Math.sqrt(vhTile.getSampleFloat(x, y));
                        }
                        for (TileData tileData : tileDataList) {
                            if (this.outputSpan && tileData.bandType.equals((Object)BandType.Span)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)param.Span);
                            }
                            if (this.outputPedestalHeight && tileData.bandType.equals((Object)BandType.PedestalHeight)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)param.PedestalHeight);
                            }
                            if (this.outputRVI && tileData.bandType.equals((Object)BandType.RVI)) {
                                if (param == null) {
                                    tileData.dataBuffer.setElemFloatAt(tgtIdx, 8.0f * hv / (hh + vv + 2.0f * hv));
                                } else {
                                    tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)param.RVI);
                                }
                            }
                            if (this.outputRFDI && tileData.bandType.equals((Object)BandType.RFDI)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (hh - hv) / (hh + hv));
                            }
                            if (this.outputCSI && tileData.bandType.equals((Object)BandType.CSI)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, vv / (vv + hh));
                            }
                            if (this.outputBMI && tileData.bandType.equals((Object)BandType.BMI)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (vv + hh) / 2.0f);
                            }
                            if (this.outputVSI && tileData.bandType.equals((Object)BandType.VSI)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (hv + vh) / (hh + vv + hv + vh));
                            }
                            if (this.outputITI && tileData.bandType.equals((Object)BandType.ITI)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, hh / vv);
                            }
                            if (this.outputHHVVRatio && tileData.bandType.equals((Object)BandType.HHVVRatio)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, hh / vv);
                            }
                            if (this.outputHHHVRatio && tileData.bandType.equals((Object)BandType.HHHVRatio)) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, hh / hv);
                            }
                            if (!this.outputVVVHRatio || !tileData.bandType.equals((Object)BandType.VVVHRatio)) continue;
                            tileData.dataBuffer.setElemFloatAt(tgtIdx, vv / vh);
                        }
                    }
                }
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    public static PolarimetricParameters computePolarimetricParameters(double[][] Tr, double[][] Ti) {
        PolarimetricParameters parameters = new PolarimetricParameters();
        parameters.Span = 2.0 * (Tr[0][0] + Tr[1][1] + Tr[2][2]);
        hAAlpha.HAAlpha data = hAAlpha.computeHAAlpha(Tr, Ti);
        parameters.PedestalHeight = data.lambda3 / data.lambda1;
        parameters.RVI = 4.0 * data.lambda3 / (data.lambda1 + data.alpha2 + data.lambda3);
        return parameters;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PolarimetricParametersOp.class);
        }
    }

    public static class PolarimetricParameters {
        public double Span;
        public double PedestalHeight;
        public double RVI;
    }

    private static class TileData {
        final Tile tile;
        final ProductData dataBuffer;
        final String bandName;
        final BandType bandType;

        public TileData(Tile tile, String bandName) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            this.bandName = bandName;
            this.bandType = BandType.valueOf(bandName);
        }
    }

    private static enum BandType {
        Span,
        PedestalHeight,
        RVI,
        RFDI,
        CSI,
        VSI,
        BMI,
        ITI,
        HHVVRatio,
        HHHVRatio,
        VVVHRatio;

    }
}

