/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.DualPolOpUtils;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Polarimetric-Matrices", category="Radar/Polarimetric", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Generates covariance or coherency matrix for given product")
public final class PolarimetricMatricesOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"C2", "C3", "C4", "T3", "T4"}, description="The covariance or coherency matrix", defaultValue="T3", label="Polarimetric Matrix")
    private String matrix = "T3";
    private PolBandUtils.PolSourceBand[] srcBandList;
    private final Map<Band, MatrixElem> matrixBandMap = new HashMap<Band, MatrixElem>(8);
    private PolBandUtils.MATRIX matrixType = PolBandUtils.MATRIX.C3;
    private PolBandUtils.MATRIX sourceProductType = null;
    public static final String C2 = "C2";
    public static final String C3 = "C3";
    public static final String C4 = "C4";
    public static final String T3 = "T3";
    public static final String T4 = "T4";

    public void SetMatrixType(String s) {
        if (!(s.equals(C2) || s.equals(C3) || s.equals(C4) || s.equals(T3) || s.equals(T4))) {
            throw new OperatorException(s + " is an invalid filter name.");
        }
        this.matrix = s;
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfTOPSARBurstProduct(false);
            validator.checkIfSLC();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.checkSourceProductType();
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        String[] bandNames;
        switch (this.matrix) {
            case "C2": {
                bandNames = PolBandUtils.getC2BandNames();
                this.matrixType = PolBandUtils.MATRIX.C2;
                break;
            }
            case "C3": {
                bandNames = PolBandUtils.getC3BandNames();
                this.matrixType = PolBandUtils.MATRIX.C3;
                break;
            }
            case "C4": {
                bandNames = PolBandUtils.getC4BandNames();
                this.matrixType = PolBandUtils.MATRIX.C4;
                break;
            }
            case "T3": {
                bandNames = PolBandUtils.getT3BandNames();
                this.matrixType = PolBandUtils.MATRIX.T3;
                break;
            }
            case "T4": {
                bandNames = PolBandUtils.getT4BandNames();
                this.matrixType = PolBandUtils.MATRIX.T4;
                break;
            }
            default: {
                throw new OperatorException("Unknown matrix type: " + this.matrix);
            }
        }
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Band[] targetBands = OperatorUtils.addBands((Product)this.targetProduct, (String[])bandNames, (String)bandList.suffix);
            bandList.addTargetBands(targetBands);
        }
        this.mapMatrixElemToBands();
    }

    private void checkSourceProductType() {
        if (this.sourceProductType == PolBandUtils.MATRIX.UNKNOWN) {
            throw new OperatorException("Input should be a polarimetric product");
        }
        if (this.matrix.equals(C2)) {
            if (this.sourceProductType != PolBandUtils.MATRIX.DUAL_HH_HV && this.sourceProductType != PolBandUtils.MATRIX.DUAL_VH_VV && this.sourceProductType != PolBandUtils.MATRIX.DUAL_HH_VV) {
                if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
                    throw new OperatorException("Dual-pol product is expected for C2. Use BandSelect to select polarizations");
                }
                throw new OperatorException("Dual-pol polarimetric product is expected for C2");
            }
        } else if (this.sourceProductType == PolBandUtils.MATRIX.T4) {
            if (this.matrix.equals(T4)) {
                throw new OperatorException("The source product is already in T4 format, no conversion is needed");
            }
        } else if (this.sourceProductType == PolBandUtils.MATRIX.C4) {
            if (this.matrix.equals(C4)) {
                throw new OperatorException("The source product is already in C4 format, no conversion is needed");
            }
        } else if (this.sourceProductType == PolBandUtils.MATRIX.T3) {
            if (this.matrix.equals(T4)) {
                throw new OperatorException("Cannot convert source product from T3 format to T4 format");
            }
            if (this.matrix.equals(C4)) {
                throw new OperatorException("Cannot convert source product from T3 format to C4 format");
            }
            if (this.matrix.equals(T3)) {
                throw new OperatorException("The source product is already in T3 format, no conversion is needed");
            }
        } else if (this.sourceProductType == PolBandUtils.MATRIX.C3) {
            if (this.matrix.equals(T4)) {
                throw new OperatorException("Cannot convert source product from C3 format to T4 format");
            }
            if (this.matrix.equals(C4)) {
                throw new OperatorException("Cannot convert source product from C3 format to C4 format");
            }
            if (this.matrix.equals(C3)) {
                throw new OperatorException("The source product is already in C3 format, no conversion is needed");
            }
        } else if (this.sourceProductType != PolBandUtils.MATRIX.FULL) {
            throw new OperatorException("Full-pol polarimetric product is expected");
        }
    }

    private void mapMatrixElemToBands() {
        Band[] bands;
        for (Band band : bands = this.targetProduct.getBands()) {
            String targetBandName = band.getName();
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 0, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 1, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 1, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_real")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 2, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 2, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"14_real")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 3, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"14_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(0, 3, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 1, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_real")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 2, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 2, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"24_real")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 3, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"24_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(1, 3, true));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"33")) {
                this.matrixBandMap.put(band, new MatrixElem(2, 2, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"34_real")) {
                this.matrixBandMap.put(band, new MatrixElem(2, 3, false));
                continue;
            }
            if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"34_imag")) {
                this.matrixBandMap.put(band, new MatrixElem(2, 3, true));
                continue;
            }
            if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"44")) continue;
            this.matrixBandMap.put(band, new MatrixElem(3, 3, false));
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.setAttributeInt("polsar_data", 1);
        PolBandUtils.saveNewBandNames((Product)this.targetProduct, (PolBandUtils.PolSourceBand[])this.srcBandList);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        double[] kr = new double[2];
        double[] ki = new double[2];
        int matrixDim = this.matrixType.equals((Object)PolBandUtils.MATRIX.C2) ? 2 : (this.matrixType.equals((Object)PolBandUtils.MATRIX.C3) || this.matrixType.equals((Object)PolBandUtils.MATRIX.T3) ? 3 : 4);
        double[][] tempRe = new double[matrixDim][matrixDim];
        double[][] tempIm = new double[matrixDim][matrixDim];
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            try {
                TileData[] tileDataList = new TileData[bandList.targetBands.length];
                int i = 0;
                for (Band targetBand : bandList.targetBands) {
                    Tile targetTile = targetTiles.get(targetBand);
                    MatrixElem elem = this.matrixBandMap.get(targetBand);
                    tileDataList[i++] = new TileData(targetTile, elem);
                }
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                for (int j = 0; j < bandList.srcBands.length; ++j) {
                    sourceTiles[j] = this.getSourceTile((RasterDataNode)bandList.srcBands[j], targetRectangle);
                    dataBuffers[j] = sourceTiles[j].getDataBuffer();
                }
                TileIndex srcIndex = new TileIndex(sourceTiles[0]);
                TileIndex tgtIndex = new TileIndex(tileDataList[0].tile);
                int y = y0;
                int yy = 0;
                while (y < maxY) {
                    srcIndex.calculateStride(y);
                    tgtIndex.calculateStride(y);
                    int x = x0;
                    int xx = 0;
                    while (x < maxX) {
                        int srcIdx = srcIndex.getIndex(x);
                        int tgtIdx = tgtIndex.getIndex(x);
                        if (this.matrixType.equals((Object)PolBandUtils.MATRIX.C2)) {
                            DualPolOpUtils.getScatterVector(srcIdx, dataBuffers, kr, ki);
                            DualPolOpUtils.computeCovarianceMatrixC2(kr, ki, tempRe, tempIm);
                        } else if (this.matrixType.equals((Object)PolBandUtils.MATRIX.C3)) {
                            PolOpUtils.getCovarianceMatrixC3(srcIdx, this.sourceProductType, dataBuffers, tempRe, tempIm);
                        } else if (this.matrixType.equals((Object)PolBandUtils.MATRIX.C4)) {
                            PolOpUtils.getCovarianceMatrixC4(srcIdx, this.sourceProductType, dataBuffers, tempRe, tempIm);
                        } else if (this.matrixType.equals((Object)PolBandUtils.MATRIX.T3)) {
                            PolOpUtils.getCoherencyMatrixT3(srcIdx, this.sourceProductType, dataBuffers, tempRe, tempIm);
                        } else if (this.matrixType.equals((Object)PolBandUtils.MATRIX.T4)) {
                            PolOpUtils.getCoherencyMatrixT4(srcIdx, this.sourceProductType, dataBuffers, tempRe, tempIm);
                        }
                        for (TileData tileData : tileDataList) {
                            if (tileData.elem.isImaginary) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)tempIm[tileData.elem.i][tileData.elem.j]);
                                continue;
                            }
                            tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)tempRe[tileData.elem.i][tileData.elem.j]);
                        }
                        ++x;
                        ++xx;
                    }
                    ++y;
                    ++yy;
                }
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PolarimetricMatricesOp.class);
        }
    }

    private static class TileData {
        final Tile tile;
        final MatrixElem elem;
        final ProductData dataBuffer;

        public TileData(Tile tile, MatrixElem elem) {
            this.tile = tile;
            this.elem = elem;
            this.dataBuffer = tile.getDataBuffer();
        }
    }

    private static class MatrixElem {
        public final int i;
        public final int j;
        public final boolean isImaginary;

        MatrixElem(int i, int j, boolean isImaginary) {
            this.i = i;
            this.j = j;
            this.isImaginary = isImaginary;
        }
    }
}

