/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.awt.Rectangle;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.jblas.DoubleMatrix;

public final class PolOpUtils {
    private static final double sqrt2 = Math.sqrt(2.0);
    public static final double EPS = 1.0E-15;

    public static void getDataBuffer(Operator op, Band[] srcBands, Rectangle sourceRectangle, PolBandUtils.MATRIX sourceProductType, Tile[] sourceTiles, ProductData[] dataBuffers) {
        for (Band band : srcBands) {
            String bandName = band.getName();
            if (sourceProductType == PolBandUtils.MATRIX.FULL) {
                if (bandName.contains("i_HH")) {
                    sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[0] = sourceTiles[0].getDataBuffer();
                    continue;
                }
                if (bandName.contains("q_HH")) {
                    sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[1] = sourceTiles[1].getDataBuffer();
                    continue;
                }
                if (bandName.contains("i_HV")) {
                    sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[2] = sourceTiles[2].getDataBuffer();
                    continue;
                }
                if (bandName.contains("q_HV")) {
                    sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[3] = sourceTiles[3].getDataBuffer();
                    continue;
                }
                if (bandName.contains("i_VH")) {
                    sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[4] = sourceTiles[4].getDataBuffer();
                    continue;
                }
                if (bandName.contains("q_VH")) {
                    sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[5] = sourceTiles[5].getDataBuffer();
                    continue;
                }
                if (bandName.contains("i_VV")) {
                    sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[6] = sourceTiles[6].getDataBuffer();
                    continue;
                }
                if (!bandName.contains("q_VV")) continue;
                sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[7] = sourceTiles[7].getDataBuffer();
                continue;
            }
            if (sourceProductType == PolBandUtils.MATRIX.C3) {
                if (bandName.contains("C11")) {
                    sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[0] = sourceTiles[0].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C12_real")) {
                    sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[1] = sourceTiles[1].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C12_imag")) {
                    sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[2] = sourceTiles[2].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C13_real")) {
                    sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[3] = sourceTiles[3].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C13_imag")) {
                    sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[4] = sourceTiles[4].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C22")) {
                    sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[5] = sourceTiles[5].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C23_real")) {
                    sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[6] = sourceTiles[6].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C23_imag")) {
                    sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[7] = sourceTiles[7].getDataBuffer();
                    continue;
                }
                if (!bandName.contains("C33")) continue;
                sourceTiles[8] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[8] = sourceTiles[8].getDataBuffer();
                continue;
            }
            if (sourceProductType == PolBandUtils.MATRIX.T3) {
                if (bandName.contains("T11")) {
                    sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[0] = sourceTiles[0].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T12_real")) {
                    sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[1] = sourceTiles[1].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T12_imag")) {
                    sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[2] = sourceTiles[2].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T13_real")) {
                    sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[3] = sourceTiles[3].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T13_imag")) {
                    sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[4] = sourceTiles[4].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T22")) {
                    sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[5] = sourceTiles[5].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T23_real")) {
                    sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[6] = sourceTiles[6].getDataBuffer();
                    continue;
                }
                if (bandName.contains("T23_imag")) {
                    sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[7] = sourceTiles[7].getDataBuffer();
                    continue;
                }
                if (!bandName.contains("T33")) continue;
                sourceTiles[8] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[8] = sourceTiles[8].getDataBuffer();
                continue;
            }
            if (sourceProductType == PolBandUtils.MATRIX.C4) {
                if (bandName.contains("C11")) {
                    sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[0] = sourceTiles[0].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C12_real")) {
                    sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[1] = sourceTiles[1].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C12_imag")) {
                    sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[2] = sourceTiles[2].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C13_real")) {
                    sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[3] = sourceTiles[3].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C13_imag")) {
                    sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[4] = sourceTiles[4].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C14_real")) {
                    sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[5] = sourceTiles[5].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C14_imag")) {
                    sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[6] = sourceTiles[6].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C22")) {
                    sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[7] = sourceTiles[7].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C23_real")) {
                    sourceTiles[8] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[8] = sourceTiles[8].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C23_imag")) {
                    sourceTiles[9] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[9] = sourceTiles[9].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C24_real")) {
                    sourceTiles[10] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[10] = sourceTiles[10].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C24_imag")) {
                    sourceTiles[11] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[11] = sourceTiles[11].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C33")) {
                    sourceTiles[12] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[12] = sourceTiles[12].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C34_real")) {
                    sourceTiles[13] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[13] = sourceTiles[13].getDataBuffer();
                    continue;
                }
                if (bandName.contains("C34_imag")) {
                    sourceTiles[14] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                    dataBuffers[14] = sourceTiles[14].getDataBuffer();
                    continue;
                }
                if (!bandName.contains("C44")) continue;
                sourceTiles[15] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[15] = sourceTiles[15].getDataBuffer();
                continue;
            }
            if (sourceProductType != PolBandUtils.MATRIX.T4) continue;
            if (bandName.contains("T11")) {
                sourceTiles[0] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[0] = sourceTiles[0].getDataBuffer();
                continue;
            }
            if (bandName.contains("T12_real")) {
                sourceTiles[1] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[1] = sourceTiles[1].getDataBuffer();
                continue;
            }
            if (bandName.contains("T12_imag")) {
                sourceTiles[2] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[2] = sourceTiles[2].getDataBuffer();
                continue;
            }
            if (bandName.contains("T13_real")) {
                sourceTiles[3] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[3] = sourceTiles[3].getDataBuffer();
                continue;
            }
            if (bandName.contains("T13_imag")) {
                sourceTiles[4] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[4] = sourceTiles[4].getDataBuffer();
                continue;
            }
            if (bandName.contains("T14_real")) {
                sourceTiles[5] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[5] = sourceTiles[5].getDataBuffer();
                continue;
            }
            if (bandName.contains("T14_imag")) {
                sourceTiles[6] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[6] = sourceTiles[6].getDataBuffer();
                continue;
            }
            if (bandName.contains("T22")) {
                sourceTiles[7] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[7] = sourceTiles[7].getDataBuffer();
                continue;
            }
            if (bandName.contains("T23_real")) {
                sourceTiles[8] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[8] = sourceTiles[8].getDataBuffer();
                continue;
            }
            if (bandName.contains("T23_imag")) {
                sourceTiles[9] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[9] = sourceTiles[9].getDataBuffer();
                continue;
            }
            if (bandName.contains("T24_real")) {
                sourceTiles[10] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[10] = sourceTiles[10].getDataBuffer();
                continue;
            }
            if (bandName.contains("T24_imag")) {
                sourceTiles[11] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[11] = sourceTiles[11].getDataBuffer();
                continue;
            }
            if (bandName.contains("T33")) {
                sourceTiles[12] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[12] = sourceTiles[12].getDataBuffer();
                continue;
            }
            if (bandName.contains("T34_real")) {
                sourceTiles[13] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[13] = sourceTiles[13].getDataBuffer();
                continue;
            }
            if (bandName.contains("T34_imag")) {
                sourceTiles[14] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
                dataBuffers[14] = sourceTiles[14].getDataBuffer();
                continue;
            }
            if (!bandName.contains("T44")) continue;
            sourceTiles[15] = op.getSourceTile((RasterDataNode)band, sourceRectangle);
            dataBuffers[15] = sourceTiles[15].getDataBuffer();
        }
    }

    public static void getComplexScatterMatrix(int index, ProductData[] dataBuffers, double[][] scatterMatrix_i, double[][] scatterMatrix_q) {
        scatterMatrix_i[0][0] = dataBuffers[0].getElemDoubleAt(index);
        scatterMatrix_q[0][0] = dataBuffers[1].getElemDoubleAt(index);
        scatterMatrix_i[0][1] = dataBuffers[2].getElemDoubleAt(index);
        scatterMatrix_q[0][1] = dataBuffers[3].getElemDoubleAt(index);
        scatterMatrix_i[1][0] = dataBuffers[4].getElemDoubleAt(index);
        scatterMatrix_q[1][0] = dataBuffers[5].getElemDoubleAt(index);
        scatterMatrix_i[1][1] = dataBuffers[6].getElemDoubleAt(index);
        scatterMatrix_q[1][1] = dataBuffers[7].getElemDoubleAt(index);
    }

    public static void getComplexScatterMatrix(int index, ProductData[] dataBuffers, DoubleMatrix Sr, DoubleMatrix Si) {
        Sr.put(0, 0, dataBuffers[0].getElemDoubleAt(index));
        Si.put(0, 0, dataBuffers[1].getElemDoubleAt(index));
        Sr.put(0, 1, dataBuffers[2].getElemDoubleAt(index));
        Si.put(0, 1, dataBuffers[3].getElemDoubleAt(index));
        Sr.put(1, 0, dataBuffers[4].getElemDoubleAt(index));
        Si.put(1, 0, dataBuffers[5].getElemDoubleAt(index));
        Sr.put(1, 1, dataBuffers[6].getElemDoubleAt(index));
        Si.put(1, 1, dataBuffers[7].getElemDoubleAt(index));
    }

    public static void getCovarianceMatrixC3(int index, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        Cr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ci[0][0] = 0.0;
        Cr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ci[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Cr[0][2] = dataBuffers[3].getElemDoubleAt(index);
        Ci[0][2] = dataBuffers[4].getElemDoubleAt(index);
        Cr[1][1] = dataBuffers[5].getElemDoubleAt(index);
        Ci[1][1] = 0.0;
        Cr[1][2] = dataBuffers[6].getElemDoubleAt(index);
        Ci[1][2] = dataBuffers[7].getElemDoubleAt(index);
        Cr[2][2] = dataBuffers[8].getElemDoubleAt(index);
        Ci[2][2] = 0.0;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
        Cr[2][0] = Cr[0][2];
        Ci[2][0] = -Ci[0][2];
        Cr[2][1] = Cr[1][2];
        Ci[2][1] = -Ci[1][2];
    }

    public static void getCovarianceMatrixC4(int index, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        Cr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ci[0][0] = 0.0;
        Cr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ci[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Cr[0][2] = dataBuffers[3].getElemDoubleAt(index);
        Ci[0][2] = dataBuffers[4].getElemDoubleAt(index);
        Cr[0][3] = dataBuffers[5].getElemDoubleAt(index);
        Ci[0][3] = dataBuffers[6].getElemDoubleAt(index);
        Cr[1][1] = dataBuffers[7].getElemDoubleAt(index);
        Ci[1][1] = 0.0;
        Cr[1][2] = dataBuffers[8].getElemDoubleAt(index);
        Ci[1][2] = dataBuffers[9].getElemDoubleAt(index);
        Cr[1][3] = dataBuffers[10].getElemDoubleAt(index);
        Ci[1][3] = dataBuffers[11].getElemDoubleAt(index);
        Cr[2][2] = dataBuffers[12].getElemDoubleAt(index);
        Ci[2][2] = 0.0;
        Cr[2][3] = dataBuffers[13].getElemDoubleAt(index);
        Ci[2][3] = dataBuffers[14].getElemDoubleAt(index);
        Cr[3][3] = dataBuffers[15].getElemDoubleAt(index);
        Ci[3][3] = 0.0;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
        Cr[2][0] = Cr[0][2];
        Ci[2][0] = -Ci[0][2];
        Cr[2][1] = Cr[1][2];
        Ci[2][1] = -Ci[1][2];
        Cr[3][0] = Cr[0][3];
        Ci[3][0] = -Ci[0][3];
        Cr[3][1] = Cr[1][3];
        Ci[3][1] = -Ci[1][3];
        Cr[3][2] = Cr[2][3];
        Ci[3][2] = -Ci[2][3];
    }

    public static void getCoherencyMatrixT3(int index, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        Tr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ti[0][0] = 0.0;
        Tr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ti[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Tr[0][2] = dataBuffers[3].getElemDoubleAt(index);
        Ti[0][2] = dataBuffers[4].getElemDoubleAt(index);
        Tr[1][1] = dataBuffers[5].getElemDoubleAt(index);
        Ti[1][1] = 0.0;
        Tr[1][2] = dataBuffers[6].getElemDoubleAt(index);
        Ti[1][2] = dataBuffers[7].getElemDoubleAt(index);
        Tr[2][2] = dataBuffers[8].getElemDoubleAt(index);
        Ti[2][2] = 0.0;
        Tr[1][0] = Tr[0][1];
        Ti[1][0] = -Ti[0][1];
        Tr[2][0] = Tr[0][2];
        Ti[2][0] = -Ti[0][2];
        Tr[2][1] = Tr[1][2];
        Ti[2][1] = -Ti[1][2];
    }

    public static void getCoherencyMatrixT4(int index, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        Tr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ti[0][0] = 0.0;
        Tr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ti[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Tr[0][2] = dataBuffers[3].getElemDoubleAt(index);
        Ti[0][2] = dataBuffers[4].getElemDoubleAt(index);
        Tr[0][3] = dataBuffers[5].getElemDoubleAt(index);
        Ti[0][3] = dataBuffers[6].getElemDoubleAt(index);
        Tr[1][1] = dataBuffers[7].getElemDoubleAt(index);
        Ti[1][1] = 0.0;
        Tr[1][2] = dataBuffers[8].getElemDoubleAt(index);
        Ti[1][2] = dataBuffers[9].getElemDoubleAt(index);
        Tr[1][3] = dataBuffers[10].getElemDoubleAt(index);
        Ti[1][3] = dataBuffers[11].getElemDoubleAt(index);
        Tr[2][2] = dataBuffers[12].getElemDoubleAt(index);
        Ti[2][2] = 0.0;
        Tr[2][3] = dataBuffers[13].getElemDoubleAt(index);
        Ti[2][3] = dataBuffers[14].getElemDoubleAt(index);
        Tr[3][3] = dataBuffers[15].getElemDoubleAt(index);
        Ti[3][3] = 0.0;
        Tr[1][0] = Tr[0][1];
        Ti[1][0] = -Ti[0][1];
        Tr[2][0] = Tr[0][2];
        Ti[2][0] = -Ti[0][2];
        Tr[2][1] = Tr[1][2];
        Ti[2][1] = -Ti[1][2];
        Tr[3][0] = Tr[0][3];
        Ti[3][0] = -Ti[0][3];
        Tr[3][1] = Tr[1][3];
        Ti[3][1] = -Ti[1][3];
        Tr[3][2] = Tr[2][3];
        Ti[3][2] = -Ti[2][3];
    }

    public static void computeCovarianceMatrixC3(double[][] scatterRe, double[][] scatterIm, double[][] Cr, double[][] Ci) {
        double k1r = scatterRe[0][0];
        double k1i = scatterIm[0][0];
        double sHVr = scatterRe[0][1];
        double sHVi = scatterIm[0][1];
        double sVHr = scatterRe[1][0];
        double sVHi = scatterIm[1][0];
        double k3r = scatterRe[1][1];
        double k3i = scatterIm[1][1];
        double k2r = (sHVr + sVHr) / sqrt2;
        double k2i = (sHVi + sVHi) / sqrt2;
        Cr[0][0] = k1r * k1r + k1i * k1i;
        Cr[0][1] = k1r * k2r + k1i * k2i;
        Ci[0][1] = k1i * k2r - k1r * k2i;
        Cr[0][2] = k1r * k3r + k1i * k3i;
        Ci[0][2] = k1i * k3r - k1r * k3i;
        Cr[1][1] = k2r * k2r + k2i * k2i;
        Cr[1][2] = k2r * k3r + k2i * k3i;
        Ci[1][2] = k2i * k3r - k2r * k3i;
        Cr[2][2] = k3r * k3r + k3i * k3i;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
        Cr[2][0] = Cr[0][2];
        Ci[2][0] = -Ci[0][2];
        Cr[2][1] = Cr[1][2];
        Ci[2][1] = -Ci[1][2];
    }

    public static void computeCovarianceMatrixC3(DoubleMatrix Sr, DoubleMatrix Si, DoubleMatrix Cr, DoubleMatrix Ci) {
        double k1r = Sr.get(0, 0);
        double k1i = Si.get(0, 0);
        double sHVr = Sr.get(0, 1);
        double sHVi = Si.get(0, 1);
        double sVHr = Sr.get(1, 0);
        double sVHi = Si.get(1, 0);
        double k3r = Sr.get(1, 1);
        double k3i = Si.get(1, 1);
        double k2r = (sHVr + sVHr) / sqrt2;
        double k2i = (sHVi + sVHi) / sqrt2;
        Cr.put(0, 0, k1r * k1r + k1i * k1i);
        Cr.put(0, 1, k1r * k2r + k1i * k2i);
        Ci.put(0, 1, k1i * k2r - k1r * k2i);
        Cr.put(0, 2, k1r * k3r + k1i * k3i);
        Ci.put(0, 2, k1i * k3r - k1r * k3i);
        Cr.put(1, 1, k2r * k2r + k2i * k2i);
        Cr.put(1, 2, k2r * k3r + k2i * k3i);
        Ci.put(1, 2, k2i * k3r - k2r * k3i);
        Cr.put(2, 2, k3r * k3r + k3i * k3i);
        Cr.put(1, 0, Cr.get(0, 1));
        Ci.put(1, 0, -Ci.get(0, 1));
        Cr.put(2, 0, Cr.get(0, 2));
        Ci.put(2, 0, -Ci.get(0, 2));
        Cr.put(2, 1, Cr.get(1, 2));
        Ci.put(2, 1, -Ci.get(1, 2));
    }

    public static void computeCovarianceMatrixC4(double[][] scatterRe, double[][] scatterIm, double[][] Cr, double[][] Ci) {
        double k1r = scatterRe[0][0];
        double k1i = scatterIm[0][0];
        double k2r = scatterRe[0][1];
        double k2i = scatterIm[0][1];
        double k3r = scatterRe[1][0];
        double k3i = scatterIm[1][0];
        double k4r = scatterRe[1][1];
        double k4i = scatterIm[1][1];
        Cr[0][0] = k1r * k1r + k1i * k1i;
        Ci[0][0] = 0.0;
        Cr[0][1] = k1r * k2r + k1i * k2i;
        Ci[0][1] = k1i * k2r - k1r * k2i;
        Cr[0][2] = k1r * k3r + k1i * k3i;
        Ci[0][2] = k1i * k3r - k1r * k3i;
        Cr[0][3] = k1r * k4r + k1i * k4i;
        Ci[0][3] = k1i * k4r - k1r * k4i;
        Cr[1][1] = k2r * k2r + k2i * k2i;
        Ci[1][1] = 0.0;
        Cr[1][2] = k2r * k3r + k2i * k3i;
        Ci[1][2] = k2i * k3r - k2r * k3i;
        Cr[1][3] = k2r * k4r + k2i * k4i;
        Ci[1][3] = k2i * k4r - k2r * k4i;
        Cr[2][2] = k3r * k3r + k3i * k3i;
        Ci[2][2] = 0.0;
        Cr[2][3] = k3r * k4r + k3i * k4i;
        Ci[2][3] = k3i * k4r - k3r * k4i;
        Cr[3][3] = k4r * k4r + k4i * k4i;
        Ci[3][3] = 0.0;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
        Cr[2][0] = Cr[0][2];
        Ci[2][0] = -Ci[0][2];
        Cr[2][1] = Cr[1][2];
        Ci[2][1] = -Ci[1][2];
        Cr[3][0] = Cr[0][3];
        Ci[3][0] = -Ci[0][3];
        Cr[3][1] = Cr[1][3];
        Ci[3][1] = -Ci[1][3];
        Cr[3][2] = Cr[2][3];
        Ci[3][2] = -Ci[2][3];
    }

    public static void computeCoherencyMatrixT3(double[][] scatterRe, double[][] scatterIm, double[][] Tr, double[][] Ti) {
        double sHHr = scatterRe[0][0];
        double sHHi = scatterIm[0][0];
        double sHVr = scatterRe[0][1];
        double sHVi = scatterIm[0][1];
        double sVHr = scatterRe[1][0];
        double sVHi = scatterIm[1][0];
        double sVVr = scatterRe[1][1];
        double sVVi = scatterIm[1][1];
        double k1r = (sHHr + sVVr) / sqrt2;
        double k1i = (sHHi + sVVi) / sqrt2;
        double k2r = (sHHr - sVVr) / sqrt2;
        double k2i = (sHHi - sVVi) / sqrt2;
        double k3r = (sHVr + sVHr) / sqrt2;
        double k3i = (sHVi + sVHi) / sqrt2;
        Tr[0][0] = k1r * k1r + k1i * k1i;
        Ti[0][0] = 0.0;
        Tr[0][1] = k1r * k2r + k1i * k2i;
        Ti[0][1] = k1i * k2r - k1r * k2i;
        Tr[0][2] = k1r * k3r + k1i * k3i;
        Ti[0][2] = k1i * k3r - k1r * k3i;
        Tr[1][1] = k2r * k2r + k2i * k2i;
        Ti[1][1] = 0.0;
        Tr[1][2] = k2r * k3r + k2i * k3i;
        Ti[1][2] = k2i * k3r - k2r * k3i;
        Tr[2][2] = k3r * k3r + k3i * k3i;
        Ti[2][2] = 0.0;
        Tr[1][0] = Tr[0][1];
        Ti[1][0] = -Ti[0][1];
        Tr[2][0] = Tr[0][2];
        Ti[2][0] = -Ti[0][2];
        Tr[2][1] = Tr[1][2];
        Ti[2][1] = -Ti[1][2];
    }

    public static void computeCoherencyMatrixT4(double[][] scatterRe, double[][] scatterIm, double[][] Tr, double[][] Ti) {
        double sHHr = scatterRe[0][0];
        double sHHi = scatterIm[0][0];
        double sHVr = scatterRe[0][1];
        double sHVi = scatterIm[0][1];
        double sVHr = scatterRe[1][0];
        double sVHi = scatterIm[1][0];
        double sVVr = scatterRe[1][1];
        double sVVi = scatterIm[1][1];
        double k1r = (sHHr + sVVr) / sqrt2;
        double k1i = (sHHi + sVVi) / sqrt2;
        double k2r = (sHHr - sVVr) / sqrt2;
        double k2i = (sHHi - sVVi) / sqrt2;
        double k3r = (sHVr + sVHr) / sqrt2;
        double k3i = (sHVi + sVHi) / sqrt2;
        double k4r = (sVHi - sHVi) / sqrt2;
        double k4i = (sHVr - sVHr) / sqrt2;
        Tr[0][0] = k1r * k1r + k1i * k1i;
        Ti[0][0] = 0.0;
        Tr[0][1] = k1r * k2r + k1i * k2i;
        Ti[0][1] = k1i * k2r - k1r * k2i;
        Tr[0][2] = k1r * k3r + k1i * k3i;
        Ti[0][2] = k1i * k3r - k1r * k3i;
        Tr[0][3] = k1r * k4r + k1i * k4i;
        Ti[0][3] = k1i * k4r - k1r * k4i;
        Tr[1][1] = k2r * k2r + k2i * k2i;
        Ti[1][1] = 0.0;
        Tr[1][2] = k2r * k3r + k2i * k3i;
        Ti[1][2] = k2i * k3r - k2r * k3i;
        Tr[1][3] = k2r * k4r + k2i * k4i;
        Ti[1][3] = k2i * k4r - k2r * k4i;
        Tr[2][2] = k3r * k3r + k3i * k3i;
        Ti[2][2] = 0.0;
        Tr[2][3] = k3r * k4r + k3i * k4i;
        Ti[2][3] = k3i * k4r - k3r * k4i;
        Tr[3][3] = k4r * k4r + k4i * k4i;
        Ti[3][3] = 0.0;
        Tr[1][0] = Tr[0][1];
        Ti[1][0] = -Ti[0][1];
        Tr[2][0] = Tr[0][2];
        Ti[2][0] = -Ti[0][2];
        Tr[2][1] = Tr[1][2];
        Ti[2][1] = -Ti[1][2];
        Tr[3][0] = Tr[0][3];
        Ti[3][0] = -Ti[0][3];
        Tr[3][1] = Tr[1][3];
        Ti[3][1] = -Ti[1][3];
        Tr[3][2] = Tr[2][3];
        Ti[3][2] = -Ti[2][3];
    }

    public static void computeCorrelationMatrix(double[][] scatter1Re, double[][] scatter1Im, double[][] scatter2Re, double[][] scatter2Im, double[][] Tr, double[][] Ti) {
        double s1HHr = scatter1Re[0][0];
        double s1HHi = scatter1Im[0][0];
        double s1HVr = scatter1Re[0][1];
        double s1HVi = scatter1Im[0][1];
        double s1VHr = scatter1Re[1][0];
        double s1VHi = scatter1Im[1][0];
        double s1VVr = scatter1Re[1][1];
        double s1VVi = scatter1Im[1][1];
        double s2HHr = scatter2Re[0][0];
        double s2HHi = scatter2Im[0][0];
        double s2HVr = scatter2Re[0][1];
        double s2HVi = scatter2Im[0][1];
        double s2VHr = scatter2Re[1][0];
        double s2VHi = scatter2Im[1][0];
        double s2VVr = scatter2Re[1][1];
        double s2VVi = scatter2Im[1][1];
        double k11r = (s1HHr + s1VVr) / sqrt2;
        double k11i = (s1HHi + s1VVi) / sqrt2;
        double k12r = (s1HHr - s1VVr) / sqrt2;
        double k12i = (s1HHi - s1VVi) / sqrt2;
        double k13r = (s1HVr + s1VHr) / sqrt2;
        double k13i = (s1HVi + s1VHi) / sqrt2;
        double k21r = (s2HHr + s2VVr) / sqrt2;
        double k21i = (s2HHi + s2VVi) / sqrt2;
        double k22r = (s2HHr - s2VVr) / sqrt2;
        double k22i = (s2HHi - s2VVi) / sqrt2;
        double k23r = (s2HVr + s2VHr) / sqrt2;
        double k23i = (s2HVi + s2VHi) / sqrt2;
        Tr[0][0] = k11r * k21r + k11i * k21i;
        Ti[0][0] = k11i * k21r - k11r * k21i;
        Tr[0][1] = k11r * k22r + k11i * k22i;
        Ti[0][1] = k11i * k22r - k11r * k22i;
        Tr[0][2] = k11r * k23r + k11i * k23i;
        Ti[0][2] = k11i * k23r - k11r * k23i;
        Tr[1][0] = k12r * k21r + k12i * k21i;
        Ti[1][0] = k12i * k21r - k12r * k21i;
        Tr[1][1] = k12r * k22r + k12i * k22i;
        Ti[1][1] = k12i * k22r - k12r * k22i;
        Tr[1][2] = k12r * k23r + k12i * k23i;
        Ti[1][2] = k12i * k23r - k12r * k23i;
        Tr[2][0] = k13r * k21r + k13i * k21i;
        Ti[2][0] = k13i * k21r - k13r * k21i;
        Tr[2][1] = k13r * k22r + k13i * k22i;
        Ti[2][1] = k13i * k22r - k13r * k22i;
        Tr[2][2] = k13r * k23r + k13i * k23i;
        Ti[2][2] = k13i * k23r - k13r * k23i;
    }

    public static void c4ToT4(double[][] c4Re, double[][] c4Im, double[][] t4Re, double[][] t4Im) {
        t4Re[0][0] = 0.5 * (c4Re[0][0] + 2.0 * c4Re[0][3] + c4Re[3][3]);
        t4Im[0][0] = 0.5 * (c4Im[0][0] + c4Im[3][3]);
        t4Re[0][1] = 0.5 * (c4Re[0][0] - c4Re[3][3]);
        t4Im[0][1] = 0.5 * (c4Im[0][0] - 2.0 * c4Im[0][3] - c4Im[3][3]);
        t4Re[0][2] = 0.5 * (c4Re[0][1] + c4Re[1][3] + c4Re[0][2] + c4Re[2][3]);
        t4Im[0][2] = 0.5 * (c4Im[0][1] - c4Im[1][3] + c4Im[0][2] - c4Im[2][3]);
        t4Re[0][3] = 0.5 * (c4Im[0][1] - c4Im[1][3] - c4Im[0][2] + c4Im[2][3]);
        t4Im[0][3] = 0.5 * (-c4Re[0][1] - c4Re[1][3] + c4Re[0][2] + c4Re[2][3]);
        t4Re[1][0] = t4Re[0][1];
        t4Im[1][0] = -t4Im[0][1];
        t4Re[1][1] = 0.5 * (c4Re[0][0] - 2.0 * c4Re[0][3] + c4Re[3][3]);
        t4Im[1][1] = 0.5 * (c4Im[0][0] + c4Im[3][3]);
        t4Re[1][2] = 0.5 * (c4Re[0][1] - c4Re[1][3] + c4Re[0][2] - c4Re[2][3]);
        t4Im[1][2] = 0.5 * (c4Im[0][1] + c4Im[1][3] + c4Im[0][2] + c4Im[2][3]);
        t4Re[1][3] = 0.5 * (c4Im[0][1] + c4Im[1][3] - c4Im[0][2] - c4Im[2][3]);
        t4Im[1][3] = 0.5 * (-c4Re[0][1] + c4Re[1][3] + c4Re[0][2] - c4Re[2][3]);
        t4Re[2][0] = t4Re[0][2];
        t4Im[2][0] = -t4Im[0][2];
        t4Re[2][1] = t4Re[1][2];
        t4Im[2][1] = -t4Im[1][2];
        t4Re[2][2] = 0.5 * (c4Re[1][1] + 2.0 * c4Re[1][2] + c4Re[2][2]);
        t4Im[2][2] = 0.5 * (c4Im[1][1] + c4Im[2][2]);
        t4Re[2][3] = 0.5 * (c4Im[1][1] - 2.0 * c4Im[1][2] - c4Im[2][2]);
        t4Im[2][3] = 0.5 * (-c4Re[1][1] + c4Re[2][2]);
        t4Re[3][0] = t4Re[0][3];
        t4Im[3][0] = -t4Im[0][3];
        t4Re[3][1] = t4Re[1][3];
        t4Im[3][1] = -t4Im[1][3];
        t4Re[3][2] = t4Re[2][3];
        t4Im[3][2] = -t4Im[2][3];
        t4Re[3][3] = 0.5 * (c4Re[1][1] - 2.0 * c4Re[1][2] + c4Re[2][2]);
        t4Im[3][3] = 0.5 * (c4Im[1][1] + c4Im[2][2]);
    }

    public static void t4ToC4(double[][] t4Re, double[][] t4Im, double[][] c4Re, double[][] c4Im) {
        c4Re[0][0] = 0.5 * (t4Re[0][0] + t4Re[0][1] + t4Re[1][0] + t4Re[1][1]);
        c4Im[0][0] = 0.0;
        c4Re[0][1] = 0.5 * (t4Re[0][2] - t4Im[0][3] + t4Re[1][2] - t4Im[1][3]);
        c4Im[0][1] = 0.5 * (t4Im[0][2] + t4Re[0][3] + t4Im[1][2] + t4Re[1][3]);
        c4Re[0][2] = 0.5 * (t4Re[0][2] + t4Im[0][3] + t4Re[1][2] + t4Im[1][3]);
        c4Im[0][2] = 0.5 * (t4Im[0][2] - t4Re[0][3] + t4Im[1][2] - t4Re[1][3]);
        c4Re[0][3] = 0.5 * (t4Re[0][0] - t4Re[0][1] + t4Re[1][0] - t4Re[1][1]);
        c4Im[0][3] = 0.5 * (t4Im[0][0] - t4Im[0][1] + t4Im[1][0] - t4Im[1][1]);
        c4Re[1][0] = c4Re[0][1];
        c4Im[1][0] = -c4Im[0][1];
        c4Re[1][1] = 0.5 * (t4Re[2][2] - t4Im[2][3] + t4Im[3][2] + t4Re[3][3]);
        c4Im[1][1] = 0.0;
        c4Re[1][2] = 0.5 * (t4Re[2][2] + t4Im[2][3] + t4Im[3][2] - t4Re[3][3]);
        c4Im[1][2] = 0.5 * (t4Im[2][2] - t4Re[2][3] - t4Re[3][2] - t4Im[3][3]);
        c4Re[1][3] = 0.5 * (t4Re[2][0] - t4Re[2][1] + t4Im[3][0] - t4Im[3][1]);
        c4Im[1][3] = 0.5 * (t4Im[2][0] - t4Im[2][1] - t4Re[3][0] + t4Re[3][1]);
        c4Re[2][0] = c4Re[0][2];
        c4Im[2][0] = -c4Im[0][2];
        c4Re[2][1] = c4Re[1][2];
        c4Im[2][1] = -c4Im[1][2];
        c4Re[2][2] = 0.5 * (t4Re[2][2] + t4Im[2][3] - t4Im[3][2] + t4Re[3][3]);
        c4Im[2][2] = 0.0;
        c4Re[2][3] = 0.5 * (t4Re[2][0] - t4Re[2][1] - t4Im[3][0] + t4Im[3][1]);
        c4Im[2][3] = 0.5 * (t4Im[2][0] - t4Im[2][1] + t4Re[3][0] - t4Re[3][1]);
        c4Re[3][0] = c4Re[0][3];
        c4Im[3][0] = -c4Im[0][3];
        c4Re[3][1] = c4Re[1][3];
        c4Im[3][1] = -c4Im[1][3];
        c4Re[3][2] = c4Re[2][3];
        c4Im[3][2] = -c4Im[2][3];
        c4Re[3][3] = 0.5 * (t4Re[0][0] - t4Re[0][1] - t4Re[1][0] + t4Re[1][1]);
        c4Im[3][3] = 0.0;
    }

    public static void c3ToT3(double[][] c3Re, double[][] c3Im, double[][] t3Re, double[][] t3Im) {
        t3Re[0][0] = (c3Re[0][0] + 2.0 * c3Re[0][2] + c3Re[2][2]) / 2.0;
        t3Im[0][0] = 0.0;
        t3Re[0][1] = (c3Re[0][0] - c3Re[2][2]) / 2.0;
        t3Im[0][1] = -c3Im[0][2];
        t3Re[0][2] = (c3Re[0][1] + c3Re[1][2]) / sqrt2;
        t3Im[0][2] = (c3Im[0][1] - c3Im[1][2]) / sqrt2;
        t3Re[1][0] = t3Re[0][1];
        t3Im[1][0] = -t3Im[0][1];
        t3Re[1][1] = (c3Re[0][0] - 2.0 * c3Re[0][2] + c3Re[2][2]) / 2.0;
        t3Im[1][1] = 0.0;
        t3Re[1][2] = (c3Re[0][1] - c3Re[1][2]) / sqrt2;
        t3Im[1][2] = (c3Im[0][1] + c3Im[1][2]) / sqrt2;
        t3Re[2][0] = t3Re[0][2];
        t3Im[2][0] = -t3Im[0][2];
        t3Re[2][1] = t3Re[1][2];
        t3Im[2][1] = -t3Im[1][2];
        t3Re[2][2] = c3Re[1][1];
        t3Im[2][2] = 0.0;
    }

    public static void t3ToC3(double[][] t3Re, double[][] t3Im, double[][] c3Re, double[][] c3Im) {
        c3Re[0][0] = 0.5 * (t3Re[0][0] + t3Re[0][1] + t3Re[1][0] + t3Re[1][1]);
        c3Im[0][0] = 0.0;
        c3Re[0][1] = (t3Re[0][2] + t3Re[1][2]) / sqrt2;
        c3Im[0][1] = (t3Im[0][2] + t3Im[1][2]) / sqrt2;
        c3Re[0][2] = 0.5 * (t3Re[0][0] - t3Re[0][1] + t3Re[1][0] - t3Re[1][1]);
        c3Im[0][2] = 0.5 * (t3Im[0][0] - t3Im[0][1] + t3Im[1][0] - t3Im[1][1]);
        c3Re[1][0] = c3Re[0][1];
        c3Im[1][0] = -c3Im[0][1];
        c3Re[1][1] = t3Re[2][2];
        c3Im[1][1] = 0.0;
        c3Re[1][2] = (t3Re[2][0] - t3Re[2][1]) / sqrt2;
        c3Im[1][2] = (t3Im[2][0] - t3Im[2][1]) / sqrt2;
        c3Re[2][0] = c3Re[0][2];
        c3Im[2][0] = -c3Im[0][2];
        c3Re[2][1] = c3Re[1][2];
        c3Im[2][1] = -c3Im[1][2];
        c3Re[2][2] = 0.5 * (t3Re[0][0] - t3Re[0][1] - t3Re[1][0] + t3Re[1][1]);
        c3Im[2][2] = 0.0;
    }

    public static void t4ToT3(double[][] t4Re, double[][] t4Im, double[][] t3Re, double[][] t3Im) {
        System.arraycopy(t4Re[0], 0, t3Re[0], 0, t3Re[0].length);
        System.arraycopy(t4Im[0], 0, t3Im[0], 0, t3Im[0].length);
        System.arraycopy(t4Re[1], 0, t3Re[1], 0, t3Re[1].length);
        System.arraycopy(t4Im[1], 0, t3Im[1], 0, t3Im[1].length);
        System.arraycopy(t4Re[2], 0, t3Re[2], 0, t3Re[2].length);
        System.arraycopy(t4Im[2], 0, t3Im[2], 0, t3Im[2].length);
    }

    public static void c4ToC3(double[][] c4Re, double[][] c4Im, double[][] c3Re, double[][] c3Im) {
        c3Re[0][0] = c4Re[0][0];
        c3Im[0][0] = c4Im[0][0];
        c3Re[0][1] = (c4Re[0][1] + c4Re[0][2]) / sqrt2;
        c3Im[0][1] = (c4Im[0][1] + c4Im[0][2]) / sqrt2;
        c3Re[0][2] = c4Re[0][3];
        c3Im[0][2] = c4Im[0][3];
        c3Re[1][0] = (c4Re[1][0] + c4Re[2][0]) / sqrt2;
        c3Im[1][0] = (c4Im[1][0] + c4Im[2][0]) / sqrt2;
        c3Re[1][1] = (c4Re[1][1] + c4Re[2][1] + c4Re[1][2] + c4Re[2][2]) / 2.0;
        c3Im[1][1] = (c4Im[1][1] + c4Im[2][1] + c4Im[1][2] + c4Im[2][2]) / 2.0;
        c3Re[1][2] = (c4Re[1][3] + c4Re[2][3]) / sqrt2;
        c3Im[1][2] = (c4Im[1][3] + c4Im[2][3]) / sqrt2;
        c3Re[2][0] = c4Re[3][0];
        c3Im[2][0] = c4Im[3][0];
        c3Re[2][1] = (c4Re[3][1] + c4Re[3][2]) / sqrt2;
        c3Im[2][1] = (c4Im[3][1] + c4Im[3][2]) / sqrt2;
        c3Re[2][2] = c4Re[3][3];
        c3Im[2][2] = c4Im[3][3];
    }

    public static void getMeanCoherencyMatrix(int x, int y, int halfWindowSizeX, int halfWindowSizeY, int sourceImageWidth, int sourceImageHeight, PolBandUtils.MATRIX sourceProductType, TileIndex srcIndex, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        int xx;
        int yy;
        double[][] tempSr = new double[2][2];
        double[][] tempSi = new double[2][2];
        double[][] tempCr = new double[3][3];
        double[][] tempCi = new double[3][3];
        double[][] tempTr = new double[3][3];
        double[][] tempTi = new double[3][3];
        int xSt = FastMath.max((int)(x - halfWindowSizeX), (int)0);
        int xEd = FastMath.min((int)(x + halfWindowSizeX), (int)(sourceImageWidth - 1));
        int ySt = FastMath.max((int)(y - halfWindowSizeY), (int)0);
        int yEd = FastMath.min((int)(y + halfWindowSizeY), (int)(sourceImageHeight - 1));
        int num = (yEd - ySt + 1) * (xEd - xSt + 1);
        Matrix TrMat = new Matrix(3, 3);
        Matrix TiMat = new Matrix(3, 3);
        if (sourceProductType == PolBandUtils.MATRIX.T3) {
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    PolOpUtils.getCoherencyMatrixT3(srcIndex.getIndex(xx), dataBuffers, tempTr, tempTi);
                    TrMat.plusEquals(new Matrix(tempTr));
                    TiMat.plusEquals(new Matrix(tempTi));
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.C3) {
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    PolOpUtils.getCovarianceMatrixC3(srcIndex.getIndex(xx), dataBuffers, tempCr, tempCi);
                    PolOpUtils.c3ToT3(tempCr, tempCi, tempTr, tempTi);
                    TrMat.plusEquals(new Matrix(tempTr));
                    TiMat.plusEquals(new Matrix(tempTi));
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    PolOpUtils.getComplexScatterMatrix(srcIndex.getIndex(xx), dataBuffers, tempSr, tempSi);
                    PolOpUtils.computeCoherencyMatrixT3(tempSr, tempSi, tempTr, tempTi);
                    TrMat.plusEquals(new Matrix(tempTr));
                    TiMat.plusEquals(new Matrix(tempTi));
                }
            }
        }
        TrMat.timesEquals(1.0 / (double)num);
        TiMat.timesEquals(1.0 / (double)num);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Tr[i][j] = TrMat.get(i, j);
                Ti[i][j] = TiMat.get(i, j);
            }
        }
    }

    public static void getMeanCovarianceMatrix(int x, int y, int halfWindowSizeX, int halfWindowSizeY, PolBandUtils.MATRIX sourceProductType, Tile[] sourceTiles, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        int xx;
        int yy;
        double[][] tempCr = new double[3][3];
        double[][] tempCi = new double[3][3];
        int xSt = Math.max(x - halfWindowSizeX, sourceTiles[0].getMinX());
        int xEd = Math.min(x + halfWindowSizeX, sourceTiles[0].getMaxX());
        int ySt = Math.max(y - halfWindowSizeY, sourceTiles[0].getMinY());
        int yEd = Math.min(y + halfWindowSizeY, sourceTiles[0].getMaxY());
        int num = (yEd - ySt + 1) * (xEd - xSt + 1);
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        Matrix CrMat = new Matrix(3, 3);
        Matrix CiMat = new Matrix(3, 3);
        if (sourceProductType == PolBandUtils.MATRIX.C3) {
            for (int yy2 = ySt; yy2 <= yEd; ++yy2) {
                srcIndex.calculateStride(yy2);
                for (int xx2 = xSt; xx2 <= xEd; ++xx2) {
                    PolOpUtils.getCovarianceMatrixC3(srcIndex.getIndex(xx2), dataBuffers, tempCr, tempCi);
                    CrMat.plusEquals(new Matrix(tempCr));
                    CiMat.plusEquals(new Matrix(tempCi));
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.T3) {
            double[][] tempTr = new double[3][3];
            double[][] tempTi = new double[3][3];
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    PolOpUtils.getCoherencyMatrixT3(srcIndex.getIndex(xx), dataBuffers, tempTr, tempTi);
                    PolOpUtils.t3ToC3(tempTr, tempTi, tempCr, tempCi);
                    CrMat.plusEquals(new Matrix(tempCr));
                    CiMat.plusEquals(new Matrix(tempCi));
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            for (yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (xx = xSt; xx <= xEd; ++xx) {
                    PolOpUtils.getComplexScatterMatrix(srcIndex.getIndex(xx), dataBuffers, tempSr, tempSi);
                    PolOpUtils.computeCovarianceMatrixC3(tempSr, tempSi, tempCr, tempCi);
                    CrMat.plusEquals(new Matrix(tempCr));
                    CiMat.plusEquals(new Matrix(tempCi));
                }
            }
        }
        CrMat.timesEquals(1.0 / (double)num);
        CiMat.timesEquals(1.0 / (double)num);
        for (int i = 0; i < 3; ++i) {
            Cr[i][0] = CrMat.get(i, 0);
            Ci[i][0] = CiMat.get(i, 0);
            Cr[i][1] = CrMat.get(i, 1);
            Ci[i][1] = CiMat.get(i, 1);
            Cr[i][2] = CrMat.get(i, 2);
            Ci[i][2] = CiMat.get(i, 2);
        }
    }

    public static void getMeanCovarianceMatrixC4(int x, int y, int halfWindowSizeX, int halfWindowSizeY, PolBandUtils.MATRIX sourceProductType, Tile[] sourceTiles, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        double[][] tempCr = new double[4][4];
        double[][] tempCi = new double[4][4];
        int xSt = Math.max(x - halfWindowSizeX, sourceTiles[0].getMinX());
        int xEd = Math.min(x + halfWindowSizeX, sourceTiles[0].getMaxX());
        int ySt = Math.max(y - halfWindowSizeY, sourceTiles[0].getMinY());
        int yEd = Math.min(y + halfWindowSizeY, sourceTiles[0].getMaxY());
        int num = (yEd - ySt + 1) * (xEd - xSt + 1);
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        Matrix CrMat = new Matrix(4, 4);
        Matrix CiMat = new Matrix(4, 4);
        for (int yy = ySt; yy <= yEd; ++yy) {
            srcIndex.calculateStride(yy);
            for (int xx = xSt; xx <= xEd; ++xx) {
                PolOpUtils.getCovarianceMatrixC4(srcIndex.getIndex(xx), sourceProductType, dataBuffers, tempCr, tempCi);
                CrMat.plusEquals(new Matrix(tempCr));
                CiMat.plusEquals(new Matrix(tempCi));
            }
        }
        CrMat.timesEquals(1.0 / (double)num);
        CiMat.timesEquals(1.0 / (double)num);
        for (int i = 0; i < 4; ++i) {
            Cr[i][0] = CrMat.get(i, 0);
            Ci[i][0] = CiMat.get(i, 0);
            Cr[i][1] = CrMat.get(i, 1);
            Ci[i][1] = CiMat.get(i, 1);
            Cr[i][2] = CrMat.get(i, 2);
            Ci[i][2] = CiMat.get(i, 2);
            Cr[i][3] = CrMat.get(i, 3);
            Ci[i][3] = CiMat.get(i, 3);
        }
    }

    public static void getCovarianceMatrixC4(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            PolOpUtils.getComplexScatterMatrix(index, dataBuffers, tempSr, tempSi);
            PolOpUtils.computeCovarianceMatrixC4(tempSr, tempSi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.T4) {
            double[][] tempTr = new double[4][4];
            double[][] tempTi = new double[4][4];
            PolOpUtils.getCoherencyMatrixT4(index, dataBuffers, tempTr, tempTi);
            PolOpUtils.t4ToC4(tempTr, tempTi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.C4) {
            PolOpUtils.getCovarianceMatrixC4(index, dataBuffers, Cr, Ci);
        }
    }

    public static void getCoherencyMatrixT4(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            PolOpUtils.getComplexScatterMatrix(index, dataBuffers, tempSr, tempSi);
            PolOpUtils.computeCoherencyMatrixT4(tempSr, tempSi, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.T4) {
            PolOpUtils.getCoherencyMatrixT4(index, dataBuffers, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.C4) {
            double[][] tempCr = new double[4][4];
            double[][] tempCi = new double[4][4];
            PolOpUtils.getCovarianceMatrixC4(index, dataBuffers, tempCr, tempCi);
            PolOpUtils.c4ToT4(tempCr, tempCi, Tr, Ti);
        }
    }

    public static void getCovarianceMatrixC3(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            PolOpUtils.getComplexScatterMatrix(index, dataBuffers, tempSr, tempSi);
            PolOpUtils.computeCovarianceMatrixC3(tempSr, tempSi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.T4) {
            double[][] tempTr = new double[4][4];
            double[][] tempTi = new double[4][4];
            double[][] tempCr = new double[4][4];
            double[][] tempCi = new double[4][4];
            PolOpUtils.getCoherencyMatrixT4(index, dataBuffers, tempTr, tempTi);
            PolOpUtils.t4ToC4(tempTr, tempTi, tempCr, tempCi);
            PolOpUtils.c4ToC3(tempCr, tempCi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.C4) {
            double[][] tempCr = new double[4][4];
            double[][] tempCi = new double[4][4];
            PolOpUtils.getCovarianceMatrixC4(index, dataBuffers, tempCr, tempCi);
            PolOpUtils.c4ToC3(tempCr, tempCi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.T3) {
            double[][] tempTr = new double[3][3];
            double[][] tempTi = new double[3][3];
            PolOpUtils.getCoherencyMatrixT3(index, dataBuffers, tempTr, tempTi);
            PolOpUtils.t3ToC3(tempTr, tempTi, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.C3) {
            PolOpUtils.getCovarianceMatrixC3(index, dataBuffers, Cr, Ci);
        }
    }

    public static void getCoherencyMatrixT3(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Tr, double[][] Ti) {
        if (sourceProductType == PolBandUtils.MATRIX.FULL) {
            double[][] tempSr = new double[2][2];
            double[][] tempSi = new double[2][2];
            PolOpUtils.getComplexScatterMatrix(index, dataBuffers, tempSr, tempSi);
            PolOpUtils.computeCoherencyMatrixT3(tempSr, tempSi, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.T4) {
            double[][] tempTr = new double[4][4];
            double[][] tempTi = new double[4][4];
            PolOpUtils.getCoherencyMatrixT4(index, dataBuffers, tempTr, tempTi);
            PolOpUtils.t4ToT3(tempTr, tempTi, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.C4) {
            double[][] tempCr = new double[4][4];
            double[][] tempCi = new double[4][4];
            double[][] tempTr = new double[4][4];
            double[][] tempTi = new double[4][4];
            PolOpUtils.getCovarianceMatrixC4(index, dataBuffers, tempCr, tempCi);
            PolOpUtils.c4ToT4(tempCr, tempCi, tempTr, tempTi);
            PolOpUtils.t4ToT3(tempTr, tempTi, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.T3) {
            PolOpUtils.getCoherencyMatrixT3(index, dataBuffers, Tr, Ti);
        } else if (sourceProductType == PolBandUtils.MATRIX.C3) {
            double[][] tempCr = new double[3][3];
            double[][] tempCi = new double[3][3];
            PolOpUtils.getCovarianceMatrixC3(index, dataBuffers, tempCr, tempCi);
            PolOpUtils.c3ToT3(tempCr, tempCi, Tr, Ti);
        }
    }

    public static void eigenDecomposition(int n, double[][] HMr, double[][] HMi, double[][] EigenVectRe, double[][] EigenVectIm, double[] EigenVal) {
        int k;
        double x;
        int j;
        int i;
        double[][] ar = new double[n][n];
        double[][] ai = new double[n][n];
        double[][] vr = new double[n][n];
        double[][] vi = new double[n][n];
        double[] d = new double[n];
        double[] z = new double[n];
        double[] w = new double[2];
        double[] s = new double[2];
        double[] c = new double[2];
        double[] titi = new double[2];
        double[] gc = new double[2];
        double[] hc = new double[2];
        int n2 = n * n;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                ar[i][j] = HMr[i][j];
                ai[i][j] = HMi[i][j];
                vr[i][j] = 0.0;
                vi[i][j] = 0.0;
            }
            vr[i][i] = 1.0;
            vi[i][i] = 0.0;
            d[i] = ar[i][i];
            z[i] = 0.0;
        }
        int iiMax = 1000 * n2;
        for (int ii = 1; ii < iiMax; ++ii) {
            double r;
            double toto;
            int q;
            int p;
            double sm = 0.0;
            for (p = 0; p < n - 1; ++p) {
                for (q = p + 1; q < n; ++q) {
                    sm += 2.0 * Math.sqrt(ar[p][q] * ar[p][q] + ai[p][q] * ai[p][q]);
                }
            }
            if ((sm /= (double)(n2 - n)) < 1.0E-16) break;
            double tresh = 1.0E-17;
            if (ii < 4) {
                tresh = 0.0 * sm / (double)n2;
            }
            x = -1.0E-15;
            p = 0;
            q = 0;
            for (i = 0; i < n - 1; ++i) {
                for (j = i + 1; j < n; ++j) {
                    toto = Math.sqrt(ar[i][j] * ar[i][j] + ai[i][j] * ai[i][j]);
                    if (!(x < toto)) continue;
                    x = toto;
                    p = i;
                    q = j;
                }
            }
            toto = Math.sqrt(ar[p][q] * ar[p][q] + ai[p][q] * ai[p][q]);
            if (!(toto > tresh)) continue;
            double e = d[p] - d[q];
            w[0] = ar[p][q];
            w[1] = ai[p][q];
            double g = Math.sqrt(w[0] * w[0] + w[1] * w[1]);
            g *= g;
            double f = Math.sqrt(e * e + 4.0 * g);
            double d1 = e + f;
            double d2 = e - f;
            if (Math.abs(d2) > Math.abs(d1)) {
                d1 = d2;
            }
            s[0] = r = Math.abs(d1) / Math.sqrt(d1 * d1 + 4.0 * g);
            s[1] = 0.0;
            titi[0] = 2.0 * r / d1;
            titi[1] = 0.0;
            c[0] = titi[0] * w[0] - titi[1] * w[1];
            c[1] = titi[0] * w[1] + titi[1] * w[0];
            r = Math.sqrt(s[0] * s[0] + s[1] * s[1]);
            r *= r;
            double h = (d1 / 2.0 + 2.0 * g / d1) * r;
            d[p] = d[p] - h;
            z[p] = z[p] - h;
            d[q] = d[q] + h;
            z[q] = z[q] + h;
            ar[p][q] = 0.0;
            ai[p][q] = 0.0;
            for (j = 0; j < p; ++j) {
                gc[0] = ar[j][p];
                gc[1] = ai[j][p];
                hc[0] = ar[j][q];
                hc[1] = ai[j][q];
                ar[j][p] = c[0] * gc[0] - c[1] * gc[1] - s[0] * hc[0] - s[1] * hc[1];
                ai[j][p] = c[0] * gc[1] + c[1] * gc[0] - s[0] * hc[1] + s[1] * hc[0];
                ar[j][q] = s[0] * gc[0] - s[1] * gc[1] + c[0] * hc[0] + c[1] * hc[1];
                ai[j][q] = s[0] * gc[1] + s[1] * gc[0] + c[0] * hc[1] - c[1] * hc[0];
            }
            for (j = p + 1; j < q; ++j) {
                gc[0] = ar[p][j];
                gc[1] = ai[p][j];
                hc[0] = ar[j][q];
                hc[1] = ai[j][q];
                ar[p][j] = c[0] * gc[0] + c[1] * gc[1] - s[0] * hc[0] - s[1] * hc[1];
                ai[p][j] = c[0] * gc[1] - c[1] * gc[0] + s[0] * hc[1] - s[1] * hc[0];
                ar[j][q] = s[0] * gc[0] + s[1] * gc[1] + c[0] * hc[0] + c[1] * hc[1];
                ai[j][q] = -s[0] * gc[1] + s[1] * gc[0] + c[0] * hc[1] - c[1] * hc[0];
            }
            for (j = q + 1; j < n; ++j) {
                gc[0] = ar[p][j];
                gc[1] = ai[p][j];
                hc[0] = ar[q][j];
                hc[1] = ai[q][j];
                ar[p][j] = c[0] * gc[0] + c[1] * gc[1] - s[0] * hc[0] + s[1] * hc[1];
                ai[p][j] = c[0] * gc[1] - c[1] * gc[0] - s[0] * hc[1] - s[1] * hc[0];
                ar[q][j] = s[0] * gc[0] + s[1] * gc[1] + c[0] * hc[0] - c[1] * hc[1];
                ai[q][j] = s[0] * gc[1] - s[1] * gc[0] + c[0] * hc[1] + c[1] * hc[0];
            }
            for (j = 0; j < n; ++j) {
                gc[0] = vr[j][p];
                gc[1] = vi[j][p];
                hc[0] = vr[j][q];
                hc[1] = vi[j][q];
                vr[j][p] = c[0] * gc[0] - c[1] * gc[1] - s[0] * hc[0] - s[1] * hc[1];
                vi[j][p] = c[0] * gc[1] + c[1] * gc[0] - s[0] * hc[1] + s[1] * hc[0];
                vr[j][q] = s[0] * gc[0] - s[1] * gc[1] + c[0] * hc[0] + c[1] * hc[1];
                vi[j][q] = s[0] * gc[1] + s[1] * gc[0] + c[0] * hc[1] - c[1] * hc[0];
            }
        }
        for (k = 0; k < n; ++k) {
            d[k] = 0.0;
            for (i = 0; i < n; ++i) {
                for (j = 0; j < n; ++j) {
                    d[k] = d[k] + vr[i][k] * (HMr[i][j] * vr[j][k] - HMi[i][j] * vi[j][k]);
                    d[k] = d[k] + vi[i][k] * (HMr[i][j] * vi[j][k] + HMi[i][j] * vr[j][k]);
                }
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = i + 1; j < n; ++j) {
                if (!(d[j] > d[i])) continue;
                x = d[i];
                d[i] = d[j];
                d[j] = x;
                for (k = 0; k < n; ++k) {
                    double tmp_r = vr[k][i];
                    double tmp_i = vi[k][i];
                    vr[k][i] = vr[k][j];
                    vi[k][i] = vi[k][j];
                    vr[k][j] = tmp_r;
                    vi[k][j] = tmp_i;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            EigenVal[i] = d[i];
            for (j = 0; j < n; ++j) {
                EigenVectRe[i][j] = vr[i][j];
                EigenVectIm[i][j] = vi[i][j];
            }
        }
    }

    public static void eigenDecompGeneral(int n, double[][] HMr, double[][] HMi, double[][] EigenVectRe, double[][] EigenVectIm, double[] EigenVal) {
        int i;
        double[][] H = new double[2 * n][2 * n];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j = 0; j < n; ++j) {
                H[i2][j] = HMr[i2][j];
                H[n + i2][n + j] = HMr[i2][j];
                H[i2][n + j] = -HMi[i2][j];
                H[n + i2][j] = HMi[i2][j];
            }
        }
        Matrix M = new Matrix(H);
        EigenvalueDecomposition Evd = M.eig();
        Matrix V = Evd.getV();
        Matrix D = Evd.getD();
        int n2 = n * 2;
        double[][] d = D.getArray();
        double[][] v = V.getArray();
        for (i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                if (!(Math.abs(d[j][j]) > Math.abs(d[i][i]))) continue;
                double x = d[i][i];
                d[i][i] = d[j][j];
                d[j][j] = x;
                for (int k = 0; k < n2; ++k) {
                    x = v[k][i];
                    v[k][i] = v[k][j];
                    v[k][j] = x;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            int i2 = i * 2;
            EigenVal[i] = d[i2][i2];
            for (int j = 0; j < n; ++j) {
                EigenVectRe[j][i] = v[j][i2];
                EigenVectIm[j][i] = v[n + j][i2];
            }
        }
    }

    public static void inverseComplexMatrix(int n, double[][] Mr, double[][] Mi, double[][] invMr, double[][] invMi) {
        int n2 = n * 2;
        double[][] M = new double[n2][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                M[i][j] = Mr[i][j];
                M[i + n][j + n] = Mr[i][j];
                M[i][j + n] = -Mi[i][j];
                M[i + n][j] = Mi[i][j];
            }
        }
        double[][] I = new double[n2][n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                I[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        Matrix MMat = new Matrix(M);
        Matrix IMat = new Matrix(I);
        Matrix invMMat = MMat.inverse().times(IMat);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                invMr[i][j] = invMMat.get(i, j);
                invMi[i][j] = invMMat.get(i + n, j);
            }
        }
    }
}

