/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Cross-Channel-SNR-Correction", category="Radar/Polarimetric", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Compute general polarimetric parameters")
public final class CrossChannelSNRCorrectionOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The sliding window size", interval="[1, 100]", defaultValue="5", label="Window Size")
    private int windowSize = 5;
    private int halfWindowSize = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private PolBandUtils.MATRIX sourceProductType = null;
    private PolBandUtils.PolSourceBand[] srcBandList;
    private Band hhBand = null;
    private Band hvBand = null;
    private Band vvBand = null;
    private Band vhBand = null;

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            if (this.sourceProductType != PolBandUtils.MATRIX.FULL) {
                throw new OperatorException("Quad-pol source product is expected.");
            }
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.halfWindowSize = this.windowSize / 2;
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            int k = 0;
            Band[] targetBands = new Band[4];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                String bandName = bandList.srcBands[i].getName();
                if (bandName.toLowerCase().contains("_hv") || bandName.toLowerCase().contains("_vh")) {
                    Band targetBand = new Band(bandName, 30, this.sourceImageWidth, this.sourceImageHeight);
                    targetBand.setUnit(bandList.srcBands[i].getUnit());
                    this.targetProduct.addBand(targetBand);
                    targetBands[k++] = targetBand;
                    continue;
                }
                ProductUtils.copyBand((String)bandName, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
            }
            bandList.addTargetBands(targetBands);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absRoot != null) {
            absRoot.setAttributeInt("polsar_data", 1);
        }
        PolBandUtils.saveNewBandNames((Product)this.targetProduct, (PolBandUtils.PolSourceBand[])this.srcBandList);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        double[][] Cr = new double[4][4];
        double[][] Ci = new double[4][4];
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            try {
                TileData[] tileDataList = new TileData[bandList.targetBands.length];
                int i = 0;
                for (Band targetBand : bandList.targetBands) {
                    Tile targetTile = targetTiles.get(targetBand);
                    tileDataList[i++] = new TileData(targetTile, targetBand.getName());
                }
                TileIndex trgIndex = new TileIndex(tileDataList[0].tile);
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
                for (int j = 0; j < bandList.srcBands.length; ++j) {
                    Band srcBand = bandList.srcBands[j];
                    sourceTiles[j] = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle);
                    dataBuffers[j] = sourceTiles[j].getDataBuffer();
                }
                TileIndex srcIndex = new TileIndex(sourceTiles[0]);
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    srcIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        int tgtIdx = trgIndex.getIndex(x);
                        PolOpUtils.getMeanCovarianceMatrixC4(x, y, this.halfWindowSize, this.halfWindowSize, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                        double gamma = Math.sqrt((Cr[1][2] * Cr[1][2] + Ci[1][2] * Ci[1][2]) / (Cr[1][1] * Cr[2][2]));
                        for (TileData tileData : tileDataList) {
                            double v = 0.0;
                            if (tileData.bandName.contains("i_HV")) {
                                v = dataBuffers[2].getElemDoubleAt(srcIndex.getIndex(x));
                            } else if (tileData.bandName.contains("q_HV")) {
                                v = dataBuffers[3].getElemDoubleAt(srcIndex.getIndex(x));
                            } else if (tileData.bandName.contains("i_VH")) {
                                v = dataBuffers[4].getElemDoubleAt(srcIndex.getIndex(x));
                            } else if (tileData.bandName.contains("q_VH")) {
                                v = dataBuffers[5].getElemDoubleAt(srcIndex.getIndex(x));
                            }
                            tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)(gamma * v));
                        }
                    }
                }
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    private Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int x0 = Math.max(0, tx0 - this.halfWindowSize);
        int y0 = Math.max(0, ty0 - this.halfWindowSize);
        int xMax = Math.min(tx0 + tw - 1 + this.halfWindowSize, this.sourceImageWidth - 1);
        int yMax = Math.min(ty0 + th - 1 + this.halfWindowSize, this.sourceImageHeight - 1);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CrossChannelSNRCorrectionOp.class);
        }
    }

    private static class TileData {
        final Tile tile;
        final ProductData dataBuffer;
        final String bandName;

        public TileData(Tile tile, String bandName) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            this.bandName = bandName;
        }
    }
}

