/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.specklefilters;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.PolarimetricSpeckleFilterOp;
import org.csa.rstb.polarimetric.gpf.specklefilters.SpeckleFilter;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class IDAN
implements SpeckleFilter {
    private final PolarimetricSpeckleFilterOp operator;
    private final Product sourceProduct;
    private final Product targetProduct;
    private final PolBandUtils.MATRIX sourceProductType;
    private final PolBandUtils.PolSourceBand[] srcBandList;
    private final int filterSize;
    private final int anSize;
    private final double sigmaV;
    private final double sigmaVSqr;

    public IDAN(PolarimetricSpeckleFilterOp op, Product srcProduct, Product trgProduct, PolBandUtils.MATRIX sourceProductType, PolBandUtils.PolSourceBand[] srcBandList, int anSize, int numLooks) {
        this.operator = op;
        this.sourceProduct = srcProduct;
        this.targetProduct = trgProduct;
        this.sourceProductType = sourceProductType;
        this.srcBandList = srcBandList;
        this.filterSize = anSize * 2;
        this.anSize = anSize;
        this.sigmaV = 1.0 / Math.sqrt(numLooks);
        this.sigmaVSqr = this.sigmaV * this.sigmaV;
    }

    @Override
    public void computeTiles(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        if (this.sourceProductType == PolBandUtils.MATRIX.FULL || this.sourceProductType == PolBandUtils.MATRIX.C3 || this.sourceProductType == PolBandUtils.MATRIX.T3) {
            this.idanFilter(targetTiles, targetRectangle, sourceRectangle);
        } else if (this.sourceProductType == PolBandUtils.MATRIX.C2 || this.sourceProductType == PolBandUtils.MATRIX.DUAL_HH_HV || this.sourceProductType == PolBandUtils.MATRIX.DUAL_VH_VV || this.sourceProductType == PolBandUtils.MATRIX.DUAL_HH_VV) {
            this.idanFilterC2(targetTiles, targetRectangle, sourceRectangle);
        } else {
            throw new OperatorException("For IDAN filtering, only C2, C3 and T3 are currently supported");
        }
    }

    private void idanFilterC2(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        double[][] data11Real = new double[sh][sw];
        double[][] data12Real = new double[sh][sw];
        double[][] data12Imag = new double[sh][sw];
        double[][] data22Real = new double[sh][sw];
        double[][] span = new double[sh][sw];
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            Tile srcTile = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[0], sourceRectangle);
            this.createC2SpanImage(srcTile, this.sourceProductType, sourceRectangle, dataBuffers, data11Real, data12Real, data12Imag, data22Real, span);
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int idx = trgIndex.getIndex(x);
                    Seed seed = IDAN.getInitialSeed(x, y, sx0, sy0, sw, sh, data11Real, data22Real);
                    Pix[] anPixelList = this.getIDANPixels(x, y, sx0, sy0, sw, sh, data11Real, data22Real, seed);
                    double b = this.computeFilterScaleParam(sx0, sy0, anPixelList, span);
                    for (Band targetBand : bandList.targetBands) {
                        double value;
                        String targetBandName = targetBand.getName();
                        ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                        if (targetBandName.contains("C11")) {
                            value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data11Real, b);
                            dataBuffer.setElemFloatAt(idx, (float)value);
                            continue;
                        }
                        if (targetBandName.contains("C12_real")) {
                            value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data12Real, b);
                            dataBuffer.setElemFloatAt(idx, (float)value);
                            continue;
                        }
                        if (targetBandName.contains("C12_imag")) {
                            value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data12Imag, b);
                            dataBuffer.setElemFloatAt(idx, (float)value);
                            continue;
                        }
                        if (!targetBandName.contains("C22")) continue;
                        value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data22Real, b);
                        dataBuffer.setElemFloatAt(idx, (float)value);
                    }
                }
            }
        }
    }

    private static Seed getInitialSeed(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real) {
        double[] d11 = new double[9];
        double[] d22 = new double[9];
        int k = 0;
        for (int y = yc - 1; y <= yc + 1; ++y) {
            for (int x = xc - 1; x <= xc + 1; ++x) {
                if (x < sx0 || x >= sx0 + sw || y < sy0 || y >= sy0 + sh) continue;
                int r = y - sy0;
                int c = x - sx0;
                d11[k] = data11Real[r][c];
                d22[k] = data22Real[r][c];
                ++k;
            }
        }
        Arrays.sort(d11, 0, k);
        Arrays.sort(d22, 0, k);
        int med = k / 2;
        Seed seed = new Seed();
        seed.value[0] = d11[med];
        seed.value[1] = d22[med];
        seed.calculateAbsolutes();
        return seed;
    }

    private Pix[] getIDANPixels(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real, Seed seed) {
        double threshold50 = 1.0 * this.sigmaV;
        ArrayList<Pix> anPixelList = new ArrayList<Pix>(this.anSize);
        Pix[] bgPixelList = this.regionGrowing(xc, yc, sx0, sy0, sw, sh, data11Real, data22Real, seed, threshold50, anPixelList);
        Seed newSeed = new Seed();
        if (!anPixelList.isEmpty()) {
            for (Pix pixel : anPixelList) {
                newSeed.value[0] = newSeed.value[0] + data11Real[pixel.y - sy0][pixel.x - sx0];
                newSeed.value[1] = newSeed.value[1] + data22Real[pixel.y - sy0][pixel.x - sx0];
            }
            newSeed.value[0] = newSeed.value[0] / (double)anPixelList.size();
            newSeed.value[1] = newSeed.value[1] / (double)anPixelList.size();
        } else {
            newSeed.value[0] = seed.value[0];
            newSeed.value[1] = seed.value[1];
        }
        newSeed.calculateAbsolutes();
        double threshold95 = 4.0 * this.sigmaV;
        IDAN.reExamBackgroundPixels(sx0, sy0, data11Real, data22Real, newSeed, threshold95, anPixelList, bgPixelList);
        if (anPixelList.isEmpty()) {
            return new Pix[]{new Pix(xc, yc)};
        }
        return anPixelList.toArray(new Pix[anPixelList.size()]);
    }

    private static void reExamBackgroundPixels(int sx0, int sy0, double[][] data11Real, double[][] data22Real, Seed seed, double threshold, List<Pix> anPixelList, Pix[] bgPixelList) {
        for (Pix pixel : bgPixelList) {
            int r = pixel.y - sy0;
            int c = pixel.x - sx0;
            if (!(IDAN.distance(data11Real[r][c], data22Real[r][c], seed) < threshold)) continue;
            anPixelList.add(new Pix(pixel.x, pixel.y));
        }
    }

    private Pix[] regionGrowing(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real, Seed seed, double threshold, List<Pix> anPixelList) {
        int rc = yc - sy0;
        int cc = xc - sx0;
        HashMap<Integer, Boolean> visited = new HashMap<Integer, Boolean>(this.anSize + 8);
        ArrayList<Pix> bgPixelList = new ArrayList<Pix>(this.anSize);
        if (IDAN.distance(data11Real[rc][cc], data22Real[rc][cc], seed) < threshold) {
            anPixelList.add(new Pix(xc, yc));
        } else {
            bgPixelList.add(new Pix(xc, yc));
        }
        visited.put(rc * sw + cc, true);
        ArrayList<Pix> front = new ArrayList<Pix>(this.anSize);
        front.add(new Pix(xc, yc));
        ArrayList<Pix> newfront = new ArrayList<Pix>(this.anSize);
        int width = sx0 + sw;
        int height = sy0 + sh;
        while (anPixelList.size() < this.anSize && !front.isEmpty()) {
            newfront.clear();
            for (Pix p : front) {
                int[] x = new int[]{p.x - 1, p.x, p.x + 1, p.x - 1, p.x + 1, p.x - 1, p.x, p.x + 1};
                int[] y = new int[]{p.y - 1, p.y - 1, p.y - 1, p.y, p.y, p.y + 1, p.y + 1, p.y + 1};
                for (int i = 0; i < 8; ++i) {
                    int c;
                    int r;
                    Integer index;
                    if (x[i] < sx0 || x[i] >= width || y[i] < sy0 || y[i] >= height || visited.get(index = Integer.valueOf((r = y[i] - sy0) * sw + (c = x[i] - sx0))) != null) continue;
                    visited.put(index, true);
                    Pix newPos = new Pix(x[i], y[i]);
                    if (IDAN.distance(data11Real[r][c], data22Real[r][c], seed) < threshold) {
                        anPixelList.add(newPos);
                        newfront.add(newPos);
                        continue;
                    }
                    bgPixelList.add(newPos);
                }
                if (anPixelList.size() <= this.anSize) continue;
                break;
            }
            front.clear();
            front.addAll(newfront);
        }
        return bgPixelList.toArray(new Pix[bgPixelList.size()]);
    }

    private void idanFilter(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Rectangle sourceRectangle) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        int sx0 = sourceRectangle.x;
        int sy0 = sourceRectangle.y;
        int sw = sourceRectangle.width;
        int sh = sourceRectangle.height;
        double[][] data11Real = new double[sh][sw];
        double[][] data12Real = new double[sh][sw];
        double[][] data12Imag = new double[sh][sw];
        double[][] data13Real = new double[sh][sw];
        double[][] data13Imag = new double[sh][sw];
        double[][] data22Real = new double[sh][sw];
        double[][] data23Real = new double[sh][sw];
        double[][] data23Imag = new double[sh][sw];
        double[][] data33Real = new double[sh][sw];
        double[][] span = new double[sh][sw];
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            Tile srcTile = this.operator.getSourceTile((RasterDataNode)bandList.srcBands[0], sourceRectangle);
            this.createT3SpanImage(srcTile, this.sourceProductType, sourceRectangle, dataBuffers, data11Real, data12Real, data12Imag, data13Real, data13Imag, data22Real, data23Real, data23Imag, data33Real, span);
            ProductData[] targetDataBuffers = new ProductData[9];
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                ProductData dataBuffer = targetTiles.get(targetBand).getDataBuffer();
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"11")) {
                    targetDataBuffers[0] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_real")) {
                    targetDataBuffers[1] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"12_imag")) {
                    targetDataBuffers[2] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_real")) {
                    targetDataBuffers[3] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"13_imag")) {
                    targetDataBuffers[4] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"22")) {
                    targetDataBuffers[5] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_real")) {
                    targetDataBuffers[6] = dataBuffer;
                    continue;
                }
                if (PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"23_imag")) {
                    targetDataBuffers[7] = dataBuffer;
                    continue;
                }
                if (!PolBandUtils.isBandForMatrixElement((String)targetBandName, (String)"33")) continue;
                targetDataBuffers[8] = dataBuffer;
            }
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int idx = trgIndex.getIndex(x);
                    Seed seed = IDAN.getInitialSeed(x, y, sx0, sy0, sw, sh, data11Real, data22Real, data33Real);
                    Pix[] anPixelList = this.getIDANPixels(x, y, sx0, sy0, sw, sh, data11Real, data22Real, data33Real, seed);
                    double b = this.computeFilterScaleParam(sx0, sy0, anPixelList, span);
                    int i = 0;
                    double value = 0.0;
                    for (SpeckleFilter.T3Elem elem : SpeckleFilter.T3Elem.values()) {
                        switch (elem) {
                            case T11: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data11Real, b);
                                i = 0;
                                break;
                            }
                            case T12_real: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data12Real, b);
                                i = 1;
                                break;
                            }
                            case T12_imag: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data12Imag, b);
                                i = 2;
                                break;
                            }
                            case T13_real: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data13Real, b);
                                i = 3;
                                break;
                            }
                            case T13_imag: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data13Imag, b);
                                i = 4;
                                break;
                            }
                            case T22: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data22Real, b);
                                i = 5;
                                break;
                            }
                            case T23_real: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data23Real, b);
                                i = 6;
                                break;
                            }
                            case T23_imag: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data23Imag, b);
                                i = 7;
                                break;
                            }
                            case T33: {
                                value = IDAN.getIDANFilteredValue(x, y, sx0, sy0, anPixelList, data33Real, b);
                                i = 8;
                                break;
                            }
                        }
                        targetDataBuffers[i].setElemFloatAt(idx, (float)value);
                    }
                }
            }
        }
    }

    private static Seed getInitialSeed(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real, double[][] data33Real) {
        double[] d11 = new double[9];
        double[] d22 = new double[9];
        double[] d33 = new double[9];
        int k = 0;
        for (int y = yc - 1; y <= yc + 1; ++y) {
            for (int x = xc - 1; x <= xc + 1; ++x) {
                if (x < sx0 || x >= sx0 + sw || y < sy0 || y >= sy0 + sh) continue;
                int r = y - sy0;
                int c = x - sx0;
                d11[k] = data11Real[r][c];
                d22[k] = data22Real[r][c];
                d33[k] = data33Real[r][c];
                ++k;
            }
        }
        Arrays.sort(d11, 0, k);
        Arrays.sort(d22, 0, k);
        Arrays.sort(d33, 0, k);
        int med = k / 2;
        Seed seed = new Seed();
        seed.value[0] = d11[med];
        seed.value[1] = d22[med];
        seed.value[2] = d33[med];
        seed.calculateAbsolutes();
        return seed;
    }

    private Pix[] getIDANPixels(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real, double[][] data33Real, Seed seed) {
        double threshold50 = 2.0 * this.sigmaV;
        ArrayList<Pix> anPixelList = new ArrayList<Pix>(this.anSize);
        Pix[] bgPixelList = this.regionGrowing(xc, yc, sx0, sy0, sw, sh, data11Real, data22Real, data33Real, seed, threshold50, anPixelList);
        Seed newSeed = new Seed();
        if (!anPixelList.isEmpty()) {
            for (Pix pixel : anPixelList) {
                newSeed.value[0] = newSeed.value[0] + data11Real[pixel.y - sy0][pixel.x - sx0];
                newSeed.value[1] = newSeed.value[1] + data22Real[pixel.y - sy0][pixel.x - sx0];
                newSeed.value[2] = newSeed.value[2] + data33Real[pixel.y - sy0][pixel.x - sx0];
            }
            newSeed.value[0] = newSeed.value[0] / (double)anPixelList.size();
            newSeed.value[1] = newSeed.value[1] / (double)anPixelList.size();
            newSeed.value[2] = newSeed.value[2] / (double)anPixelList.size();
        } else {
            newSeed.value[0] = seed.value[0];
            newSeed.value[1] = seed.value[1];
            newSeed.value[2] = seed.value[2];
        }
        newSeed.calculateAbsolutes();
        double threshold95 = 6.0 * this.sigmaV;
        IDAN.reExamBackgroundPixels(sx0, sy0, data11Real, data22Real, data33Real, newSeed, threshold95, anPixelList, bgPixelList);
        if (anPixelList.isEmpty()) {
            return new Pix[]{new Pix(xc, yc)};
        }
        return anPixelList.toArray(new Pix[anPixelList.size()]);
    }

    private Pix[] regionGrowing(int xc, int yc, int sx0, int sy0, int sw, int sh, double[][] data11Real, double[][] data22Real, double[][] data33Real, Seed seed, double threshold, List<Pix> anPixelList) {
        int rc = yc - sy0;
        int cc = xc - sx0;
        HashMap<Integer, Boolean> visited = new HashMap<Integer, Boolean>(this.anSize + 8);
        ArrayList<Pix> bgPixelList = new ArrayList<Pix>(this.anSize);
        if (IDAN.distance(data11Real[rc][cc], data22Real[rc][cc], data33Real[rc][cc], seed) < threshold) {
            anPixelList.add(new Pix(xc, yc));
        } else {
            bgPixelList.add(new Pix(xc, yc));
        }
        visited.put(rc * sw + cc, true);
        ArrayList<Pix> front = new ArrayList<Pix>(this.anSize);
        front.add(new Pix(xc, yc));
        ArrayList<Pix> newfront = new ArrayList<Pix>(this.anSize);
        int width = sx0 + sw;
        int height = sy0 + sh;
        while (anPixelList.size() < this.anSize && !front.isEmpty()) {
            newfront.clear();
            for (Pix p : front) {
                int[] x = new int[]{p.x - 1, p.x, p.x + 1, p.x - 1, p.x + 1, p.x - 1, p.x, p.x + 1};
                int[] y = new int[]{p.y - 1, p.y - 1, p.y - 1, p.y, p.y, p.y + 1, p.y + 1, p.y + 1};
                for (int i = 0; i < 8; ++i) {
                    int c;
                    int r;
                    Integer index;
                    if (x[i] < sx0 || x[i] >= width || y[i] < sy0 || y[i] >= height || visited.get(index = Integer.valueOf((r = y[i] - sy0) * sw + (c = x[i] - sx0))) != null) continue;
                    visited.put(index, true);
                    Pix newPos = new Pix(x[i], y[i]);
                    if (IDAN.distance(data11Real[r][c], data22Real[r][c], data33Real[r][c], seed) < threshold) {
                        anPixelList.add(newPos);
                        newfront.add(newPos);
                        continue;
                    }
                    bgPixelList.add(newPos);
                }
                if (anPixelList.size() <= this.anSize) continue;
                break;
            }
            front.clear();
            front.addAll(newfront);
        }
        return bgPixelList.toArray(new Pix[bgPixelList.size()]);
    }

    private static double distance(double p0, double p1, Seed seed) {
        return Math.abs(p0 - seed.value[0]) / seed.absValue[0] + Math.abs(p1 - seed.value[1]) / seed.absValue[1];
    }

    private static double distance(double p0, double p1, double p2, Seed seed) {
        return Math.abs(p0 - seed.value[0]) / seed.absValue[0] + Math.abs(p1 - seed.value[1]) / seed.absValue[1] + Math.abs(p2 - seed.value[2]) / seed.absValue[2];
    }

    private static void reExamBackgroundPixels(int sx0, int sy0, double[][] data11Real, double[][] data22Real, double[][] data33Real, Seed seed, double threshold, List<Pix> anPixelList, Pix[] bgPixelList) {
        for (Pix pixel : bgPixelList) {
            int r = pixel.y - sy0;
            int c = pixel.x - sx0;
            if (!(IDAN.distance(data11Real[r][c], data22Real[r][c], data33Real[r][c], seed) < threshold)) continue;
            anPixelList.add(new Pix(pixel.x, pixel.y));
        }
    }

    private double computeFilterScaleParam(int sx0, int sy0, Pix[] anPixelList, double[][] span) {
        double[] spanPixels = new double[anPixelList.length];
        int k = 0;
        for (Pix pixel : anPixelList) {
            spanPixels[k++] = span[pixel.y - sy0][pixel.x - sx0];
        }
        return this.computeMMSEWeight(spanPixels, this.sigmaVSqr);
    }

    private static double getIDANFilteredValue(int x, int y, int sx0, int sy0, Pix[] anPixelList, double[][] data, double b) {
        double mean = 0.0;
        for (Pix pixel : anPixelList) {
            mean += data[pixel.y - sy0][pixel.x - sx0];
        }
        return (mean /= (double)anPixelList.length) + b * (data[y - sy0][x - sx0] - mean);
    }

    private static class Seed {
        final double[] value = new double[3];
        final double[] absValue = new double[3];

        private Seed() {
        }

        public void calculateAbsolutes() {
            this.absValue[0] = Math.abs(this.value[0]);
            this.absValue[1] = Math.abs(this.value[1]);
            this.absValue[2] = Math.abs(this.value[2]);
        }
    }

    private static final class Pix {
        final int x;
        final int y;

        public Pix(int xx, int yy) {
            this.x = xx;
            this.y = yy;
        }
    }
}

