/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.decompositions;

import java.awt.Rectangle;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.csa.rstb.polarimetric.gpf.DualPolOpUtils;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.csa.rstb.polarimetric.gpf.decompositions.Decomposition;
import org.csa.rstb.polarimetric.gpf.decompositions.DecompositionBase;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class HAlphaC2
extends DecompositionBase
implements Decomposition {
    public HAlphaC2(PolBandUtils.PolSourceBand[] srcBandList, PolBandUtils.MATRIX sourceProductType, int windowSize, int srcImageWidth, int srcImageHeight) {
        super(srcBandList, sourceProductType, windowSize, windowSize, srcImageWidth, srcImageHeight);
    }

    @Override
    public String[] getTargetBandNames() {
        return new String[]{"Entropy", "Anisotropy", "Alpha"};
    }

    @Override
    public void setBandUnit(String targetBandName, Band targetBand) {
        if (targetBandName.contains("Entropy")) {
            targetBand.setUnit("entropy");
        } else if (targetBandName.contains("Anisotropy")) {
            targetBand.setUnit("anisotropy");
        } else if (targetBandName.equals("Alpha")) {
            targetBand.setUnit("deg");
        }
    }

    @Override
    public void computeTile(Map<Band, Tile> targetTiles, Rectangle targetRectangle, Operator op) {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        double[][] Cr = new double[2][2];
        double[][] Ci = new double[2][2];
        Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            DecompositionBase.TargetInfo[] targetInfo = new DecompositionBase.TargetInfo[bandList.targetBands.length];
            int j = 0;
            for (Band targetBand : bandList.targetBands) {
                String targetBandName = targetBand.getName();
                if (targetBandName.contains("Entropy")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.R);
                } else if (targetBandName.contains("Anisotropy")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.G);
                } else if (targetBandName.contains("Alpha")) {
                    targetInfo[j] = new DecompositionBase.TargetInfo(targetTiles.get(targetBand), DecompositionBase.TargetBandColour.B);
                }
                ++j;
            }
            TileIndex trgIndex = new TileIndex(targetInfo[0].tile);
            Tile[] sourceTiles = new Tile[bandList.srcBands.length];
            ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
            for (int i = 0; i < bandList.srcBands.length; ++i) {
                sourceTiles[i] = op.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                dataBuffers[i] = sourceTiles[i].getDataBuffer();
            }
            double v = 0.0;
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    int index = trgIndex.getIndex(x);
                    DualPolOpUtils.getMeanCovarianceMatrixC2(x, y, this.halfWindowSizeX, this.halfWindowSizeY, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, sourceTiles, dataBuffers, Cr, Ci);
                    HAAlpha data = HAlphaC2.computeHAAlphaByC2(Cr, Ci);
                    for (DecompositionBase.TargetInfo target : targetInfo) {
                        if (target.colour == DecompositionBase.TargetBandColour.R) {
                            v = data.entropy;
                        } else if (target.colour == DecompositionBase.TargetBandColour.G) {
                            v = data.anisotropy;
                        } else if (target.colour == DecompositionBase.TargetBandColour.B) {
                            v = data.alpha;
                        }
                        target.dataBuffer.setElemFloatAt(index, (float)v);
                    }
                }
            }
        }
    }

    public static HAAlpha computeHAAlphaByC2(double[][] Cr, double[][] Ci) {
        HAAlpha data = new HAAlpha();
        double[][] EigenVectRe = new double[2][2];
        double[][] EigenVectIm = new double[2][2];
        double[] EigenVal = new double[2];
        PolOpUtils.eigenDecomposition(2, Cr, Ci, EigenVectRe, EigenVectIm, EigenVal);
        double sum = EigenVal[0] + EigenVal[1];
        double[] p = new double[]{EigenVal[0] / sum, EigenVal[1] / sum};
        data.entropy = -(p[0] * Math.log(p[0] + 1.0E-15) + p[1] * Math.log(p[1] + 1.0E-15)) / Math.log(2.0);
        data.anisotropy = (p[0] - p[1]) / (p[0] + p[1] + 1.0E-15);
        double alpha = FastMath.acos((double)HAlphaC2.norm(EigenVectRe[0][0], EigenVectIm[0][0])) * 57.29577951308232;
        double alpha2 = FastMath.acos((double)HAlphaC2.norm(EigenVectRe[1][0], EigenVectIm[1][0])) * 57.29577951308232;
        data.alpha = p[0] * alpha + p[1] * alpha2;
        return data;
    }

    private static double norm(double real, double imag) {
        return Math.sqrt(real * real + imag * imag);
    }

    public static class HAAlpha {
        public double entropy;
        public double anisotropy;
        public double alpha;
    }
}

