/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.specklefilters.BoxCar;
import org.csa.rstb.polarimetric.gpf.specklefilters.IDAN;
import org.csa.rstb.polarimetric.gpf.specklefilters.LeeSigma;
import org.csa.rstb.polarimetric.gpf.specklefilters.RefinedLee;
import org.csa.rstb.polarimetric.gpf.specklefilters.SpeckleFilter;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="Polarimetric-Speckle-Filter", category="Radar/Polarimetric", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Polarimetric Speckle Reduction")
public class PolarimetricSpeckleFilterOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct = null;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"Box Car Filter", "IDAN Filter", "Refined Lee Filter", "Improved Lee Sigma Filter"}, defaultValue="Refined Lee Filter", label="Filter")
    private String filter;
    @Parameter(description="The filter size", interval="(1, 100]", defaultValue="5", label="Filter Size")
    private int filterSize = 5;
    @Parameter(valueSet={"1", "2", "3", "4"}, defaultValue="1", label="Number of Looks")
    private String numLooksStr = "1";
    @Parameter(valueSet={"5x5", "7x7", "9x9", "11x11"}, defaultValue="7x7", label="Window Size")
    private String windowSize = "7x7";
    @Parameter(valueSet={"3x3", "5x5"}, defaultValue="3x3", label="Point target window Size")
    private String targetWindowSizeStr = "3x3";
    @Parameter(description="The Adaptive Neighbourhood size", interval="(1, 200]", defaultValue="50", label="Adaptive Neighbourhood Size")
    private int anSize = 50;
    @Parameter(valueSet={"0.5", "0.6", "0.7", "0.8", "0.9"}, defaultValue="0.9", label="Point target window Size")
    private String sigmaStr = "0.9";
    private PolBandUtils.PolSourceBand[] srcBandList;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private PolBandUtils.MATRIX sourceProductType = null;
    public static final String BOXCAR_SPECKLE_FILTER = "Box Car Filter";
    public static final String REFINED_LEE_FILTER = "Refined Lee Filter";
    public static final String IDAN_FILTER = "IDAN Filter";
    public static final String LEE_SIGMA_FILTER = "Improved Lee Sigma Filter";
    public static final String WINDOW_SIZE_3x3 = "3x3";
    public static final String WINDOW_SIZE_5x5 = "5x5";
    public static final String WINDOW_SIZE_7x7 = "7x7";
    public static final String WINDOW_SIZE_9x9 = "9x9";
    public static final String WINDOW_SIZE_11x11 = "11x11";
    public static final String NUM_LOOKS_1 = "1";
    public static final String NUM_LOOKS_2 = "2";
    public static final String NUM_LOOKS_3 = "3";
    public static final String NUM_LOOKS_4 = "4";
    private SpeckleFilter speckleFilter;
    private static final String PRODUCT_SUFFIX = "_Spk";

    public void SetFilter(String s) {
        if (!(s.equals(BOXCAR_SPECKLE_FILTER) || s.equals(IDAN_FILTER) || s.equals(REFINED_LEE_FILTER) || s.equals(LEE_SIGMA_FILTER))) {
            throw new OperatorException(s + " is an invalid filter name.");
        }
        this.filter = s;
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSLC();
            validator.checkIfTOPSARBurstProduct(false);
            this.getSourceImageDimension();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.checkSourceProductType(this.sourceProductType);
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.createTargetProduct();
            this.speckleFilter = this.createFilter();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkSourceProductType(PolBandUtils.MATRIX sourceProductType) {
        if (sourceProductType == PolBandUtils.MATRIX.UNKNOWN) {
            throw new OperatorException("Input should be a polarimetric product");
        }
    }

    private void getWindowSize() {
        switch (this.windowSize) {
            case "5x5": {
                this.filterSize = 5;
                break;
            }
            case "7x7": {
                this.filterSize = 7;
                break;
            }
            case "9x9": {
                this.filterSize = 9;
                break;
            }
            case "11x11": {
                this.filterSize = 11;
                break;
            }
            default: {
                throw new OperatorException("Unknown window size: " + this.windowSize);
            }
        }
    }

    private SpeckleFilter createFilter() {
        int numLooks = Integer.parseInt(this.numLooksStr);
        switch (this.filter) {
            case "Box Car Filter": {
                return new BoxCar(this, this.sourceProduct, this.targetProduct, this.sourceProductType, this.srcBandList, this.filterSize);
            }
            case "Refined Lee Filter": {
                this.getWindowSize();
                return new RefinedLee(this, this.sourceProduct, this.targetProduct, this.sourceProductType, this.srcBandList, this.filterSize, numLooks);
            }
            case "IDAN Filter": {
                return new IDAN(this, this.sourceProduct, this.targetProduct, this.sourceProductType, this.srcBandList, this.anSize, numLooks);
            }
            case "Improved Lee Sigma Filter": {
                this.getWindowSize();
                return new LeeSigma(this, this.sourceProduct, this.targetProduct, this.sourceProductType, this.srcBandList, this.filterSize, numLooks, this.sigmaStr, this.targetWindowSizeStr);
            }
        }
        return null;
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
        AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct).setAttributeInt("polsar_data", 1);
    }

    private void addSelectedBands() throws OperatorException {
        String[] bandNames = null;
        boolean copyInputBands = false;
        if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
            bandNames = PolBandUtils.getT3BandNames();
        } else if (PolBandUtils.isDualPol((PolBandUtils.MATRIX)this.sourceProductType)) {
            bandNames = PolBandUtils.getC2BandNames();
        } else {
            copyInputBands = true;
        }
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            String suffix = bandList.suffix;
            if (copyInputBands) {
                bandNames = new String[bandList.srcBands.length];
                int i = 0;
                for (Band band : bandList.srcBands) {
                    bandNames[i++] = band.getName();
                }
                suffix = "";
            }
            Band[] targetBands = OperatorUtils.addBands((Product)this.targetProduct, (String[])bandNames, (String)suffix);
            bandList.addTargetBands(targetBands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            this.speckleFilter.computeTiles(targetTiles, targetRectangle, this.getSourceTileRectangle(targetRectangle));
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private Rectangle getSourceTileRectangle(Rectangle rect) {
        int sx0 = rect.x;
        int sy0 = rect.y;
        int sw = rect.width;
        int sh = rect.height;
        int halfFilterSize = this.filterSize / 2;
        if (rect.x >= halfFilterSize) {
            sx0 -= halfFilterSize;
            sw += halfFilterSize;
        }
        if (rect.y >= halfFilterSize) {
            sy0 -= halfFilterSize;
            sh += halfFilterSize;
        }
        if (rect.x + rect.width + halfFilterSize <= this.sourceImageWidth) {
            sw += halfFilterSize;
        }
        if (rect.y + rect.height + halfFilterSize <= this.sourceImageHeight) {
            sh += halfFilterSize;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PolarimetricSpeckleFilterOp.class);
        }
    }
}

