/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Polarimetric-Parameters", category="Radar/Polarimetric", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Compute general polarimetric parameters")
public final class PolarimetricParametersOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="Use mean coherency or covariance matrix", defaultValue="true", label="Use Mean Matrix")
    private boolean useMeanMatrix = true;
    @Parameter(valueSet={"3", "5", "7", "9", "11", "13", "15", "17", "19"}, defaultValue="5", label="Window Size X")
    private String windowSizeXStr = "5";
    @Parameter(valueSet={"3", "5", "7", "9", "11", "13", "15", "17", "19"}, defaultValue="5", label="Window Size Y")
    private String windowSizeYStr = "5";
    @Parameter(description="Output Span", defaultValue="true", label="Span")
    private boolean outputSpan = true;
    @Parameter(description="Output pedestal height", defaultValue="false", label="Pedestal Height")
    private boolean outputPedestalHeight = false;
    @Parameter(description="Output RVI", defaultValue="false", label="Radar Vegetation Index")
    private boolean outputRVI = false;
    @Parameter(description="Output RFDI", defaultValue="false", label="Radar Forest Degradation Index")
    private boolean outputRFDI = false;
    @Parameter(description="Output HH/HV", defaultValue="false", label="HH/HV Ratio")
    private boolean outputHHHVRatio = false;
    private int windowSizeX = 0;
    private int windowSizeY = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean isCompactPol = false;
    private PolBandUtils.MATRIX sourceProductType = null;
    private PolBandUtils.PolSourceBand[] srcBandList;
    private Band hhBand = null;
    private Band hvBand = null;

    public void SetOutputParameter(String s) {
        switch (s) {
            case "Span": {
                this.outputSpan = true;
                break;
            }
            case "Pedestal Height": {
                this.outputPedestalHeight = true;
                break;
            }
            case "RVI": {
                this.outputRVI = true;
                break;
            }
            case "RFDI": {
                this.outputRFDI = true;
                break;
            }
            case "HHHVRatio": {
                this.outputHHHVRatio = true;
                break;
            }
            default: {
                throw new OperatorException(s + " is an invalid parameter name.");
            }
        }
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            if (this.outputSpan || this.outputPedestalHeight || this.outputRVI) {
                if (this.sourceProductType == PolBandUtils.MATRIX.LCHCP || this.sourceProductType == PolBandUtils.MATRIX.RCHCP || this.sourceProductType == PolBandUtils.MATRIX.C2) {
                    this.isCompactPol = true;
                } else if (this.sourceProductType == PolBandUtils.MATRIX.C3 || this.sourceProductType == PolBandUtils.MATRIX.T3 || this.sourceProductType == PolBandUtils.MATRIX.FULL) {
                    this.isCompactPol = false;
                } else {
                    throw new OperatorException("A quad-pol product is expected.");
                }
            }
            if (this.isCompactPol) {
                throw new OperatorException("A quad-pol product is expected.");
            }
            if (this.outputRFDI || this.outputHHHVRatio) {
                for (Band srcBand : this.sourceProduct.getBands()) {
                    if (!srcBand.getUnit().equals("intensity")) continue;
                    if (srcBand.getName().toUpperCase().contains("HH")) {
                        this.hhBand = srcBand;
                    } else if (srcBand.getName().toUpperCase().contains("HV")) {
                        this.hvBand = srcBand;
                    }
                    if (this.hhBand != null && this.hvBand != null) break;
                }
            }
            if (!(this.outputSpan || this.outputPedestalHeight || this.outputRVI || this.outputRFDI || this.outputHHHVRatio)) {
                throw new OperatorException("Please select parameters to output.");
            }
            if ((this.outputRFDI || this.outputHHHVRatio) && (this.hhBand == null || this.hvBand == null)) {
                throw new OperatorException("Input product containing HH and HV bands is required");
            }
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.windowSizeX = Integer.parseInt(this.windowSizeXStr);
            this.windowSizeY = Integer.parseInt(this.windowSizeYStr);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        String[] targetBandNames = this.getTargetBandNames();
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Band[] targetBands = OperatorUtils.addBands((Product)this.targetProduct, (String[])targetBandNames, (String)bandList.suffix);
            bandList.addTargetBands(targetBands);
        }
    }

    private String[] getTargetBandNames() {
        ArrayList<String> targetBandNameList = new ArrayList<String>(13);
        if (this.outputSpan) {
            targetBandNameList.add("Span");
        }
        if (this.outputPedestalHeight) {
            targetBandNameList.add("PedestalHeight");
        }
        if (this.outputRVI) {
            targetBandNameList.add("RVI");
        }
        if (this.outputRFDI) {
            targetBandNameList.add("RFDI");
        }
        if (this.outputHHHVRatio) {
            targetBandNameList.add("HHHVRatio");
        }
        return targetBandNameList.toArray(new String[targetBandNameList.size()]);
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absRoot != null) {
            absRoot.setAttributeInt("polsar_data", 1);
        }
        PolBandUtils.saveNewBandNames((Product)this.targetProduct, (PolBandUtils.PolSourceBand[])this.srcBandList);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        TileIndex trgIndex = new TileIndex(targetTiles.get(this.targetProduct.getBandAt(0)));
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        Rectangle sourceRectangle = this.getSourceTileRectangle(x0, y0, w, h, this.windowSizeX, this.windowSizeY);
        int halfWindowSize = this.windowSizeX / 2;
        boolean computePolarimetricParam = this.outputSpan || this.outputPedestalHeight || this.outputRVI;
        Tile hhTile = null;
        Tile hvTile = null;
        if (this.hhBand != null) {
            hhTile = this.getSourceTile((RasterDataNode)this.hhBand, sourceRectangle);
        }
        if (this.hvBand != null) {
            hvTile = this.getSourceTile((RasterDataNode)this.hvBand, sourceRectangle);
        }
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            try {
                TileData[] tileDataList = new TileData[bandList.targetBands.length];
                int i = 0;
                for (Band targetBand : bandList.targetBands) {
                    Tile targetTile = targetTiles.get(targetBand);
                    tileDataList[i++] = new TileData(targetTile, targetBand.getName());
                }
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                for (int j = 0; j < bandList.srcBands.length; ++j) {
                    Band srcBand = bandList.srcBands[j];
                    sourceTiles[j] = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle);
                    dataBuffers[j] = sourceTiles[j].getDataBuffer();
                }
                TileIndex srcIndex = new TileIndex(sourceTiles[0]);
                PolOpUtils.PolarimetricParameters cp = null;
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    srcIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        int tgtIdx = trgIndex.getIndex(x);
                        if (computePolarimetricParam) {
                            if (this.useMeanMatrix) {
                                PolOpUtils.getMeanCoherencyMatrix(x, y, halfWindowSize, halfWindowSize, this.sourceImageWidth, this.sourceImageHeight, this.sourceProductType, srcIndex, dataBuffers, Tr, Ti);
                            } else {
                                PolOpUtils.getT3(srcIndex.getIndex(x), this.sourceProductType, dataBuffers, Tr, Ti);
                            }
                            cp = PolOpUtils.computePolarimetricParameters(Tr, Ti);
                        }
                        for (TileData tileData : tileDataList) {
                            if (this.outputSpan && tileData.bandName.equals("Span")) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)cp.Span);
                            }
                            if (this.outputPedestalHeight && tileData.bandName.equals("PedestalHeight")) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)cp.PedestalHeight);
                            }
                            if (this.outputRVI && tileData.bandName.equals("RVI")) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (float)cp.RVI);
                            }
                            if (hhTile == null || hvTile == null) continue;
                            float hh = hhTile.getSampleFloat(x, y);
                            float hv = hvTile.getSampleFloat(x, y);
                            if (this.outputRFDI && tileData.bandName.equals("RFDI")) {
                                tileData.dataBuffer.setElemFloatAt(tgtIdx, (hh - hv) / (hh + hv));
                            }
                            if (!this.outputHHHVRatio || !tileData.bandName.equals("HHHVRatio")) continue;
                            tileData.dataBuffer.setElemFloatAt(tgtIdx, hh / hv);
                        }
                    }
                }
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h, int windowSizeX, int windowSizeY) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        int halfWindowSizeX = windowSizeX / 2;
        int halfWindowSizeY = windowSizeY / 2;
        if (x0 >= halfWindowSizeX) {
            sx0 -= halfWindowSizeX;
            sw += halfWindowSizeX;
        }
        if (y0 >= halfWindowSizeY) {
            sy0 -= halfWindowSizeY;
            sh += halfWindowSizeY;
        }
        if (x0 + w + halfWindowSizeX <= this.sourceImageWidth) {
            sw += halfWindowSizeX;
        }
        if (y0 + h + halfWindowSizeY <= this.sourceImageHeight) {
            sh += halfWindowSizeY;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PolarimetricParametersOp.class);
        }
    }

    private static class TileData {
        final Tile tile;
        final ProductData dataBuffer;
        final String bandName;

        public TileData(Tile tile, String bandName) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            this.bandName = bandName;
        }
    }
}

