/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.jblas.DoubleMatrix;

public class MeanCovariance {
    private final double[][] tempCr;
    private final double[][] tempCi;
    private final DoubleMatrix CrMat;
    private final DoubleMatrix CiMat;
    private final PolBandUtils.MATRIX sourceProductType;
    private final Tile[] sourceTiles;
    private final ProductData[] dataBuffers;
    private final int halfWindowSizeX;
    private final int halfWindowSizeY;
    private final TileIndex srcIndex;

    public MeanCovariance(PolBandUtils.MATRIX sourceProductType, Tile[] sourceTiles, ProductData[] dataBuffers, int halfWindowSizeX, int halfWindowSizeY) {
        this.sourceProductType = sourceProductType;
        this.sourceTiles = sourceTiles;
        this.dataBuffers = dataBuffers;
        this.halfWindowSizeX = halfWindowSizeX;
        this.halfWindowSizeY = halfWindowSizeY;
        this.srcIndex = new TileIndex(sourceTiles[0]);
        this.tempCr = new double[3][3];
        this.tempCi = new double[3][3];
        this.CrMat = new DoubleMatrix(3, 3);
        this.CiMat = new DoubleMatrix(3, 3);
    }

    public void getMeanCovarianceMatrix(int x, int y, double[][] Cr, double[][] Ci) {
        int xSt = Math.max(x - this.halfWindowSizeX, this.sourceTiles[0].getMinX());
        int xEd = Math.min(x + this.halfWindowSizeX, this.sourceTiles[0].getMaxX() - 1);
        int ySt = Math.max(y - this.halfWindowSizeY, this.sourceTiles[0].getMinY());
        int yEd = Math.min(y + this.halfWindowSizeY, this.sourceTiles[0].getMaxY() - 1);
        int num = (yEd - ySt + 1) * (xEd - xSt + 1);
        if (this.sourceProductType == PolBandUtils.MATRIX.C3) {
            for (int yy = ySt; yy <= yEd; ++yy) {
                this.srcIndex.calculateStride(yy);
                for (int xx = xSt; xx <= xEd; ++xx) {
                    PolOpUtils.getCovarianceMatrixC3(this.srcIndex.getIndex(xx), this.dataBuffers, this.tempCr, this.tempCi);
                    this.CrMat.add(new DoubleMatrix(this.tempCr));
                    this.CiMat.add(new DoubleMatrix(this.tempCi));
                }
            }
        } else if (this.sourceProductType == PolBandUtils.MATRIX.T3) {
            double[][] tempTr = new double[3][3];
            double[][] tempTi = new double[3][3];
            for (int yy = ySt; yy <= yEd; ++yy) {
                this.srcIndex.calculateStride(yy);
                for (int xx = xSt; xx <= xEd; ++xx) {
                    PolOpUtils.getCoherencyMatrixT3(this.srcIndex.getIndex(xx), this.dataBuffers, tempTr, tempTi);
                    PolOpUtils.t3ToC3(tempTr, tempTi, this.tempCr, this.tempCi);
                    this.CrMat.add(new DoubleMatrix(this.tempCr));
                    this.CiMat.add(new DoubleMatrix(this.tempCi));
                }
            }
        } else if (this.sourceProductType == PolBandUtils.MATRIX.FULL) {
            DoubleMatrix matSr = new DoubleMatrix(3, 3);
            DoubleMatrix matSi = new DoubleMatrix(3, 3);
            DoubleMatrix matCr = new DoubleMatrix(3, 3);
            DoubleMatrix matCi = new DoubleMatrix(3, 3);
            this.CrMat.fill(0.0);
            this.CiMat.fill(0.0);
            for (int yy = ySt; yy <= yEd; ++yy) {
                this.srcIndex.calculateStride(yy);
                for (int xx = xSt; xx <= xEd; ++xx) {
                    PolOpUtils.getComplexScatterMatrix(this.srcIndex.getIndex(xx), this.dataBuffers, matSr, matSi);
                    PolOpUtils.computeCovarianceMatrixC3(matSr, matSi, matCr, matCi);
                    this.CrMat.addi(matCr);
                    this.CiMat.addi(matCi);
                }
            }
        }
        this.CrMat.muli(1.0 / (double)num);
        this.CiMat.muli(1.0 / (double)num);
        for (int i = 0; i < 3; ++i) {
            Cr[i][0] = this.CrMat.get(i, 0);
            Ci[i][0] = this.CiMat.get(i, 0);
            Cr[i][1] = this.CrMat.get(i, 1);
            Ci[i][1] = this.CiMat.get(i, 1);
            Cr[i][2] = this.CrMat.get(i, 2);
            Ci[i][2] = this.CiMat.get(i, 2);
        }
    }
}

