/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf;

import Jama.Matrix;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public final class DualPolOpUtils {
    public static final double EPS = 1.0E-15;

    public static void getMeanCovarianceMatrixC2(int x, int y, int halfWindowSizeX, int halfWindowSizeY, int sourceImageWidth, int sourceImageHeight, PolBandUtils.MATRIX sourceProductType, Tile[] sourceTiles, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        int xSt = Math.max(x - halfWindowSizeX, 0);
        int xEd = Math.min(x + halfWindowSizeX, sourceImageWidth - 1);
        int ySt = Math.max(y - halfWindowSizeY, 0);
        int yEd = Math.min(y + halfWindowSizeY, sourceImageHeight - 1);
        int num = (yEd - ySt + 1) * (xEd - xSt + 1);
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        Matrix CrMat = new Matrix(2, 2);
        Matrix CiMat = new Matrix(2, 2);
        if (sourceProductType == PolBandUtils.MATRIX.C2) {
            for (int yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (int xx = xSt; xx <= xEd; ++xx) {
                    Matrix tmpCrMat = new Matrix(2, 2);
                    Matrix tmpCiMat = new Matrix(2, 2);
                    DualPolOpUtils.getCovarianceMatrixC2(srcIndex.getIndex(xx), dataBuffers, tmpCrMat.getArray(), tmpCiMat.getArray());
                    CrMat.plusEquals(tmpCrMat);
                    CiMat.plusEquals(tmpCiMat);
                }
            }
        } else if (sourceProductType == PolBandUtils.MATRIX.LCHCP || sourceProductType == PolBandUtils.MATRIX.RCHCP || sourceProductType == PolBandUtils.MATRIX.DUAL_HH_HV || sourceProductType == PolBandUtils.MATRIX.DUAL_VH_VV || sourceProductType == PolBandUtils.MATRIX.DUAL_HH_VV) {
            double[] tempKr = new double[2];
            double[] tempKi = new double[2];
            for (int yy = ySt; yy <= yEd; ++yy) {
                srcIndex.calculateStride(yy);
                for (int xx = xSt; xx <= xEd; ++xx) {
                    Matrix tmpCrMat = new Matrix(2, 2);
                    Matrix tmpCiMat = new Matrix(2, 2);
                    DualPolOpUtils.getScatterVector(srcIndex.getIndex(xx), dataBuffers, tempKr, tempKi);
                    DualPolOpUtils.computeCovarianceMatrixC2(tempKr, tempKi, tmpCrMat.getArray(), tmpCiMat.getArray());
                    CrMat.plusEquals(tmpCrMat);
                    CiMat.plusEquals(tmpCiMat);
                }
            }
        } else {
            throw new OperatorException("getMeanCovarianceMatrixC2 not implemented for raw dual pol");
        }
        CrMat.timesEquals(1.0 / (double)num);
        CiMat.timesEquals(1.0 / (double)num);
        Cr[0][0] = CrMat.get(0, 0);
        Ci[0][0] = CiMat.get(0, 0);
        Cr[0][1] = CrMat.get(0, 1);
        Ci[0][1] = CiMat.get(0, 1);
        Cr[1][0] = CrMat.get(1, 0);
        Ci[1][0] = CiMat.get(1, 0);
        Cr[1][1] = CrMat.get(1, 1);
        Ci[1][1] = CiMat.get(1, 1);
    }

    public static void getCovarianceMatrixC2(int index, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        Cr[0][0] = dataBuffers[0].getElemDoubleAt(index);
        Ci[0][0] = 0.0;
        Cr[0][1] = dataBuffers[1].getElemDoubleAt(index);
        Ci[0][1] = dataBuffers[2].getElemDoubleAt(index);
        Cr[1][1] = dataBuffers[3].getElemDoubleAt(index);
        Ci[1][1] = 0.0;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
    }

    public static void getCovarianceMatrixC2(int index, PolBandUtils.MATRIX sourceProductType, ProductData[] dataBuffers, double[][] Cr, double[][] Ci) {
        if (sourceProductType == PolBandUtils.MATRIX.LCHCP || sourceProductType == PolBandUtils.MATRIX.RCHCP || sourceProductType == PolBandUtils.MATRIX.DUAL_HH_HV || sourceProductType == PolBandUtils.MATRIX.DUAL_VH_VV || sourceProductType == PolBandUtils.MATRIX.DUAL_HH_VV) {
            double[] kr = new double[2];
            double[] ki = new double[2];
            DualPolOpUtils.getScatterVector(index, dataBuffers, kr, ki);
            DualPolOpUtils.computeCovarianceMatrixC2(kr, ki, Cr, Ci);
        } else if (sourceProductType == PolBandUtils.MATRIX.C2) {
            DualPolOpUtils.getCovarianceMatrixC2(index, dataBuffers, Cr, Ci);
        }
    }

    public static void getScatterVector(int index, ProductData[] dataBuffers, double[] kr, double[] ki) {
        kr[0] = dataBuffers[0].getElemDoubleAt(index);
        ki[0] = dataBuffers[1].getElemDoubleAt(index);
        kr[1] = dataBuffers[2].getElemDoubleAt(index);
        ki[1] = dataBuffers[3].getElemDoubleAt(index);
    }

    public static void computeCovarianceMatrixC2(double[] kr, double[] ki, double[][] Cr, double[][] Ci) {
        Cr[0][0] = kr[0] * kr[0] + ki[0] * ki[0];
        Ci[0][0] = 0.0;
        Cr[0][1] = kr[0] * kr[1] + ki[0] * ki[1];
        Ci[0][1] = ki[0] * kr[1] - kr[0] * ki[1];
        Cr[1][1] = kr[1] * kr[1] + ki[1] * ki[1];
        Ci[1][1] = 0.0;
        Cr[1][0] = Cr[0][1];
        Ci[1][0] = -Ci[0][1];
    }
}

