/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.rcp.toolviews;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.esa.s1tbx.dat.graphics.Palette;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.statistics.AbstractStatisticsTopComponent;
import org.esa.snap.rcp.statistics.AxisRangeControl;
import org.esa.snap.rcp.statistics.ChartPagePanel;
import org.esa.snap.rcp.statistics.MaskSelectionToolSupport;
import org.esa.snap.rcp.statistics.PagePanel;
import org.esa.snap.rcp.statistics.PlotAreaSelectionTool;
import org.esa.snap.rcp.statistics.RefreshActionEnabler;
import org.esa.snap.rcp.statistics.XYImagePlot;
import org.esa.snap.rcp.statistics.XYPlotToolTipGenerator;
import org.esa.snap.rcp.util.ProgressHandleMonitor;
import org.esa.snap.ui.GridBagUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.ui.RectangleInsets;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.windows.TopComponent;

public class HaAlphaPlotPanel
extends ChartPagePanel {
    private static final String NO_DATA_MESSAGE = "This plot requires an H-a Alpha decomposition as input\nThe plot will be computed when you hit the 'Refresh View' button.\nFor more information about this plot\nhit the help button at the bottom right.\nTIP: To zoom within the chart, draw a rectangle\nwith the mouse or use the context menu.";
    private static final String CHART_TITLE = "H-Alpha Plane Plot";
    public static final String PROPERTY_NAME_AUTO_MIN_MAX = "autoMinMax";
    public static final String PROPERTY_NAME_MIN = "min";
    public static final String PROPERTY_NAME_MAX = "max";
    public static final String PROPERTY_NAME_USE_ROI_MASK = "useRoiMask";
    public static final String PROPERTY_NAME_ROI_MASK = "roiMask";
    public static final String PROPERTY_NAME_X_BAND = "xBand";
    public static final String PROPERTY_NAME_Y_BAND = "yBand";
    private static final int X_VAR = 0;
    private static final int Y_VAR = 1;
    private static final int NUM_DECIMALS = 2;
    private BindingContext bindingContext;
    private DataSourceConfig dataSourceConfig;
    private Property xBandProperty;
    private Property yBandProperty;
    private static AxisRangeControl[] axisRangeControls = new AxisRangeControl[2];
    private IndexColorModel toggledColorModel;
    private IndexColorModel untoggledColorModel;
    private ChartPanel densityPlotDisplay;
    private XYImagePlot plot;
    private static final Color backgroundColor = new Color(255, 255, 255, 0);
    private boolean plotColorsInverted;
    private JCheckBox toggleZoneOverlayCheckBox;
    private static final Color annotColour = Color.DARK_GRAY;
    private static final Font annotFont = new Font("Ariel", 1, 14);

    public HaAlphaPlotPanel(AbstractStatisticsTopComponent parentDialog, String helpId) {
        super((TopComponent)parentDialog, helpId, CHART_TITLE, true);
    }

    protected void initComponents() {
        this.initParameters();
        this.createUI();
        this.initActionEnablers();
        this.updateComponents();
    }

    private void initActionEnablers() {
        RefreshActionEnabler roiMaskActionEnabler = new RefreshActionEnabler(this.refreshButton, new String[]{PROPERTY_NAME_USE_ROI_MASK, PROPERTY_NAME_ROI_MASK, PROPERTY_NAME_X_BAND, PROPERTY_NAME_Y_BAND});
        this.bindingContext.addPropertyChangeListener((PropertyChangeListener)roiMaskActionEnabler);
        RefreshActionEnabler rangeControlActionEnabler = new RefreshActionEnabler(this.refreshButton, new String[]{PROPERTY_NAME_MIN, PROPERTY_NAME_AUTO_MIN_MAX, PROPERTY_NAME_MAX});
        axisRangeControls[0].getBindingContext().addPropertyChangeListener((PropertyChangeListener)rangeControlActionEnabler);
        axisRangeControls[1].getBindingContext().addPropertyChangeListener((PropertyChangeListener)rangeControlActionEnabler);
    }

    public void nodeDataChanged(ProductNodeEvent event) {
        super.nodeDataChanged(event);
        if (!this.dataSourceConfig.useRoiMask) {
            return;
        }
        Mask roiMask = this.dataSourceConfig.roiMask;
        if (roiMask == null) {
            return;
        }
        ProductNode sourceNode = event.getSourceNode();
        if (!(sourceNode instanceof Mask)) {
            return;
        }
        String maskName = sourceNode.getName();
        if (roiMask.getName().equals(maskName)) {
            this.updateComponents();
        }
    }

    protected void updateComponents() {
        super.updateComponents();
        if (this.isRasterChanged() || this.isProductChanged()) {
            Product product;
            this.plot.setImage(null);
            this.plot.setDataset(null);
            if (this.isProductChanged()) {
                this.plot.getDomainAxis().setLabel("Entropy");
                this.plot.getRangeAxis().setLabel("Alpha");
            }
            if ((product = this.getProduct()) != null) {
                this.toggleZoneOverlayCheckBox.setEnabled(false);
                Band entropyBand = product.getBand("Entropy");
                Band alphaBand = product.getBand("Alpha");
                if (entropyBand != null && alphaBand != null) {
                    try {
                        this.xBandProperty.setValue((Object)entropyBand);
                        this.yBandProperty.setValue((Object)alphaBand);
                    }
                    catch (ValidationException ignored) {
                        Debug.trace((Throwable)ignored);
                    }
                }
            }
        }
        this.refreshButton.setEnabled(this.xBandProperty.getValue() != null && this.yBandProperty.getValue() != null);
    }

    private void initParameters() {
        HaAlphaPlotPanel.axisRangeControls[0] = new AxisRangeControl("X-Axis");
        HaAlphaPlotPanel.axisRangeControls[1] = new AxisRangeControl("Y-Axis");
        this.initColorModels();
        this.plotColorsInverted = false;
        this.dataSourceConfig = new DataSourceConfig();
        this.bindingContext = new BindingContext((PropertySet)PropertyContainer.createObjectBacked((Object)this.dataSourceConfig));
        this.xBandProperty = this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_X_BAND);
        this.yBandProperty = this.bindingContext.getPropertySet().getProperty(PROPERTY_NAME_Y_BAND);
    }

    private void initColorModels() {
        for (int j = 0; j <= 1; ++j) {
            int palSize = 256;
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            byte[] a = new byte[256];
            r[0] = (byte)backgroundColor.getRed();
            g[0] = (byte)backgroundColor.getGreen();
            b[0] = (byte)backgroundColor.getBlue();
            a[0] = (byte)backgroundColor.getAlpha();
            Palette pal = new Palette("Rainbow", new Color[]{Color.black, Color.blue, Color.cyan, Color.green, Color.yellow, Color.orange, Color.red});
            for (int i = 1; i < 256; ++i) {
                float value = (float)i / 255.0f;
                if (j == 0) {
                    value = (float)(255 - i) / 255.0f;
                }
                Color c = pal.lookupColor(value);
                r[i] = (byte)c.getRed();
                g[i] = (byte)c.getGreen();
                b[i] = (byte)c.getBlue();
                a[i] = -1;
            }
            if (j == 0) {
                this.toggledColorModel = new IndexColorModel(8, 256, r, g, b, a);
                continue;
            }
            this.untoggledColorModel = new IndexColorModel(8, 256, r, g, b, a);
        }
    }

    private void createUI() {
        this.plot = new XYImagePlot();
        this.plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        NumberAxis domainAxis = (NumberAxis)this.plot.getDomainAxis();
        NumberAxis rangeAxis = (NumberAxis)this.plot.getRangeAxis();
        domainAxis.setAutoRangeIncludesZero(false);
        rangeAxis.setAutoRangeIncludesZero(false);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setLowerMargin(0.0);
        rangeAxis.setUpperMargin(0.0);
        rangeAxis.setLowerMargin(0.0);
        this.plot.setNoDataMessage(NO_DATA_MESSAGE);
        this.plot.getRenderer().setBaseToolTipGenerator((XYToolTipGenerator)new XYPlotToolTipGenerator());
        JFreeChart chart = new JFreeChart(CHART_TITLE, (Plot)this.plot);
        ChartFactory.getChartTheme().apply(chart);
        chart.removeLegend();
        this.createUI(this.createChartPanel(chart), this.createOptionsPanel(), this.bindingContext);
        this.updateUIState();
    }

    private void toggleColor() {
        BufferedImage image = this.plot.getImage();
        if (image != null) {
            image = !this.plotColorsInverted ? new BufferedImage(this.untoggledColorModel, image.getRaster(), image.isAlphaPremultiplied(), null) : new BufferedImage(this.toggledColorModel, image.getRaster(), image.isAlphaPremultiplied(), null);
            this.plot.setImage(image);
            this.densityPlotDisplay.getChart().setNotify(true);
            this.plotColorsInverted = !this.plotColorsInverted;
        }
    }

    private JPanel createOptionsPanel() {
        this.toggleZoneOverlayCheckBox = new JCheckBox("Show Zones");
        this.toggleZoneOverlayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HaAlphaPlotPanel.this.updateChartData();
            }
        });
        this.toggleZoneOverlayCheckBox.setEnabled(false);
        this.toggleZoneOverlayCheckBox.setSelected(true);
        JPanel optionsPanel = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createConstraints((String)"anchor=NORTHWEST,fill=HORIZONTAL,insets.top=0,weightx=1,gridx=0");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)axisRangeControls[0].getPanel(), (GridBagConstraints)gbc, (String)"gridy=0");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)axisRangeControls[1].getPanel(), (GridBagConstraints)gbc, (String)"gridy=2,insets.left=0,insets.right=0");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)new JPanel(), (GridBagConstraints)gbc, (String)"gridy=4");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)new JSeparator(), (GridBagConstraints)gbc, (String)"gridy=5,insets.left=4,insets.right=2");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)this.toggleZoneOverlayCheckBox, (GridBagConstraints)gbc, (String)"gridy=6,insets.left=0,insets.right=0");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)new JLabel("Zones Descriptions:"), (GridBagConstraints)gbc, (String)"gridy=8,insets.left=0,insets.right=0");
        JTextArea textArea = new JTextArea("Z1 - Dihedral Reflector\nZ2 - Dipole\nZ3 - Bragg Surface\nZ4 - Double Reflection\nZ5 - Anisotropic Particles\nZ6 - Random Surface\nZ7 - Complex Structures\nZ8 - Random Anisotropic Scatterers\nZ9 - Non-feasible");
        GridBagUtils.addToPanel((JPanel)optionsPanel, (Component)textArea, (GridBagConstraints)gbc, (String)"gridy=9,insets.left=0,insets.right=0");
        return optionsPanel;
    }

    private ChartPanel createChartPanel(JFreeChart chart) {
        this.densityPlotDisplay = new ChartPanel(chart);
        MaskSelectionToolSupport maskSelectionToolSupport = new MaskSelectionToolSupport((PagePanel)this, this.densityPlotDisplay, "scatter_plot_area", "Mask generated from selected scatter plot area", Color.RED, PlotAreaSelectionTool.AreaType.ELLIPSE){

            protected String createMaskExpression(PlotAreaSelectionTool.AreaType areaType, Shape shape) {
                Rectangle2D bounds = shape.getBounds2D();
                return this.createMaskExpression(bounds.getCenterX(), bounds.getCenterY(), 0.5 * bounds.getWidth(), 0.5 * bounds.getHeight());
            }

            protected String createMaskExpression(double x0, double y0, double dx, double dy) {
                return String.format("sqrt(sqr((%s - %s)/%s) + sqr((%s - %s)/%s)) < 1.0", BandArithmetic.createExternalName((String)HaAlphaPlotPanel.this.dataSourceConfig.xBand.getName()), x0, dx, BandArithmetic.createExternalName((String)HaAlphaPlotPanel.this.dataSourceConfig.yBand.getName()), y0, dy);
            }
        };
        this.densityPlotDisplay.getPopupMenu().addSeparator();
        this.densityPlotDisplay.getPopupMenu().add(maskSelectionToolSupport.createMaskSelectionModeMenuItem());
        this.densityPlotDisplay.getPopupMenu().add(maskSelectionToolSupport.createDeleteMaskMenuItem());
        this.densityPlotDisplay.getPopupMenu().addSeparator();
        this.densityPlotDisplay.getPopupMenu().add(this.createCopyDataToClipboardMenuItem());
        return this.densityPlotDisplay;
    }

    private RasterDataNode getRaster(int varIndex) {
        Product product = this.getProduct();
        if (product == null) {
            return null;
        }
        String rasterName = varIndex == 0 ? this.dataSourceConfig.xBand.getName() : this.dataSourceConfig.yBand.getName();
        RasterDataNode raster = product.getRasterDataNode(rasterName);
        if (raster == null && this.getRaster() != null && rasterName.equalsIgnoreCase(this.getRaster().getName())) {
            raster = this.getRaster();
        }
        Debug.assertTrue((raster != null ? 1 : 0) != 0);
        return raster;
    }

    private void updateUIState() {
        super.updateComponents();
    }

    private void checkBandsForRange() throws IllegalArgumentException {
        if (axisRangeControls[0].getMin().equals(axisRangeControls[0].getMax()) && axisRangeControls[1].getMin().equals(axisRangeControls[1].getMax())) {
            throw new IllegalArgumentException("Value range of at least one band must be larger than one");
        }
    }

    protected void updateChartData() {
        HaAlphaPlotPanel chartPanel = this;
        RasterDataNode rasterX = this.getRaster(0);
        RasterDataNode rasterY = this.getRaster(1);
        if (rasterX == null || rasterY == null) {
            return;
        }
        ProgressHandleMonitor pm = ProgressHandleMonitor.create((String)"Computing plot");
        Runnable operation = () -> {
            pm.beginTask("Computing plot...", 100);
            try {
                this.checkBandsForRange();
                this.setRange(0, rasterX, this.dataSourceConfig.useRoiMask ? this.dataSourceConfig.roiMask : null, SubProgressMonitor.create((ProgressMonitor)pm, (int)15));
                this.setRange(1, rasterY, this.dataSourceConfig.useRoiMask ? this.dataSourceConfig.roiMask : null, SubProgressMonitor.create((ProgressMonitor)pm, (int)15));
                BufferedImage densityPlotImage = ProductUtils.createDensityPlotImage((RasterDataNode)rasterX, (float)axisRangeControls[0].getMin().floatValue(), (float)axisRangeControls[0].getMax().floatValue(), (RasterDataNode)rasterY, (float)axisRangeControls[1].getMin().floatValue(), (float)axisRangeControls[1].getMax().floatValue(), (Mask)(this.dataSourceConfig.useRoiMask ? this.dataSourceConfig.roiMask : null), (int)512, (int)512, (Color)backgroundColor, null, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)pm, (int)70));
                densityPlotImage = new BufferedImage(this.untoggledColorModel, densityPlotImage.getRaster(), densityPlotImage.isAlphaPremultiplied(), null);
                this.plotColorsInverted = false;
                this.checkBandsForRange();
                double minX = axisRangeControls[0].getMin();
                double maxX = axisRangeControls[0].getMax();
                double minY = axisRangeControls[1].getMin();
                double maxY = axisRangeControls[1].getMax();
                if (minX > maxX || minY > maxY) {
                    JOptionPane.showMessageDialog((Component)((Object)chartPanel), "Failed to compute plot.\nNo Pixels considered..", CHART_TITLE, 0);
                    this.plot.setDataset(null);
                    return;
                }
                if (MathUtils.equalValues((double)minX, (double)maxX, (double)1.0E-4)) {
                    minX = Math.floor(minX);
                    maxX = Math.ceil(maxX);
                }
                if (MathUtils.equalValues((double)minY, (double)maxY, (double)1.0E-4)) {
                    minY = Math.floor(minY);
                    maxY = Math.ceil(maxY);
                }
                this.plot.setImage(densityPlotImage);
                this.plot.setImageDataBounds((Rectangle2D)new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY));
                axisRangeControls[0].adjustComponents(minX, maxX, 2);
                axisRangeControls[1].adjustComponents(minY, maxY, 2);
                this.plot.getDomainAxis().setLabel("Entropy");
                this.plot.getRangeAxis().setLabel("Alpha");
                this.toggleZoneOverlayCheckBox.setEnabled(true);
                List annotList = this.plot.getAnnotations();
                for (XYAnnotation an : annotList) {
                    this.plot.removeAnnotation(an);
                }
                if (this.toggleZoneOverlayCheckBox.isSelected()) {
                    this.drawZoneOverlay();
                }
            }
            catch (Exception e) {
                SnapApp.getDefault().handleError("Failed to compute plot", (Throwable)e);
            }
            finally {
                pm.done();
            }
        };
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)"Computing plot", (ProgressHandle)pm.getProgressHandle(), (boolean)true, (int)50, (int)1000);
    }

    private void drawZoneOverlay() {
        double minX = axisRangeControls[0].getMin();
        double maxX = axisRangeControls[0].getMax();
        double minY = axisRangeControls[1].getMin();
        double maxY = axisRangeControls[1].getMax();
        double H1 = 0.9;
        double H2 = 0.5;
        double Alpha1 = 55.0;
        double Alpha2 = 50.0;
        double Alpha3 = 48.0;
        double Alpha4 = 42.0;
        double Alpha5 = 40.0;
        BasicStroke stroke = new BasicStroke(2.0f);
        XYLineAnnotation line = new XYLineAnnotation(H1, minY, H1, maxY, (Stroke)stroke, (Paint)annotColour);
        this.plot.addAnnotation((XYAnnotation)line);
        line = new XYLineAnnotation(H2, minY, H2, maxY, (Stroke)stroke, (Paint)annotColour);
        this.plot.addAnnotation((XYAnnotation)line);
        line = new XYLineAnnotation(H1, Alpha1, maxX, Alpha1, (Stroke)stroke, (Paint)annotColour);
        this.plot.addAnnotation((XYAnnotation)line);
        line = new XYLineAnnotation(H2, Alpha2, H1, Alpha2, (Stroke)stroke, (Paint)annotColour);
        this.plot.addAnnotation((XYAnnotation)line);
        line = new XYLineAnnotation(minX, Alpha3, H2, Alpha3, (Stroke)stroke, (Paint)annotColour);
        this.plot.addAnnotation((XYAnnotation)line);
        line = new XYLineAnnotation(minX, Alpha4, H2, Alpha4, (Stroke)stroke, (Paint)annotColour);
        this.plot.addAnnotation((XYAnnotation)line);
        line = new XYLineAnnotation(H2, Alpha5, maxX, Alpha5, (Stroke)stroke, (Paint)annotColour);
        this.plot.addAnnotation((XYAnnotation)line);
        this.addText("Z1", minX + (H2 - minX) / 2.0, Alpha3 + (maxY - Alpha3) / 2.0);
        this.addText("Z2", minX + (H2 - minX) / 2.0, Alpha4 + (Alpha3 - Alpha4) / 2.0);
        this.addText("Z3", minX + (H2 - minX) / 2.0, minY + (Alpha4 - minY) / 2.0);
        this.addText("Z4", H2 + (H1 - H2) / 2.0, Alpha2 + (maxY - Alpha2) / 2.0);
        this.addText("Z5", H2 + (H1 - H2) / 2.0, Alpha5 + (Alpha2 - Alpha5) / 2.0);
        this.addText("Z6", H2 + (H1 - H2) / 2.0, minY + (Alpha5 - minY) / 2.0);
        this.addText("Z7", H1 + (maxX - H1) / 2.0, Alpha1 + (maxY - Alpha1) / 2.0);
        this.addText("Z8", H1 + (maxX - H1) / 2.0, Alpha5 + (Alpha1 - Alpha5) / 2.0);
        this.addText("Z9", H1 + (maxX - H1) / 2.0, minY + (Alpha5 - minY) / 2.0);
    }

    private void addText(String text, double x, double y) {
        XYTextAnnotation annotation = new XYTextAnnotation(text, x, y);
        annotation.setPaint((Paint)annotColour);
        annotation.setBackgroundPaint((Paint)Color.WHITE);
        annotation.setFont(annotFont);
        this.plot.addAnnotation((XYAnnotation)annotation);
    }

    private void setRange(int varIndex, RasterDataNode raster, Mask mask, ProgressMonitor pm) throws IOException {
        AxisRangeControl axisRangeControl = axisRangeControls[varIndex];
        if (varIndex == 0) {
            axisRangeControl.adjustComponents(0.0, 1.0, 2);
            return;
        }
        if (axisRangeControl.isAutoMinMax()) {
            Stx stx = mask == null ? raster.getStx(false, pm) : new StxFactory().withRoiMask(mask).create(raster, pm);
            axisRangeControl.adjustComponents(Math.min(0.0, stx.getMinimum()), Math.max(90.0, stx.getMaximum()), 2);
        }
    }

    protected boolean checkDataToClipboardCopy() {
        int warnLimit = 2000;
        int excelLimit = 65536;
        int numNonEmptyBins = this.getNumNonEmptyBins();
        if (numNonEmptyBins > 2000) {
            String message;
            int status;
            String excelNote = "";
            if (numNonEmptyBins > 65436) {
                excelNote = "Note that e.g., Microsoft\u00c2\u00ae Excel 2002 only supports a total of 65536 rows in a sheet.\n";
            }
            if ((status = JOptionPane.showConfirmDialog((Component)((Object)this), message = MessageFormat.format("This scatter plot contains {0} non-empty bins.\nFor each bin, a text data row containing an x, y and z value will be created.\n{1}\nPress ''Yes'' if you really want to copy this amount of data to the system clipboard.\n", numNonEmptyBins, excelNote), "Copy Data to Clipboard", 0, 2)) != 0) {
                return false;
            }
        }
        return true;
    }

    private byte[] getValidData(BufferedImage image) {
        if (image != null && image.getColorModel() instanceof IndexColorModel && image.getData().getDataBuffer() instanceof DataBufferByte) {
            return ((DataBufferByte)image.getData().getDataBuffer()).getData();
        }
        return null;
    }

    protected int getNumNonEmptyBins() {
        byte[] data = this.getValidData(this.plot.getImage());
        int n = 0;
        if (data != null) {
            for (byte aData : data) {
                int b = aData & 0xFF;
                if (b == 0) continue;
                ++n;
            }
        }
        return n;
    }

    protected String getDataAsText() {
        BufferedImage image = this.plot.getImage();
        Rectangle2D bounds = this.plot.getImageDataBounds();
        byte[] data = this.getValidData(image);
        if (data == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(64000);
        int w = image.getWidth();
        int h = image.getHeight();
        RasterDataNode rasterX = this.getRaster(0);
        String nameX = rasterX.getName();
        double sampleMinX = bounds.getMinX();
        double sampleMaxX = bounds.getMaxX();
        RasterDataNode rasterY = this.getRaster(1);
        String nameY = rasterY.getName();
        double sampleMinY = bounds.getMinY();
        double sampleMaxY = bounds.getMaxY();
        sb.append("Product name:\t").append(rasterX.getProduct().getName()).append("\n");
        sb.append("Dataset X name:\t").append(nameX).append("\n");
        sb.append("Dataset Y name:\t").append(nameY).append("\n");
        sb.append('\n');
        sb.append(nameX).append(" minimum:\t").append(sampleMinX).append("\t").append(rasterX.getUnit()).append("\n");
        sb.append(nameX).append(" maximum:\t").append(sampleMaxX).append("\t").append(rasterX.getUnit()).append("\n");
        sb.append(nameX).append(" bin size:\t").append((sampleMaxX - sampleMinX) / (double)w).append("\t").append(rasterX.getUnit()).append("\n");
        sb.append(nameX).append(" #bins:\t").append(w).append("\n");
        sb.append('\n');
        sb.append(nameY).append(" minimum:\t").append(sampleMinY).append("\t").append(rasterY.getUnit()).append("\n");
        sb.append(nameY).append(" maximum:\t").append(sampleMaxY).append("\t").append(rasterY.getUnit()).append("\n");
        sb.append(nameY).append(" bin size:\t").append((sampleMaxY - sampleMinY) / (double)h).append("\t").append(rasterY.getUnit()).append("\n");
        sb.append(nameY).append(" #bins:\t").append(h).append("\n");
        sb.append('\n');
        sb.append(nameX);
        sb.append('\t');
        sb.append(nameY);
        sb.append('\t');
        sb.append("Bin counts\t(cropped at 255)");
        sb.append('\n');
        for (int i = 0; i < data.length; ++i) {
            int z = data[i] & 0xFF;
            if (z == 0) continue;
            int x = i % w;
            int y = h - i / w - 1;
            double v1 = sampleMinX + ((double)x + 0.5) * (sampleMaxX - sampleMinX) / (double)w;
            double v2 = sampleMinY + ((double)y + 0.5) * (sampleMaxY - sampleMinY) / (double)h;
            sb.append(v1);
            sb.append('\t');
            sb.append(v2);
            sb.append('\t');
            sb.append(z);
            sb.append('\n');
        }
        return sb.toString();
    }

    private static class DataSourceConfig {
        public boolean useRoiMask;
        public Mask roiMask;
        private RasterDataNode xBand;
        private RasterDataNode yBand;
        private Property xBandProperty;
        private Property yBandProperty;

        private DataSourceConfig() {
        }
    }
}

