/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.rcp.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import org.esa.snap.graphbuilder.rcp.utils.FileFolderUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;

public class LaunchPolsarProAction
extends AbstractAction {
    private static final String PolsarProPathStr = "external.polsarpro.path";
    private static final String TCLPathStr = "external.TCL.path";

    @Override
    public void actionPerformed(ActionEvent event) {
        File polsarProFile;
        Preferences pref = SnapApp.getDefault().getPreferences();
        File tclFile = new File(pref.get(TCLPathStr, ""));
        if (!tclFile.exists() && (tclFile = LaunchPolsarProAction.findTCLWish()).exists()) {
            pref.put(TCLPathStr, tclFile.getAbsolutePath());
        }
        if (!(polsarProFile = new File(pref.get(PolsarProPathStr, ""))).exists()) {
            polsarProFile = LaunchPolsarProAction.findPolsarPro();
        }
        if (!polsarProFile.exists()) {
            polsarProFile = FileFolderUtils.GetFilePath((String)"PolSARPro Location", (String)"tcl", (String)"tcl", null, (String)"PolSARPro File", (boolean)false);
        }
        if (polsarProFile.exists()) {
            LaunchPolsarProAction.externalExecute(polsarProFile, tclFile);
            pref.put(PolsarProPathStr, polsarProFile.getAbsolutePath());
        }
    }

    private static void externalExecute(final File prog, final File tclWishFile) {
        Thread worker = new Thread(){

            @Override
            public void run() {
                try {
                    if (tclWishFile.exists()) {
                        if (prog.exists()) {
                            String command = tclWishFile.getAbsolutePath() + " " + "\"" + prog.getAbsolutePath() + "\"";
                            System.out.println("Launching PolSARPro: " + command);
                            Process proc = Runtime.getRuntime().exec(command, null, new File(prog.getParent()));
                            LaunchPolsarProAction.outputTextBuffers(new BufferedReader(new InputStreamReader(proc.getInputStream())));
                            LaunchPolsarProAction.outputTextBuffers(new BufferedReader(new InputStreamReader(proc.getErrorStream())));
                        } else {
                            Dialogs.showError((String)("The file: " + prog.getAbsolutePath() + " does not exist."));
                        }
                    } else {
                        Dialogs.showError((String)"Cannot find TCL wish.exe to launch PolSARPro");
                    }
                }
                catch (Exception e) {
                    Dialogs.showError((String)("Unable to launch PolSARPro:" + e.getMessage()));
                }
            }
        };
        worker.start();
    }

    private static File findTCLWish() {
        File[] files;
        File progFiles = new File("C:\\Program Files (x86)\\TCL\\bin");
        if (!progFiles.exists()) {
            progFiles = new File("C:\\Program Files\\TCL\\bin");
        }
        if (!progFiles.exists()) {
            progFiles = new File("C:\\TCL\\bin");
        }
        if (progFiles.exists() && (files = progFiles.listFiles()) != null) {
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (!name.equals("wish.exe")) continue;
                return file;
            }
        }
        return new File("");
    }

    private static File findPolsarPro() {
        File[] progs;
        File progFiles = new File("C:\\Program Files (x86)");
        if (!progFiles.exists()) {
            progFiles = new File("C:\\Program Files");
        }
        if (progFiles.exists() && (progs = progFiles.listFiles(new PolsarFileFilter())) != null) {
            for (File prog : progs) {
                File[] fileList = prog.listFiles(new PolsarFileFilter());
                if (fileList == null) continue;
                for (File file : fileList) {
                    if (!file.getName().toLowerCase().endsWith("tcl")) continue;
                    return file;
                }
            }
        }
        return new File("");
    }

    private static boolean outputTextBuffers(BufferedReader in) throws IOException {
        char c;
        boolean hasData = false;
        while ((c = (char)in.read()) != '\uffffffff' && c != '\uffff') {
            System.out.print(c);
            hasData = true;
        }
        return hasData;
    }

    private static class PolsarFileFilter
    implements FilenameFilter {
        private PolsarFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().startsWith("polsar");
        }
    }
}

