/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.polarimetric.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class PolarimetricParametersOpUI
extends BaseOperatorUI {
    private final JComboBox windowSizeXStr = new JComboBox<String>(new String[]{"3", "5", "7", "9", "11", "13", "15", "17", "19"});
    private final JComboBox windowSizeYStr = new JComboBox<String>(new String[]{"3", "5", "7", "9", "11", "13", "15", "17", "19"});
    final JCheckBox useMeanMatrixCheckBox = new JCheckBox("Use Mean Matrix");
    final JCheckBox outputSpanCheckBox = new JCheckBox("Span");
    final JCheckBox outputPedestalHeightCheckBox = new JCheckBox("Pedestal Height");
    final JCheckBox outputRVICheckBox = new JCheckBox("Radar Vegetation Index");
    final JCheckBox outputRFDICheckBox = new JCheckBox("Radar Forest Degradation Index");
    final JCheckBox outputHHHVRatioCheckBox = new JCheckBox("HH/HV Ratio");
    private Boolean useMeanMatrix = false;
    private Boolean outputSpan = false;
    private Boolean outputPedestalHeight = false;
    private Boolean outputRVI = false;
    private Boolean outputRFDI = false;
    private Boolean outputHHHVRatio = false;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JScrollPane panel = new JScrollPane(this.createPanel());
        this.initParameters();
        this.useMeanMatrixCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PolarimetricParametersOpUI.this.useMeanMatrix = e.getStateChange() == 1;
                if (PolarimetricParametersOpUI.this.useMeanMatrix.booleanValue()) {
                    PolarimetricParametersOpUI.this.windowSizeXStr.setEnabled(true);
                    PolarimetricParametersOpUI.this.windowSizeYStr.setEnabled(true);
                } else {
                    PolarimetricParametersOpUI.this.windowSizeXStr.setEnabled(false);
                    PolarimetricParametersOpUI.this.windowSizeYStr.setEnabled(false);
                }
            }
        });
        this.outputSpanCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PolarimetricParametersOpUI.this.outputSpan = e.getStateChange() == 1;
            }
        });
        this.outputPedestalHeightCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PolarimetricParametersOpUI.this.outputPedestalHeight = e.getStateChange() == 1;
            }
        });
        this.outputRVICheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PolarimetricParametersOpUI.this.outputRVI = e.getStateChange() == 1;
            }
        });
        this.outputRFDICheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PolarimetricParametersOpUI.this.outputRFDI = e.getStateChange() == 1;
            }
        });
        this.outputHHHVRatioCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PolarimetricParametersOpUI.this.outputHHHVRatio = e.getStateChange() == 1;
            }
        });
        return panel;
    }

    public void initParameters() {
        this.windowSizeXStr.setSelectedItem(this.paramMap.get("windowSizeXStr"));
        this.windowSizeYStr.setSelectedItem(this.paramMap.get("windowSizeYStr"));
        Boolean paramVal = (Boolean)this.paramMap.get("useMeanMatrix");
        if (paramVal != null) {
            this.useMeanMatrix = paramVal;
            this.useMeanMatrixCheckBox.setSelected(this.useMeanMatrix);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputSpan")) != null) {
            this.outputSpan = paramVal;
            this.outputSpanCheckBox.setSelected(this.outputSpan);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputPedestalHeight")) != null) {
            this.outputPedestalHeight = paramVal;
            this.outputPedestalHeightCheckBox.setSelected(this.outputPedestalHeight);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputRVI")) != null) {
            this.outputRVI = paramVal;
            this.outputRVICheckBox.setSelected(this.outputRVI);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputRFDI")) != null) {
            this.outputRFDI = paramVal;
            this.outputRFDICheckBox.setSelected(this.outputRFDI);
        }
        if ((paramVal = (Boolean)this.paramMap.get("outputHHHVRatio")) != null) {
            this.outputHHHVRatio = paramVal;
            this.outputHHHVRatioCheckBox.setSelected(this.outputHHHVRatio);
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        if (this.useMeanMatrix.booleanValue()) {
            this.paramMap.put("windowSizeXStr", this.windowSizeXStr.getSelectedItem());
            this.paramMap.put("windowSizeYStr", this.windowSizeYStr.getSelectedItem());
        }
        this.paramMap.put("useMeanMatrix", this.useMeanMatrix);
        this.paramMap.put("outputSpan", this.outputSpan);
        this.paramMap.put("outputPedestalHeight", this.outputPedestalHeight);
        this.paramMap.put("outputRVI", this.outputRVI);
        this.paramMap.put("outputRFDI", this.outputRFDI);
        this.paramMap.put("outputHHHVRatio", this.outputHHHVRatio);
    }

    JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)this.useMeanMatrixCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Window Size X:", (JComponent)this.windowSizeXStr);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Window Size Y:", (JComponent)this.windowSizeYStr);
        ++gbc.gridy;
        contentPane.add((Component)this.outputSpanCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.outputPedestalHeightCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.outputRVICheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.outputRFDICheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.outputHHHVRatioCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

