/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.gpf.classifiers;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.classification.gpf.PolarimetricClassificationOp;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;

public abstract class PolClassifierBase {
    public static final int NODATACLASS = 0;
    protected final PolBandUtils.MATRIX sourceProductType;
    protected final int srcWidth;
    protected final int srcHeight;
    protected final int windowSizeX;
    protected final int windowSizeY;
    protected final int halfWindowSizeX;
    protected final int halfWindowSizeY;
    protected final Map<Band, PolBandUtils.PolSourceBand> bandMap;
    protected final PolarimetricClassificationOp op;

    protected PolClassifierBase(PolBandUtils.MATRIX srcProductType, int srcWidth, int srcHeight, int windowSizeX, int windowSizeY, Map<Band, PolBandUtils.PolSourceBand> bandMap, PolarimetricClassificationOp op) {
        this.sourceProductType = srcProductType;
        this.srcWidth = srcWidth;
        this.srcHeight = srcHeight;
        this.windowSizeX = windowSizeX;
        this.windowSizeY = windowSizeY;
        this.halfWindowSizeX = windowSizeX / 2;
        this.halfWindowSizeY = windowSizeY / 2;
        this.bandMap = bandMap;
        this.op = op;
    }

    public boolean canProcessStacks() {
        return true;
    }

    public abstract int getNumClasses();

    protected Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int x0 = Math.max(0, tx0 - this.halfWindowSizeX);
        int y0 = Math.max(0, ty0 - this.halfWindowSizeY);
        int xMax = Math.min(tx0 + tw - 1 + this.halfWindowSizeX, this.srcWidth);
        int yMax = Math.min(ty0 + th - 1 + this.halfWindowSizeY, this.srcHeight);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    public static Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th, int windowSizeX, int windowSizeY, int srcWidth, int srcHeight) {
        int halfWindowSizeX = windowSizeX / 2;
        int halfWindowSizeY = windowSizeY / 2;
        int x0 = Math.max(0, tx0 - halfWindowSizeX);
        int y0 = Math.max(0, ty0 - halfWindowSizeY);
        int xMax = Math.min(tx0 + tw - 1 + halfWindowSizeX, srcWidth - 1);
        int yMax = Math.min(ty0 + th - 1 + halfWindowSizeY, srcHeight - 1);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    protected static void computeSummationOfC2(int zoneIdx, double[][] Cr, double[][] Ci, double[][][] sumRe, double[][][] sumIm) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                double[] dArray = sumRe[zoneIdx - 1][i];
                int n = j;
                dArray[n] = dArray[n] + Cr[i][j];
                double[] dArray2 = sumIm[zoneIdx - 1][i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + Ci[i][j];
            }
        }
    }

    protected static void computeSummationOfT3(int zoneIdx, double[][] Tr, double[][] Ti, double[][][] sumRe, double[][][] sumIm) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double[] dArray = sumRe[zoneIdx - 1][i];
                int n = j;
                dArray[n] = dArray[n] + Tr[i][j];
                double[] dArray2 = sumIm[zoneIdx - 1][i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + Ti[i][j];
            }
        }
    }

    private static double determinantCmplxMatrix2(double[][] Cr, double[][] Ci) {
        double detR = Cr[0][0] * Cr[1][1] - Cr[0][1] * Cr[0][1] - Ci[0][1] * Ci[0][1];
        if (detR < 1.0E-15) {
            detR = 1.0E-15;
        }
        return detR;
    }

    private static double determinantCmplxMatrix3(double[][] Tr, double[][] Ti) {
        double cof00R = Tr[1][1] * Tr[2][2] - Ti[1][1] * Ti[2][2] - Tr[1][2] * Tr[2][1] + Ti[1][2] * Ti[2][1];
        double cof00I = Tr[1][1] * Ti[2][2] + Ti[1][1] * Tr[2][2] - Tr[1][2] * Ti[2][1] - Ti[1][2] * Tr[2][1];
        double cof01R = Tr[1][0] * Tr[2][2] - Ti[1][0] * Ti[2][2] - Tr[1][2] * Tr[2][0] + Ti[1][2] * Ti[2][0];
        double cof01I = Tr[1][0] * Ti[2][2] + Ti[1][0] * Tr[2][2] - Tr[1][2] * Ti[2][0] - Ti[1][2] * Tr[2][0];
        double cof02R = Tr[1][0] * Tr[2][1] - Ti[1][0] * Ti[2][1] - Tr[1][1] * Tr[2][0] + Ti[1][1] * Ti[2][0];
        double cof02I = Tr[1][0] * Ti[2][1] + Ti[1][0] * Tr[2][1] - Tr[1][1] * Ti[2][0] - Ti[1][1] * Tr[2][0];
        double detR = Tr[0][0] * cof00R - Ti[0][0] * cof00I - Tr[0][1] * cof01R + Ti[0][1] * cof01I + Tr[0][2] * cof02R + Ti[0][2] * cof02I;
        double detI = Tr[0][0] * cof00I + Ti[0][0] * cof00R - Tr[0][1] * cof01I - Ti[0][1] * cof01R + Tr[0][2] * cof02I + Ti[0][2] * cof02R;
        double det = Math.sqrt(detR * detR + detI * detI);
        if (det < 1.0E-15) {
            det = 1.0E-15;
        }
        return det;
    }

    private static void inverseCmplxMatrix2(double[][] Cr, double[][] Ci, double[][] iCr, double[][] iCi) {
        iCr[0][0] = Cr[1][1];
        iCi[0][0] = 0.0;
        iCr[0][1] = -Cr[0][1];
        iCi[0][1] = -Ci[0][1];
        iCr[1][0] = -Cr[0][1];
        iCi[1][0] = Ci[0][1];
        iCr[1][1] = Cr[0][0];
        iCi[1][1] = 0.0;
        double det = PolClassifierBase.determinantCmplxMatrix2(Cr, Ci);
        for (int i = 0; i < 2; ++i) {
            int j = 0;
            while (j < 2) {
                double[] dArray = iCr[i];
                int n = j;
                dArray[n] = dArray[n] / det;
                double[] dArray2 = iCi[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] / det;
            }
        }
    }

    private static void inverseCmplxMatrix3(double[][] Tr, double[][] Ti, double[][] iTr, double[][] iTi) {
        iTr[0][0] = Tr[1][1] * Tr[2][2] - Ti[1][1] * Ti[2][2] - Tr[1][2] * Tr[2][1] + Ti[1][2] * Ti[2][1];
        iTi[0][0] = Tr[1][1] * Ti[2][2] + Ti[1][1] * Tr[2][2] - Tr[1][2] * Ti[2][1] - Ti[1][2] * Tr[2][1];
        iTr[0][1] = Tr[2][1] * Tr[0][2] - Ti[2][1] * Ti[0][2] - Tr[2][2] * Tr[0][1] + Ti[2][2] * Ti[0][1];
        iTi[0][1] = Tr[2][1] * Ti[0][2] + Ti[2][1] * Tr[0][2] - Tr[2][2] * Ti[0][1] - Ti[2][2] * Tr[0][1];
        iTr[0][2] = Tr[0][1] * Tr[1][2] - Ti[0][1] * Ti[1][2] - Tr[1][1] * Tr[0][2] + Ti[1][1] * Ti[0][2];
        iTi[0][2] = Tr[0][1] * Ti[1][2] + Ti[0][1] * Tr[1][2] - Tr[1][1] * Ti[0][2] - Ti[1][1] * Tr[0][2];
        iTr[1][0] = Tr[2][0] * Tr[1][2] - Ti[2][0] * Ti[1][2] - Tr[1][0] * Tr[2][2] + Ti[1][0] * Ti[2][2];
        iTi[1][0] = Tr[2][0] * Ti[1][2] + Ti[2][0] * Tr[1][2] - Tr[1][0] * Ti[2][2] - Ti[1][0] * Tr[2][2];
        iTr[1][1] = Tr[0][0] * Tr[2][2] - Ti[0][0] * Ti[2][2] - Tr[2][0] * Tr[0][2] + Ti[2][0] * Ti[0][2];
        iTi[1][1] = Tr[0][0] * Ti[2][2] + Ti[0][0] * Tr[2][2] - Tr[2][0] * Ti[0][2] - Ti[2][0] * Tr[0][2];
        iTr[1][2] = Tr[1][0] * Tr[0][2] - Ti[1][0] * Ti[0][2] - Tr[0][0] * Tr[1][2] + Ti[0][0] * Ti[1][2];
        iTi[1][2] = Tr[1][0] * Ti[0][2] + Ti[1][0] * Tr[0][2] - Tr[0][0] * Ti[1][2] - Ti[0][0] * Tr[1][2];
        iTr[2][0] = Tr[1][0] * Tr[2][1] - Ti[1][0] * Ti[2][1] - Tr[2][0] * Tr[1][1] + Ti[2][0] * Ti[1][1];
        iTi[2][0] = Tr[1][0] * Ti[2][1] + Ti[1][0] * Tr[2][1] - Tr[2][0] * Ti[1][1] - Ti[2][0] * Tr[1][1];
        iTr[2][1] = Tr[2][0] * Tr[0][1] - Ti[2][0] * Ti[0][1] - Tr[0][0] * Tr[2][1] + Ti[0][0] * Ti[2][1];
        iTi[2][1] = Tr[2][0] * Ti[0][1] + Ti[2][0] * Tr[0][1] - Tr[0][0] * Ti[2][1] - Ti[0][0] * Tr[2][1];
        iTr[2][2] = Tr[0][0] * Tr[1][1] - Ti[0][0] * Ti[1][1] - Tr[1][0] * Tr[0][1] + Ti[1][0] * Ti[0][1];
        iTi[2][2] = Tr[0][0] * Ti[1][1] + Ti[0][0] * Tr[1][1] - Tr[1][0] * Ti[0][1] - Ti[1][0] * Tr[0][1];
        double detR = Tr[0][0] * iTr[0][0] - Ti[0][0] * iTi[0][0] + Tr[1][0] * iTr[0][1] - Ti[1][0] * iTi[0][1] + Tr[2][0] * iTr[0][2] - Ti[2][0] * iTi[0][2];
        double detI = Tr[0][0] * iTi[0][0] + Ti[0][0] * iTr[0][0] + Tr[1][0] * iTi[0][1] + Ti[1][0] * iTr[0][1] + Tr[2][0] * iTi[0][2] + Ti[2][0] * iTr[0][2];
        double det = Math.sqrt(detR * detR + detI * detI);
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = iTr[i];
                int n = j;
                dArray[n] = dArray[n] / det;
                double[] dArray2 = iTi[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] / det;
            }
        }
    }

    public IndexCoding createIndexCoding() {
        IndexCoding indexCoding = new IndexCoding("Cluster_classes");
        indexCoding.addIndex("no data", 0, "no data");
        for (int i = 1; i <= this.getNumClasses(); ++i) {
            indexCoding.addIndex("class_" + i, i, "Cluster " + i);
        }
        return indexCoding;
    }

    public static class ClusterInfo {
        int zoneIndex;
        int size;
        double logDet;
        double[][] centerRe = null;
        double[][] centerIm = null;
        double[][] invCenterRe = null;
        double[][] invCenterIm = null;

        public void setClusterCenter(int zoneIdx, double[][] Mr, double[][] Mi, int size) {
            int dimension = Mr.length;
            this.centerRe = new double[dimension][dimension];
            this.centerIm = new double[dimension][dimension];
            this.invCenterRe = new double[dimension][dimension];
            this.invCenterIm = new double[dimension][dimension];
            this.zoneIndex = zoneIdx;
            this.size = size;
            for (int i = 0; i < dimension; ++i) {
                for (int j = 0; j < dimension; ++j) {
                    this.centerRe[i][j] = Mr[i][j];
                    this.centerIm[i][j] = Mi[i][j];
                }
            }
            if (dimension == 3) {
                this.logDet = Math.log(PolClassifierBase.determinantCmplxMatrix3(Mr, Mi));
                PolClassifierBase.inverseCmplxMatrix3(Mr, Mi, this.invCenterRe, this.invCenterIm);
            } else if (dimension == 2) {
                this.logDet = Math.log(PolClassifierBase.determinantCmplxMatrix2(Mr, Mi));
                PolClassifierBase.inverseCmplxMatrix2(Mr, Mi, this.invCenterRe, this.invCenterIm);
            }
        }
    }
}

