/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.gpf.classifiers;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Map;
import org.csa.rstb.classification.gpf.PolarimetricClassificationOp;
import org.csa.rstb.classification.gpf.classifiers.PolClassifier;
import org.csa.rstb.classification.gpf.classifiers.PolClassifierBase;
import org.csa.rstb.polarimetric.gpf.HaAlphaDescriptor;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.csa.rstb.polarimetric.gpf.decompositions.hAAlpha;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class HAlphaWishart
extends PolClassifierBase
implements PolClassifier {
    private static final String UNSUPERVISED_WISHART_CLASS = "H_alpha_wishart_class";
    private PolClassifierBase.ClusterInfo[][] clusterCenters = null;
    private boolean[] clusterCentersComputed = null;
    private final int maxIterations;
    private final boolean useLeeHAlphaPlaneDefinition;

    public HAlphaWishart(PolBandUtils.MATRIX srcProductType, int srcWidth, int srcHeight, int winSize, Map<Band, PolBandUtils.PolSourceBand> bandMap, int maxIterations, PolarimetricClassificationOp op) {
        super(srcProductType, srcWidth, srcHeight, winSize, winSize, bandMap, op);
        this.maxIterations = maxIterations;
        this.useLeeHAlphaPlaneDefinition = Boolean.getBoolean(SystemUtils.getApplicationContextId() + ".useLeeHAlphaPlaneDefinition");
    }

    @Override
    public String getTargetBandName() {
        return UNSUPERVISED_WISHART_CLASS;
    }

    @Override
    public int getNumClasses() {
        return 9;
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile) {
        PolBandUtils.PolSourceBand srcBandList = (PolBandUtils.PolSourceBand)this.bandMap.get(targetBand);
        int numTargetBands = targetBand.getProduct().getNumBands();
        int targetBandIndex = targetBand.getProduct().getBandIndex(targetBand.getName());
        if (this.clusterCentersComputed == null || !this.clusterCentersComputed[targetBandIndex]) {
            this.computeClusterCenters(numTargetBands, targetBandIndex, srcBandList, this.op);
        }
        Rectangle targetRectangle = targetTile.getRectangle();
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Tile[] sourceTiles = new Tile[srcBandList.srcBands.length];
        ProductData[] dataBuffers = new ProductData[srcBandList.srcBands.length];
        Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
        for (int i = 0; i < sourceTiles.length; ++i) {
            sourceTiles[i] = this.op.getSourceTile((RasterDataNode)srcBandList.srcBands[i], sourceRectangle);
            dataBuffers[i] = sourceTiles[i].getDataBuffer();
        }
        ProductData targetData = targetTile.getDataBuffer();
        TileIndex trgIndex = new TileIndex(targetTile);
        TileIndex srcIndex = new TileIndex(sourceTiles[0]);
        double noDataValue = srcBandList.srcBands[0].getNoDataValue();
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            srcIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int index = trgIndex.getIndex(x);
                if (dataBuffers[0].getElemDoubleAt(srcIndex.getIndex(x)) == noDataValue) {
                    targetData.setElemIntAt(index, 0);
                    continue;
                }
                PolOpUtils.getMeanCoherencyMatrix((int)x, (int)y, (int)this.halfWindowSizeX, (int)this.halfWindowSizeY, (int)this.srcWidth, (int)this.srcHeight, (PolBandUtils.MATRIX)this.sourceProductType, (TileIndex)srcIndex, (ProductData[])dataBuffers, (double[][])Tr, (double[][])Ti);
                targetData.setElemIntAt(index, HAlphaWishart.findZoneIndex(Tr, Ti, this.clusterCenters[targetBandIndex]));
            }
        }
    }

    private synchronized void computeClusterCenters(int numTargetBands, int targetBandIndex, PolBandUtils.PolSourceBand srcBandList, PolarimetricClassificationOp op) {
        if (this.clusterCentersComputed != null && this.clusterCentersComputed[targetBandIndex]) {
            return;
        }
        if (this.clusterCentersComputed == null) {
            this.clusterCentersComputed = new boolean[numTargetBands];
            Arrays.fill(this.clusterCentersComputed, false);
            this.clusterCenters = new PolClassifierBase.ClusterInfo[numTargetBands][9];
        }
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)op.getSourceProduct(), (Dimension)tileSize, (int)0);
        this.computeInitialClusterCenters(targetBandIndex, srcBandList, tileRectangles, op);
        this.computeFinalClusterCenters(targetBandIndex, srcBandList, tileRectangles, op);
        this.clusterCentersComputed[targetBandIndex] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeInitialClusterCenters(int targetBandIndex, final PolBandUtils.PolSourceBand srcBandList, Rectangle[] tileRectangles, final PolarimetricClassificationOp op) {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Computing Initial Cluster Centres... ", tileRectangles.length);
        final double[][][] sumRe = new double[9][3][3];
        final double[][][] sumIm = new double[9][3][3];
        double[][][] centerRe = new double[9][3][3];
        double[][][] centerIm = new double[9][3][3];
        final int[] counter = new int[9];
        final double noDataValue = srcBandList.srcBands[0].getNoDataValue();
        ThreadManager threadManager = new ThreadManager();
        try {
            for (final Rectangle rectangle : tileRectangles) {
                op.checkIfCancelled();
                Thread worker = new Thread(){
                    final Tile[] sourceTiles;
                    final ProductData[] dataBuffers;
                    final double[][] Tr;
                    final double[][] Ti;
                    {
                        this.sourceTiles = new Tile[srcBandList.srcBands.length];
                        this.dataBuffers = new ProductData[srcBandList.srcBands.length];
                        this.Tr = new double[3][3];
                        this.Ti = new double[3][3];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        int x0 = rectangle.x;
                        int y0 = rectangle.y;
                        int w = rectangle.width;
                        int h = rectangle.height;
                        int xMax = x0 + w;
                        int yMax = y0 + h;
                        Rectangle sourceRectangle = HAlphaWishart.this.getSourceRectangle(x0, y0, w, h);
                        for (int i = 0; i < this.sourceTiles.length; ++i) {
                            this.sourceTiles[i] = op.getSourceTile((RasterDataNode)srcBandList.srcBands[i], sourceRectangle);
                            this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                        }
                        TileIndex srcIndex = new TileIndex(this.sourceTiles[0]);
                        int y = y0;
                        while (y < yMax) {
                            srcIndex.calculateStride(y);
                            for (int x = x0; x < xMax; ++x) {
                                if (this.dataBuffers[0].getElemDoubleAt(srcIndex.getIndex(x)) == noDataValue) continue;
                                PolOpUtils.getMeanCoherencyMatrix((int)x, (int)y, (int)HAlphaWishart.this.halfWindowSizeX, (int)HAlphaWishart.this.halfWindowSizeY, (int)HAlphaWishart.this.srcWidth, (int)HAlphaWishart.this.srcHeight, (PolBandUtils.MATRIX)HAlphaWishart.this.sourceProductType, (TileIndex)srcIndex, (ProductData[])this.dataBuffers, (double[][])this.Tr, (double[][])this.Ti);
                                hAAlpha.HAAlpha data = hAAlpha.computeHAAlpha((double[][])this.Tr, (double[][])this.Ti);
                                if (Double.isNaN(data.entropy) || Double.isNaN(data.anisotropy) || Double.isNaN(data.alpha)) continue;
                                int[] nArray = counter;
                                // MONITORENTER : counter
                                int zoneIndex = HaAlphaDescriptor.getZoneIndex((double)data.entropy, (double)data.alpha, (boolean)HAlphaWishart.this.useLeeHAlphaPlaneDefinition);
                                int n = zoneIndex - 1;
                                counter[n] = counter[n] + 1;
                                PolClassifierBase.computeSummationOfT3(zoneIndex, this.Tr, this.Ti, sumRe, sumIm);
                                // MONITOREXIT : nArray
                            }
                            ++y;
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
            for (int z = 0; z < 9; ++z) {
                int count = counter[z];
                if (count <= 0) continue;
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        centerRe[z][i][j] = sumRe[z][i][j] / (double)count;
                        centerIm[z][i][j] = sumIm[z][i][j] / (double)count;
                    }
                }
                this.clusterCenters[targetBandIndex][z] = new PolClassifierBase.ClusterInfo();
                this.clusterCenters[targetBandIndex][z].setClusterCenter(z + 1, centerRe[z], centerIm[z], counter[z]);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " computeInitialClusterCenters "), (Throwable)e);
        }
        finally {
            status.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFinalClusterCenters(final int targetBandIndex, final PolBandUtils.PolSourceBand srcBandList, Rectangle[] tileRectangles, final PolarimetricClassificationOp op) {
        double[][][] centerRe = new double[9][3][3];
        double[][][] centerIm = new double[9][3][3];
        boolean endIteration = false;
        final double noDataValue = srcBandList.srcBands[0].getNoDataValue();
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Computing Final Cluster Centres... ", tileRectangles.length * this.maxIterations);
        ThreadManager threadManager = new ThreadManager();
        try {
            for (int it = 0; it < this.maxIterations && !endIteration; ++it) {
                final double[][][] sumRe = new double[9][3][3];
                final double[][][] sumIm = new double[9][3][3];
                final int[] counter = new int[9];
                for (final Rectangle rectangle : tileRectangles) {
                    Thread worker = new Thread(){
                        final Tile[] sourceTiles;
                        final ProductData[] dataBuffers;
                        final double[][] Tr;
                        final double[][] Ti;
                        {
                            this.sourceTiles = new Tile[srcBandList.srcBands.length];
                            this.dataBuffers = new ProductData[srcBandList.srcBands.length];
                            this.Tr = new double[3][3];
                            this.Ti = new double[3][3];
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         * Converted monitor instructions to comments
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            op.checkIfCancelled();
                            int x0 = rectangle.x;
                            int y0 = rectangle.y;
                            int w = rectangle.width;
                            int h = rectangle.height;
                            int xMax = x0 + w;
                            int yMax = y0 + h;
                            Rectangle sourceRectangle = HAlphaWishart.this.getSourceRectangle(x0, y0, w, h);
                            for (int i = 0; i < this.sourceTiles.length; ++i) {
                                this.sourceTiles[i] = op.getSourceTile((RasterDataNode)srcBandList.srcBands[i], sourceRectangle);
                                this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                            }
                            TileIndex srcIndex = new TileIndex(this.sourceTiles[0]);
                            int y = y0;
                            while (y < yMax) {
                                srcIndex.calculateStride(y);
                                for (int x = x0; x < xMax; ++x) {
                                    if (this.dataBuffers[0].getElemDoubleAt(srcIndex.getIndex(x)) == noDataValue) continue;
                                    PolOpUtils.getMeanCoherencyMatrix((int)x, (int)y, (int)HAlphaWishart.this.halfWindowSizeX, (int)HAlphaWishart.this.halfWindowSizeY, (int)HAlphaWishart.this.srcWidth, (int)HAlphaWishart.this.srcHeight, (PolBandUtils.MATRIX)HAlphaWishart.this.sourceProductType, (TileIndex)srcIndex, (ProductData[])this.dataBuffers, (double[][])this.Tr, (double[][])this.Ti);
                                    int[] nArray = counter;
                                    // MONITORENTER : counter
                                    int zoneIdx = HAlphaWishart.findZoneIndex(this.Tr, this.Ti, HAlphaWishart.this.clusterCenters[targetBandIndex]);
                                    int n = zoneIdx - 1;
                                    counter[n] = counter[n] + 1;
                                    PolClassifierBase.computeSummationOfT3(zoneIdx, this.Tr, this.Ti, sumRe, sumIm);
                                    // MONITOREXIT : nArray
                                }
                                ++y;
                            }
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
                double diff = 0.0;
                for (int z = 0; z < 9; ++z) {
                    int count = counter[z];
                    if (counter[z] <= 0) continue;
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            centerRe[z][i][j] = sumRe[z][i][j] / (double)count;
                            centerIm[z][i][j] = sumIm[z][i][j] / (double)count;
                            diff += (this.clusterCenters[targetBandIndex][z].centerRe[i][j] - centerRe[z][i][j]) * (this.clusterCenters[targetBandIndex][z].centerRe[i][j] - centerRe[z][i][j]) + (this.clusterCenters[targetBandIndex][z].centerIm[i][j] - centerIm[z][i][j]) * (this.clusterCenters[targetBandIndex][z].centerIm[i][j] - centerIm[z][i][j]);
                        }
                    }
                    this.clusterCenters[targetBandIndex][z].setClusterCenter(z + 1, centerRe[z], centerIm[z], counter[z]);
                }
                if (diff != 0.0) continue;
                endIteration = true;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " computeFinalClusterCenters "), (Throwable)e);
        }
        finally {
            status.done();
        }
    }

    public static int findZoneIndex(double[][] Tr, double[][] Ti, PolClassifierBase.ClusterInfo[] clusterCenters) {
        double minDistance = 1.0E30;
        int zoneIndex = -1;
        for (int z = 0; z < clusterCenters.length; ++z) {
            double d;
            if (clusterCenters[z] == null || !(minDistance > (d = HAlphaWishart.computeWishartDistance(Tr, Ti, clusterCenters[z])))) continue;
            minDistance = d;
            zoneIndex = z + 1;
        }
        return zoneIndex;
    }

    static double computeWishartDistance(double[][] Tr, double[][] Ti, PolClassifierBase.ClusterInfo cluster) {
        return cluster.invCenterRe[0][0] * Tr[0][0] - cluster.invCenterIm[0][0] * Ti[0][0] + cluster.invCenterRe[1][1] * Tr[1][1] - cluster.invCenterIm[1][1] * Ti[1][1] + cluster.invCenterRe[2][2] * Tr[2][2] - cluster.invCenterIm[2][2] * Ti[2][2] + 2.0 * (cluster.invCenterRe[0][1] * Tr[0][1] + cluster.invCenterIm[0][1] * Ti[0][1]) + 2.0 * (cluster.invCenterRe[0][2] * Tr[0][2] + cluster.invCenterIm[0][2] * Ti[0][2]) + 2.0 * (cluster.invCenterRe[1][2] * Tr[1][2] + cluster.invCenterIm[1][2] * Ti[1][2]) + cluster.logDet;
    }
}

