/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.gpf.classifiers;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.csa.rstb.classification.gpf.PolarimetricClassificationOp;
import org.csa.rstb.classification.gpf.classifiers.HAlphaWishart;
import org.csa.rstb.classification.gpf.classifiers.PolClassifier;
import org.csa.rstb.classification.gpf.classifiers.PolClassifierBase;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.csa.rstb.polarimetric.gpf.decompositions.FreemanDurden;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class FreemanDurdenWishart
extends PolClassifierBase
implements PolClassifier {
    private static final String TERRAIN_CLASS = "Freeman-Durden_wishart_class";
    private final int numInitialClusters;
    private boolean clusterCentersComputed = false;
    private final int maxIterations;
    private final int numFinalClasses;
    private byte[][] mask = null;
    private final double mixedCategoryThreshold;
    private int maxClusterSize = 0;
    private int[] pvColourIndexMap = null;
    private int[] pdColourIndexMap = null;
    private int[] psColourIndexMap = null;

    public FreemanDurdenWishart(PolBandUtils.MATRIX srcProductType, int srcWidth, int srcHeight, int windowSize, Map<Band, PolBandUtils.PolSourceBand> bandMap, int maxIterations, int numInitialClasses, int numClasses, double mixedCategoryThreshold, PolarimetricClassificationOp op) {
        super(srcProductType, srcWidth, srcHeight, windowSize, windowSize, bandMap, op);
        this.maxIterations = maxIterations;
        this.numFinalClasses = numClasses;
        this.numInitialClusters = numInitialClasses / 3;
        this.mixedCategoryThreshold = mixedCategoryThreshold;
    }

    @Override
    public boolean canProcessStacks() {
        return false;
    }

    @Override
    public String getTargetBandName() {
        return TERRAIN_CLASS;
    }

    @Override
    public int getNumClasses() {
        return this.numFinalClasses;
    }

    @Override
    public IndexCoding createIndexCoding() {
        int i;
        IndexCoding indexCoding = new IndexCoding("Cluster_classes");
        indexCoding.addIndex("no data", 0, "no data");
        for (i = 1; i <= this.numInitialClusters; ++i) {
            indexCoding.addIndex("surf_" + i, i, "Surface " + i);
        }
        for (i = this.numInitialClusters + 1; i <= 2 * this.numInitialClusters; ++i) {
            indexCoding.addIndex("vol_" + i, i, "Volume " + i);
        }
        for (i = 2 * this.numInitialClusters + 1; i <= 3 * this.numInitialClusters; ++i) {
            indexCoding.addIndex("dbl_" + i, i, "Double " + i);
        }
        return indexCoding;
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile) {
        PolBandUtils.PolSourceBand srcBandList = (PolBandUtils.PolSourceBand)this.bandMap.get(targetBand);
        if (!this.clusterCentersComputed) {
            this.computeTerrainClusterCenters(srcBandList, this.op);
        }
        Rectangle targetRectangle = targetTile.getRectangle();
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        ProductData targetData = targetTile.getDataBuffer();
        TileIndex trgIndex = new TileIndex(targetTile);
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                targetData.setElemIntAt(trgIndex.getIndex(x), this.getOutputClusterIndex(x, y));
            }
        }
    }

    private synchronized void computeTerrainClusterCenters(PolBandUtils.PolSourceBand srcBandList, PolarimetricClassificationOp op) {
        if (this.clusterCentersComputed) {
            return;
        }
        this.mask = new byte[this.srcHeight][this.srcWidth];
        double[][] fdd = new double[this.srcHeight][this.srcWidth];
        ArrayList<PolClassifierBase.ClusterInfo> pvCenterList = new ArrayList<PolClassifierBase.ClusterInfo>(this.numInitialClusters);
        ArrayList<PolClassifierBase.ClusterInfo> pdCenterList = new ArrayList<PolClassifierBase.ClusterInfo>(this.numInitialClusters);
        ArrayList<PolClassifierBase.ClusterInfo> psCenterList = new ArrayList<PolClassifierBase.ClusterInfo>(this.numInitialClusters);
        this.maxClusterSize = 2 * this.srcHeight * this.srcWidth / this.numFinalClasses;
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)op.getSourceProduct(), (Dimension)tileSize, (int)0);
        this.computeInitialTerrainClusterCenters(fdd, pvCenterList, pdCenterList, psCenterList, srcBandList, tileRectangles, op);
        this.computeFinalTerrainClusterCenters(fdd, pvCenterList, pdCenterList, psCenterList, srcBandList, tileRectangles, op);
        this.clusterCentersComputed = true;
    }

    private void computeInitialTerrainClusterCenters(double[][] fdd, List<PolClassifierBase.ClusterInfo> pvCenterList, List<PolClassifierBase.ClusterInfo> pdCenterList, List<PolClassifierBase.ClusterInfo> psCenterList, PolBandUtils.PolSourceBand srcBandList, Rectangle[] tileRectangles, PolarimetricClassificationOp op) {
        try {
            this.createInitialClusters(fdd, srcBandList, tileRectangles, op);
            this.getClusterCenters(pvCenterList, pdCenterList, psCenterList, srcBandList, tileRectangles, op);
            this.mergeInitialClusters(pvCenterList, pdCenterList, psCenterList);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " computeInitialClusterCenters "), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInitialClusters(final double[][] fdd, final PolBandUtils.PolSourceBand srcBandList, Rectangle[] tileRectangles, final PolarimetricClassificationOp op) {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Creating Initial Clusters... ", tileRectangles.length);
        final int[] counter = new int[4];
        ThreadManager threadManager = new ThreadManager();
        final double[] pv = new double[this.srcHeight * this.srcWidth];
        final double[] pd = new double[this.srcHeight * this.srcWidth];
        final double[] ps = new double[this.srcHeight * this.srcWidth];
        try {
            for (final Rectangle rectangle : tileRectangles) {
                op.checkIfCancelled();
                Thread worker = new Thread(){
                    final Tile[] sourceTiles;
                    final ProductData[] dataBuffers;
                    final double[][] Cr;
                    final double[][] Ci;
                    {
                        this.sourceTiles = new Tile[srcBandList.srcBands.length];
                        this.dataBuffers = new ProductData[srcBandList.srcBands.length];
                        this.Cr = new double[3][3];
                        this.Ci = new double[3][3];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        int x0 = rectangle.x;
                        int y0 = rectangle.y;
                        int w = rectangle.width;
                        int h = rectangle.height;
                        int xMax = x0 + w;
                        int yMax = y0 + h;
                        Rectangle sourceRectangle = FreemanDurdenWishart.this.getSourceRectangle(x0, y0, w, h);
                        for (int i = 0; i < this.sourceTiles.length; ++i) {
                            this.sourceTiles[i] = op.getSourceTile((RasterDataNode)srcBandList.srcBands[i], sourceRectangle);
                            this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                        }
                        int y = y0;
                        while (y < yMax) {
                            for (int x = x0; x < xMax; ++x) {
                                PolOpUtils.getMeanCovarianceMatrix((int)x, (int)y, (int)FreemanDurdenWishart.this.halfWindowSizeX, (int)FreemanDurdenWishart.this.halfWindowSizeY, (PolBandUtils.MATRIX)FreemanDurdenWishart.this.sourceProductType, (Tile[])this.sourceTiles, (ProductData[])this.dataBuffers, (double[][])this.Cr, (double[][])this.Ci);
                                FreemanDurden.FDD data = FreemanDurden.getFreemanDurdenDecomposition((double[][])this.Cr, (double[][])this.Ci);
                                int[] nArray = counter;
                                // MONITORENTER : counter
                                if (!(Double.isNaN(data.pv) || Double.isNaN(data.pd) || Double.isNaN(data.ps))) {
                                    Categories cat = FreemanDurdenWishart.getCategory(data.pv, data.pd, data.ps, FreemanDurdenWishart.this.mixedCategoryThreshold);
                                    if (cat == Categories.vol) {
                                        ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = -128;
                                        fdd[y][x] = data.pv;
                                        pv[counter[0]] = data.pv;
                                        counter[0] = counter[0] + 1;
                                    } else if (cat == Categories.dbl) {
                                        ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = -64;
                                        fdd[y][x] = data.pd;
                                        pd[counter[1]] = data.pd;
                                        counter[1] = counter[1] + 1;
                                    } else if (cat == Categories.suf) {
                                        ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = 0;
                                        fdd[y][x] = data.ps;
                                        ps[counter[2]] = data.ps;
                                        counter[2] = counter[2] + 1;
                                    } else {
                                        ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = 64;
                                        fdd[y][x] = (data.pv + data.pd + data.ps) / 3.0;
                                        counter[3] = counter[3] + 1;
                                    }
                                }
                                // MONITOREXIT : nArray
                            }
                            ++y;
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " createInitialClusters "), (Throwable)e);
        }
        finally {
            status.done();
        }
        int pvClusterSize = counter[0] / this.numInitialClusters;
        int pdClusterSize = counter[1] / this.numInitialClusters;
        int psClusterSize = counter[2] / this.numInitialClusters;
        if (pvClusterSize > 0) {
            Arrays.sort(pv, 0, counter[0] - 1);
        }
        if (pdClusterSize > 0) {
            Arrays.sort(pd, 0, counter[1] - 1);
        }
        if (psClusterSize > 0) {
            Arrays.sort(ps, 0, counter[2] - 1);
        }
        double[] pvThreshold = new double[this.numInitialClusters - 1];
        double[] pdThreshold = new double[this.numInitialClusters - 1];
        double[] psThreshold = new double[this.numInitialClusters - 1];
        for (int i = 0; i < this.numInitialClusters - 1; ++i) {
            pvThreshold[i] = pv[(i + 1) * pvClusterSize];
            pdThreshold[i] = pd[(i + 1) * pdClusterSize];
            psThreshold[i] = ps[(i + 1) * psClusterSize];
        }
        int clusterIdx = -1;
        for (int y = 0; y < this.srcHeight; ++y) {
            for (int x = 0; x < this.srcWidth; ++x) {
                if (this.mask[y][x] == -128) {
                    clusterIdx = FreemanDurdenWishart.computePixelClusterIdx(fdd[y][x], pvThreshold, this.numInitialClusters);
                    byte[] byArray = this.mask[y];
                    int n = x;
                    byArray[n] = (byte)(byArray[n] + clusterIdx);
                    continue;
                }
                if (this.mask[y][x] == -64) {
                    clusterIdx = FreemanDurdenWishart.computePixelClusterIdx(fdd[y][x], pdThreshold, this.numInitialClusters);
                    byte[] byArray = this.mask[y];
                    int n = x;
                    byArray[n] = (byte)(byArray[n] + clusterIdx);
                    continue;
                }
                if (this.mask[y][x] != 0) continue;
                clusterIdx = FreemanDurdenWishart.computePixelClusterIdx(fdd[y][x], psThreshold, this.numInitialClusters);
                byte[] byArray = this.mask[y];
                int n = x;
                byArray[n] = (byte)(byArray[n] + clusterIdx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getClusterCenters(List<PolClassifierBase.ClusterInfo> pvCenterList, List<PolClassifierBase.ClusterInfo> pdCenterList, List<PolClassifierBase.ClusterInfo> psCenterList, final PolBandUtils.PolSourceBand srcBandList, Rectangle[] tileRectangles, final PolarimetricClassificationOp op) {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Computing Initial Cluster Centres... ", tileRectangles.length);
        ThreadManager threadManager = new ThreadManager();
        final double[][][] pvSumRe = new double[this.numInitialClusters][3][3];
        final double[][][] pvSumIm = new double[this.numInitialClusters][3][3];
        final double[][][] pdSumRe = new double[this.numInitialClusters][3][3];
        final double[][][] pdSumIm = new double[this.numInitialClusters][3][3];
        final double[][][] psSumRe = new double[this.numInitialClusters][3][3];
        final double[][][] psSumIm = new double[this.numInitialClusters][3][3];
        final int[][] clusterCounter = new int[3][this.numInitialClusters];
        try {
            for (final Rectangle rectangle : tileRectangles) {
                op.checkIfCancelled();
                Thread worker = new Thread(){
                    final Tile[] sourceTiles;
                    final ProductData[] dataBuffers;
                    final double[][] Sr;
                    final double[][] Si;
                    final double[][] Tr;
                    final double[][] Ti;
                    {
                        this.sourceTiles = new Tile[srcBandList.srcBands.length];
                        this.dataBuffers = new ProductData[srcBandList.srcBands.length];
                        this.Sr = new double[2][2];
                        this.Si = new double[2][2];
                        this.Tr = new double[3][3];
                        this.Ti = new double[3][3];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        int x0 = rectangle.x;
                        int y0 = rectangle.y;
                        int w = rectangle.width;
                        int h = rectangle.height;
                        int xMax = x0 + w;
                        int yMax = y0 + h;
                        for (int i = 0; i < this.sourceTiles.length; ++i) {
                            this.sourceTiles[i] = op.getSourceTile((RasterDataNode)srcBandList.srcBands[i], rectangle);
                            this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                        }
                        TileIndex srcIndex = new TileIndex(this.sourceTiles[0]);
                        int y = y0;
                        while (y < yMax) {
                            srcIndex.calculateStride(y);
                            for (int x = x0; x < xMax; ++x) {
                                int clusterIdx;
                                PolOpUtils.getT3((int)srcIndex.getIndex(x), (PolBandUtils.MATRIX)FreemanDurdenWishart.this.sourceProductType, (ProductData[])this.dataBuffers, (double[][])this.Tr, (double[][])this.Ti);
                                int[][] nArray = clusterCounter;
                                // MONITORENTER : clusterCounter
                                if (FreemanDurdenWishart.this.mask[y][x] < -64) {
                                    clusterIdx = FreemanDurdenWishart.this.mask[y][x] + 128;
                                    PolClassifierBase.computeSummationOfT3(clusterIdx + 1, this.Tr, this.Ti, pvSumRe, pvSumIm);
                                    int[] nArray2 = clusterCounter[0];
                                    int n = clusterIdx;
                                    nArray2[n] = nArray2[n] + 1;
                                } else if (FreemanDurdenWishart.this.mask[y][x] < 0) {
                                    clusterIdx = FreemanDurdenWishart.this.mask[y][x] + 64;
                                    PolClassifierBase.computeSummationOfT3(clusterIdx + 1, this.Tr, this.Ti, pdSumRe, pdSumIm);
                                    int[] nArray3 = clusterCounter[1];
                                    int n = clusterIdx;
                                    nArray3[n] = nArray3[n] + 1;
                                } else if (FreemanDurdenWishart.this.mask[y][x] < 64) {
                                    clusterIdx = FreemanDurdenWishart.this.mask[y][x];
                                    PolClassifierBase.computeSummationOfT3(clusterIdx + 1, this.Tr, this.Ti, psSumRe, psSumIm);
                                    int[] nArray4 = clusterCounter[2];
                                    int n = clusterIdx;
                                    nArray4[n] = nArray4[n] + 1;
                                }
                                // MONITOREXIT : nArray
                            }
                            ++y;
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " getClusterCenters "), (Throwable)e);
        }
        finally {
            status.done();
        }
        for (int c = 0; c < this.numInitialClusters; ++c) {
            PolClassifierBase.ClusterInfo clusterCenter;
            double[][] centerRe = new double[3][3];
            double[][] centerIm = new double[3][3];
            if (clusterCounter[0][c] > 0) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        centerRe[i][j] = pvSumRe[c][i][j] / (double)clusterCounter[0][c];
                        centerIm[i][j] = pvSumIm[c][i][j] / (double)clusterCounter[0][c];
                    }
                }
                clusterCenter = new PolClassifierBase.ClusterInfo();
                clusterCenter.setClusterCenter(c, centerRe, centerIm, clusterCounter[0][c]);
                pvCenterList.add(clusterCenter);
            }
            if (clusterCounter[1][c] > 0) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        centerRe[i][j] = pdSumRe[c][i][j] / (double)clusterCounter[1][c];
                        centerIm[i][j] = pdSumIm[c][i][j] / (double)clusterCounter[1][c];
                    }
                }
                clusterCenter = new PolClassifierBase.ClusterInfo();
                clusterCenter.setClusterCenter(c, centerRe, centerIm, clusterCounter[1][c]);
                pdCenterList.add(clusterCenter);
            }
            if (clusterCounter[2][c] <= 0) continue;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    centerRe[i][j] = psSumRe[c][i][j] / (double)clusterCounter[2][c];
                    centerIm[i][j] = psSumIm[c][i][j] / (double)clusterCounter[2][c];
                }
            }
            clusterCenter = new PolClassifierBase.ClusterInfo();
            clusterCenter.setClusterCenter(c, centerRe, centerIm, clusterCounter[2][c]);
            psCenterList.add(clusterCenter);
        }
    }

    private void mergeInitialClusters(List<PolClassifierBase.ClusterInfo> pvCenterList, List<PolClassifierBase.ClusterInfo> pdCenterList, List<PolClassifierBase.ClusterInfo> psCenterList) {
        for (int totalNumClasses = pvCenterList.size() + pdCenterList.size() + psCenterList.size(); totalNumClasses > this.numFinalClasses; --totalNumClasses) {
            int[] pvClusterPair = new int[2];
            int[] pdClusterPair = new int[2];
            int[] psClusterPair = new int[2];
            double pvShortestDistance = this.computeShortestDistance(pvCenterList, pvClusterPair);
            double pdShortestDistance = this.computeShortestDistance(pdCenterList, pdClusterPair);
            double psShortestDistance = this.computeShortestDistance(psCenterList, psClusterPair);
            if (pvShortestDistance < pdShortestDistance && pvShortestDistance < psShortestDistance) {
                FreemanDurdenWishart.mergeClusters(pvCenterList, pvClusterPair);
                continue;
            }
            if (pdShortestDistance < pvShortestDistance && pdShortestDistance < psShortestDistance) {
                FreemanDurdenWishart.mergeClusters(pdCenterList, pdClusterPair);
                continue;
            }
            if (psShortestDistance < pvShortestDistance && psShortestDistance < pdShortestDistance) {
                FreemanDurdenWishart.mergeClusters(psCenterList, psClusterPair);
                continue;
            }
            if (pvShortestDistance > pdShortestDistance && pvShortestDistance > psShortestDistance) {
                if (pdCenterList.get((int)pdClusterPair[0]).size + pdCenterList.get((int)pdClusterPair[1]).size <= psCenterList.get((int)psClusterPair[0]).size + psCenterList.get((int)psClusterPair[1]).size) {
                    FreemanDurdenWishart.mergeClusters(pdCenterList, pdClusterPair);
                    continue;
                }
                FreemanDurdenWishart.mergeClusters(psCenterList, psClusterPair);
                continue;
            }
            if (pdShortestDistance > pvShortestDistance && pdShortestDistance > psShortestDistance) {
                if (pvCenterList.get((int)pvClusterPair[0]).size + pvCenterList.get((int)pvClusterPair[1]).size <= psCenterList.get((int)psClusterPair[0]).size + psCenterList.get((int)psClusterPair[1]).size) {
                    FreemanDurdenWishart.mergeClusters(pvCenterList, pvClusterPair);
                    continue;
                }
                FreemanDurdenWishart.mergeClusters(psCenterList, psClusterPair);
                continue;
            }
            if (psShortestDistance > pvShortestDistance && psShortestDistance > pdShortestDistance) {
                if (pdCenterList.get((int)pdClusterPair[0]).size + pdCenterList.get((int)pdClusterPair[1]).size <= pvCenterList.get((int)pvClusterPair[0]).size + pvCenterList.get((int)pvClusterPair[1]).size) {
                    FreemanDurdenWishart.mergeClusters(pdCenterList, pdClusterPair);
                    continue;
                }
                FreemanDurdenWishart.mergeClusters(pvCenterList, pvClusterPair);
                continue;
            }
            int pvNewClusterSize = pvCenterList.get((int)pvClusterPair[0]).size + pvCenterList.get((int)pvClusterPair[1]).size;
            int pdNewClusterSize = pdCenterList.get((int)pdClusterPair[0]).size + pdCenterList.get((int)pdClusterPair[1]).size;
            int psNewClusterSize = psCenterList.get((int)psClusterPair[0]).size + psCenterList.get((int)psClusterPair[1]).size;
            if (pvNewClusterSize <= pdNewClusterSize && pvNewClusterSize <= psNewClusterSize) {
                FreemanDurdenWishart.mergeClusters(pvCenterList, pvClusterPair);
                continue;
            }
            if (pdNewClusterSize <= pvNewClusterSize && pdNewClusterSize <= psNewClusterSize) {
                FreemanDurdenWishart.mergeClusters(pdCenterList, pdClusterPair);
                continue;
            }
            FreemanDurdenWishart.mergeClusters(psCenterList, psClusterPair);
        }
    }

    private static Categories getCategory(double pv, double pd, double ps, double mixedCategoryThreshold) {
        Categories dominantCategory = Categories.mix;
        double dominantValue = 0.0;
        double sum = pv + pd + ps;
        if (sum == 0.0) {
            return Categories.mix;
        }
        if (pv >= pd && pv >= ps) {
            dominantCategory = Categories.vol;
            dominantValue = pv;
        } else if (pd >= pv && pd >= ps) {
            dominantCategory = Categories.dbl;
            dominantValue = pd;
        } else if (ps >= pv && ps >= pd) {
            dominantCategory = Categories.suf;
            dominantValue = ps;
        }
        if (dominantValue / sum <= mixedCategoryThreshold) {
            return Categories.mix;
        }
        return dominantCategory;
    }

    private static int computePixelClusterIdx(double value, double[] threshold, int numInitialClusters) {
        for (int i = 0; i < numInitialClusters - 1; ++i) {
            if (!(value < threshold[i])) continue;
            return i;
        }
        return numInitialClusters - 1;
    }

    private double computeShortestDistance(List<PolClassifierBase.ClusterInfo> clusterCenterList, int[] clusterPair) {
        int numClusters = clusterCenterList.size();
        double shortestDistance = Double.MAX_VALUE;
        if (numClusters <= 3) {
            return shortestDistance;
        }
        for (int i = 0; i < numClusters - 1; ++i) {
            if (clusterCenterList.get((int)i).size >= this.maxClusterSize) continue;
            for (int j = i + 1; j < numClusters; ++j) {
                double d;
                if (clusterCenterList.get((int)j).size >= this.maxClusterSize || !((d = HAlphaWishart.computeWishartDistance(clusterCenterList.get((int)i).centerRe, clusterCenterList.get((int)i).centerIm, clusterCenterList.get(j))) < shortestDistance)) continue;
                shortestDistance = d;
                clusterPair[0] = i;
                clusterPair[1] = j;
            }
        }
        return shortestDistance;
    }

    private static void mergeClusters(List<PolClassifierBase.ClusterInfo> clusterCenterList, int[] clusterPair) {
        int idx1 = clusterPair[0];
        int idx2 = clusterPair[1];
        int size1 = clusterCenterList.get((int)idx1).size;
        int size2 = clusterCenterList.get((int)idx2).size;
        int newClusterSize = size1 + size2;
        double[][] newCenterRe = new double[3][3];
        double[][] newCenterIm = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                newCenterRe[i][j] = ((double)size1 * clusterCenterList.get((int)idx1).centerRe[i][j] + (double)size2 * clusterCenterList.get((int)idx2).centerRe[i][j]) / (double)newClusterSize;
                newCenterIm[i][j] = ((double)size1 * clusterCenterList.get((int)idx1).centerIm[i][j] + (double)size2 * clusterCenterList.get((int)idx2).centerIm[i][j]) / (double)newClusterSize;
            }
        }
        if (idx1 < idx2) {
            clusterCenterList.remove(idx2);
            clusterCenterList.remove(idx1);
        } else {
            clusterCenterList.remove(idx1);
            clusterCenterList.remove(idx2);
        }
        PolClassifierBase.ClusterInfo clusterCenter = new PolClassifierBase.ClusterInfo();
        clusterCenter.setClusterCenter(clusterCenterList.size(), newCenterRe, newCenterIm, newClusterSize);
        clusterCenterList.add(clusterCenter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFinalTerrainClusterCenters(double[][] fdd, final List<PolClassifierBase.ClusterInfo> pvCenterList, final List<PolClassifierBase.ClusterInfo> pdCenterList, final List<PolClassifierBase.ClusterInfo> psCenterList, final PolBandUtils.PolSourceBand srcBandList, Rectangle[] tileRectangles, final PolarimetricClassificationOp op) {
        boolean endIteration = false;
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Computing Final Cluster Centres... ", tileRectangles.length * this.maxIterations);
        final int pvNumClusters = pvCenterList.size();
        final int pdNumClusters = pdCenterList.size();
        int psNumClusters = psCenterList.size();
        int maxNumClusters = Math.max(pvNumClusters, Math.max(pdNumClusters, psNumClusters));
        final int[][] clusterCounter = new int[3][maxNumClusters];
        ThreadManager threadManager = new ThreadManager();
        try {
            int c;
            for (int it = 0; it < this.maxIterations && !endIteration; ++it) {
                final double[][][] pvSumRe = new double[pvNumClusters][3][3];
                final double[][][] pvSumIm = new double[pvNumClusters][3][3];
                final double[][][] pdSumRe = new double[pdNumClusters][3][3];
                final double[][][] pdSumIm = new double[pdNumClusters][3][3];
                final double[][][] psSumRe = new double[psNumClusters][3][3];
                final double[][][] psSumIm = new double[psNumClusters][3][3];
                Arrays.fill(clusterCounter[0], 0);
                Arrays.fill(clusterCounter[1], 0);
                Arrays.fill(clusterCounter[2], 0);
                for (final Rectangle rectangle : tileRectangles) {
                    Thread worker = new Thread(){
                        final Tile[] sourceTiles;
                        final ProductData[] dataBuffers;
                        final double[][] Tr;
                        final double[][] Ti;
                        {
                            this.sourceTiles = new Tile[srcBandList.srcBands.length];
                            this.dataBuffers = new ProductData[srcBandList.srcBands.length];
                            this.Tr = new double[3][3];
                            this.Ti = new double[3][3];
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         * Converted monitor instructions to comments
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            op.checkIfCancelled();
                            int x0 = rectangle.x;
                            int y0 = rectangle.y;
                            int w = rectangle.width;
                            int h = rectangle.height;
                            int xMax = x0 + w;
                            int yMax = y0 + h;
                            Rectangle sourceRectangle = FreemanDurdenWishart.this.getSourceRectangle(x0, y0, w, h);
                            for (int i = 0; i < this.sourceTiles.length; ++i) {
                                this.sourceTiles[i] = op.getSourceTile((RasterDataNode)srcBandList.srcBands[i], sourceRectangle);
                                this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                            }
                            TileIndex srcIndex = new TileIndex(this.sourceTiles[0]);
                            int y = y0;
                            while (y < yMax) {
                                for (int x = x0; x < xMax; ++x) {
                                    int clusterIdx;
                                    PolOpUtils.getMeanCoherencyMatrix((int)x, (int)y, (int)FreemanDurdenWishart.this.halfWindowSizeX, (int)FreemanDurdenWishart.this.halfWindowSizeY, (int)FreemanDurdenWishart.this.srcWidth, (int)FreemanDurdenWishart.this.srcHeight, (PolBandUtils.MATRIX)FreemanDurdenWishart.this.sourceProductType, (TileIndex)srcIndex, (ProductData[])this.dataBuffers, (double[][])this.Tr, (double[][])this.Ti);
                                    int[][] nArray = clusterCounter;
                                    // MONITORENTER : clusterCounter
                                    if (FreemanDurdenWishart.this.mask[y][x] < -64) {
                                        clusterIdx = FreemanDurdenWishart.findClosestCluster(this.Tr, this.Ti, pvCenterList);
                                        PolClassifierBase.computeSummationOfT3(clusterIdx + 1, this.Tr, this.Ti, pvSumRe, pvSumIm);
                                        int[] nArray2 = clusterCounter[0];
                                        int n = clusterIdx;
                                        nArray2[n] = nArray2[n] + 1;
                                        ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = (byte)(-128 + clusterIdx);
                                    } else if (FreemanDurdenWishart.this.mask[y][x] < 0) {
                                        clusterIdx = FreemanDurdenWishart.findClosestCluster(this.Tr, this.Ti, pdCenterList);
                                        PolClassifierBase.computeSummationOfT3(clusterIdx + 1, this.Tr, this.Ti, pdSumRe, pdSumIm);
                                        int[] nArray3 = clusterCounter[1];
                                        int n = clusterIdx;
                                        nArray3[n] = nArray3[n] + 1;
                                        ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = (byte)(-64 + clusterIdx);
                                    } else if (FreemanDurdenWishart.this.mask[y][x] < 64) {
                                        clusterIdx = FreemanDurdenWishart.findClosestCluster(this.Tr, this.Ti, psCenterList);
                                        PolClassifierBase.computeSummationOfT3(clusterIdx + 1, this.Tr, this.Ti, psSumRe, psSumIm);
                                        int[] nArray4 = clusterCounter[2];
                                        int n = clusterIdx;
                                        nArray4[n] = nArray4[n] + 1;
                                        ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = (byte)clusterIdx;
                                    } else {
                                        ArrayList<PolClassifierBase.ClusterInfo> allCenterList = new ArrayList<PolClassifierBase.ClusterInfo>();
                                        allCenterList.addAll(pvCenterList);
                                        allCenterList.addAll(pdCenterList);
                                        allCenterList.addAll(psCenterList);
                                        clusterIdx = FreemanDurdenWishart.findClosestCluster(this.Tr, this.Ti, allCenterList);
                                        if (clusterIdx >= pvNumClusters + pdNumClusters) {
                                            PolClassifierBase.computeSummationOfT3((clusterIdx -= pvNumClusters + pdNumClusters) + 1, this.Tr, this.Ti, psSumRe, psSumIm);
                                            int[] nArray5 = clusterCounter[2];
                                            int n = clusterIdx;
                                            nArray5[n] = nArray5[n] + 1;
                                            ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = (byte)clusterIdx;
                                        } else if (clusterIdx >= pvNumClusters) {
                                            PolClassifierBase.computeSummationOfT3((clusterIdx -= pvNumClusters) + 1, this.Tr, this.Ti, pdSumRe, pdSumIm);
                                            int[] nArray6 = clusterCounter[1];
                                            int n = clusterIdx;
                                            nArray6[n] = nArray6[n] + 1;
                                            ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = (byte)(-64 + clusterIdx);
                                        } else {
                                            PolClassifierBase.computeSummationOfT3(clusterIdx + 1, this.Tr, this.Ti, pvSumRe, pvSumIm);
                                            int[] nArray7 = clusterCounter[0];
                                            int n = clusterIdx;
                                            nArray7[n] = nArray7[n] + 1;
                                            ((FreemanDurdenWishart)FreemanDurdenWishart.this).mask[y][x] = (byte)(-128 + clusterIdx);
                                        }
                                    }
                                    // MONITOREXIT : nArray
                                }
                                ++y;
                            }
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
                threadManager.finish();
                FreemanDurdenWishart.updateClusterCenter(pvCenterList, clusterCounter[0], pvSumRe, pvSumIm);
                FreemanDurdenWishart.updateClusterCenter(pdCenterList, clusterCounter[1], pdSumRe, pdSumIm);
                FreemanDurdenWishart.updateClusterCenter(psCenterList, clusterCounter[2], psSumRe, psSumIm);
            }
            double[] pvAvgClusterPower = new double[pvNumClusters];
            double[] pdAvgClusterPower = new double[pdNumClusters];
            double[] psAvgClusterPower = new double[psNumClusters];
            int clusterIdx = -1;
            for (int y = 0; y < this.srcHeight; ++y) {
                for (int x = 0; x < this.srcWidth; ++x) {
                    if (this.mask[y][x] < -64) {
                        int n = clusterIdx = this.mask[y][x] + 128;
                        pvAvgClusterPower[n] = pvAvgClusterPower[n] + fdd[y][x];
                        continue;
                    }
                    if (this.mask[y][x] < 0) {
                        int n = clusterIdx = this.mask[y][x] + 64;
                        pdAvgClusterPower[n] = pdAvgClusterPower[n] + fdd[y][x];
                        continue;
                    }
                    int n = clusterIdx = this.mask[y][x];
                    psAvgClusterPower[n] = psAvgClusterPower[n] + fdd[y][x];
                }
            }
            for (c = 0; c < pvNumClusters; ++c) {
                int n = c;
                pvAvgClusterPower[n] = pvAvgClusterPower[n] / (double)clusterCounter[0][c];
            }
            for (c = 0; c < pdNumClusters; ++c) {
                int n = c;
                pdAvgClusterPower[n] = pdAvgClusterPower[n] / (double)clusterCounter[1][c];
            }
            for (c = 0; c < psNumClusters; ++c) {
                int n = c;
                psAvgClusterPower[n] = psAvgClusterPower[n] / (double)clusterCounter[2][c];
            }
            this.pvColourIndexMap = new int[pvNumClusters];
            this.pdColourIndexMap = new int[pdNumClusters];
            this.psColourIndexMap = new int[psNumClusters];
            for (c = 0; c < pvNumClusters; ++c) {
                this.pvColourIndexMap[c] = this.numInitialClusters + FreemanDurdenWishart.getColourIndex(c, pvAvgClusterPower, this.numInitialClusters) + 1;
            }
            for (c = 0; c < pdNumClusters; ++c) {
                this.pdColourIndexMap[c] = 2 * this.numInitialClusters + FreemanDurdenWishart.getColourIndex(c, pdAvgClusterPower, this.numInitialClusters) + 1;
            }
            for (c = 0; c < psNumClusters; ++c) {
                this.psColourIndexMap[c] = FreemanDurdenWishart.getColourIndex(c, psAvgClusterPower, this.numInitialClusters) + 1;
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(op.getId() + " computeInitialClusterCenters "), (Throwable)e);
        }
        finally {
            status.done();
        }
    }

    private static int getColourIndex(int clusterIndex, double[] pAvgClusterPower, int numInitialClusters) {
        int n = 0;
        for (double p : pAvgClusterPower) {
            if (!(p > pAvgClusterPower[clusterIndex])) continue;
            ++n;
        }
        int d = numInitialClusters / pAvgClusterPower.length;
        return n * d;
    }

    public static int findClosestCluster(double[][] Tr, double[][] Ti, List<PolClassifierBase.ClusterInfo> clusterCenters) {
        double minDistance = Double.MAX_VALUE;
        int clusterIndex = -1;
        for (int c = 0; c < clusterCenters.size(); ++c) {
            double d = HAlphaWishart.computeWishartDistance(Tr, Ti, clusterCenters.get(c));
            if (!(minDistance > d)) continue;
            minDistance = d;
            clusterIndex = c;
        }
        return clusterIndex;
    }

    private static void updateClusterCenter(List<PolClassifierBase.ClusterInfo> centerList, int[] clusterCounter, double[][][] sumRe, double[][][] sumIm) {
        for (int c = 0; c < centerList.size(); ++c) {
            double[][] centerRe = new double[3][3];
            double[][] centerIm = new double[3][3];
            if (clusterCounter[c] <= 0) continue;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    centerRe[i][j] = sumRe[c][i][j] / (double)clusterCounter[c];
                    centerIm[i][j] = sumIm[c][i][j] / (double)clusterCounter[c];
                }
            }
            centerList.get(c).setClusterCenter(c, centerRe, centerIm, clusterCounter[c]);
        }
    }

    private int getOutputClusterIndex(int x, int y) {
        return this.mask[y][x] < -64 ? this.pvColourIndexMap[this.mask[y][x] + 128] : (this.mask[y][x] < 0 ? this.pdColourIndexMap[this.mask[y][x] + 64] : this.psColourIndexMap[this.mask[y][x]]);
    }

    private static enum Categories {
        vol,
        dbl,
        suf,
        mix;

    }
}

