/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.gpf.classifiers;

import java.awt.Rectangle;
import java.util.Map;
import org.csa.rstb.classification.gpf.PolarimetricClassificationOp;
import org.csa.rstb.classification.gpf.classifiers.PolClassifier;
import org.csa.rstb.classification.gpf.classifiers.PolClassifierBase;
import org.csa.rstb.polarimetric.gpf.DualPolOpUtils;
import org.csa.rstb.polarimetric.gpf.HaAlphaDescriptor;
import org.csa.rstb.polarimetric.gpf.decompositions.HAlphaC2;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class CloudePottierC2
extends PolClassifierBase
implements PolClassifier {
    private static final String H_ALPHA_CLASS = "H_alpha_class";
    private final boolean useLeeHAlphaPlaneDefinition = Boolean.getBoolean(SystemUtils.getApplicationContextId() + ".useLeeHAlphaPlaneDefinition");

    public CloudePottierC2(PolBandUtils.MATRIX sourceProductType, int sourceWidth, int sourceHeight, int winSize, Map<Band, PolBandUtils.PolSourceBand> srcbandMap, PolarimetricClassificationOp op) {
        super(sourceProductType, sourceWidth, sourceHeight, winSize, winSize, srcbandMap, op);
    }

    @Override
    public String getTargetBandName() {
        return H_ALPHA_CLASS;
    }

    @Override
    public int getNumClasses() {
        return 9;
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile) {
        Rectangle targetRectangle = targetTile.getRectangle();
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        ProductData targetData = targetTile.getDataBuffer();
        TileIndex trgIndex = new TileIndex(targetTile);
        PolBandUtils.PolSourceBand srcBandList = (PolBandUtils.PolSourceBand)this.bandMap.get(targetBand);
        Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
        Tile[] sourceTiles = new Tile[srcBandList.srcBands.length];
        ProductData[] dataBuffers = new ProductData[srcBandList.srcBands.length];
        for (int i = 0; i < srcBandList.srcBands.length; ++i) {
            sourceTiles[i] = this.op.getSourceTile((RasterDataNode)srcBandList.srcBands[i], sourceRectangle);
            dataBuffers[i] = sourceTiles[i].getDataBuffer();
        }
        double[][] Cr = new double[2][2];
        double[][] Ci = new double[2][2];
        boolean noDataValue = false;
        for (int y = y0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                DualPolOpUtils.getMeanCovarianceMatrixC2((int)x, (int)y, (int)this.halfWindowSizeX, (int)this.halfWindowSizeY, (int)this.srcWidth, (int)this.srcHeight, (PolBandUtils.MATRIX)this.sourceProductType, (Tile[])sourceTiles, (ProductData[])dataBuffers, (double[][])Cr, (double[][])Ci);
                HAlphaC2.HAAlpha data = HAlphaC2.computeHAAlphaByC2((double[][])Cr, (double[][])Ci);
                if (!(Double.isNaN(data.entropy) || Double.isNaN(data.anisotropy) || Double.isNaN(data.alpha))) {
                    targetData.setElemIntAt(trgIndex.getIndex(x), HaAlphaDescriptor.getZoneIndex((double)data.entropy, (double)data.alpha, (boolean)this.useLeeHAlphaPlaneDefinition));
                    continue;
                }
                targetData.setElemIntAt(trgIndex.getIndex(x), 0);
            }
        }
    }
}

