/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.csa.rstb.classification.gpf.classifiers.HAlphaWishart;
import org.csa.rstb.classification.gpf.classifiers.HAlphaWishartC2;
import org.csa.rstb.classification.gpf.classifiers.PolClassifierBase;
import org.csa.rstb.polarimetric.gpf.DualPolOpUtils;
import org.csa.rstb.polarimetric.gpf.PolOpUtils;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.ResourceUtils;

@OperatorMetadata(alias="Supervised-Wishart-Classification", category="Radar/Polarimetric", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Perform supervised Wishart classification")
public final class SupervisedWishartClassificationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The training data set file", label="Training Data Set")
    private File trainingDataSet = null;
    @Parameter(description="The sliding window size", interval="(1, 100]", defaultValue="5", label="Window Size")
    private int windowSize = 5;
    private int halfWindowSize;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private PolBandUtils.PolSourceBand[] srcBandList;
    private PolBandUtils.MATRIX sourceProductType;
    private PolClassifierBase.ClusterInfo[] clusterCenters = null;
    private int[] clusterToClassMap = null;
    private int numClasses = 0;
    private boolean isDualPol = false;
    private static final String PRODUCT_SUFFIX = "_Class";

    public void initialize() throws OperatorException {
        try {
            if (!this.trainingDataSet.exists()) {
                throw new OperatorException("Cannot find training data set file: " + this.trainingDataSet.getAbsolutePath());
            }
            this.halfWindowSize = this.windowSize / 2;
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.checkProductValidity();
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.getClusterCenters();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkProductValidity() {
        if (this.sourceProductType != PolBandUtils.MATRIX.T3 && this.sourceProductType != PolBandUtils.MATRIX.C3 && this.sourceProductType != PolBandUtils.MATRIX.FULL) {
            if (this.sourceProductType != PolBandUtils.MATRIX.DUAL_HH_HV && this.sourceProductType != PolBandUtils.MATRIX.DUAL_VH_VV && this.sourceProductType != PolBandUtils.MATRIX.DUAL_HH_VV && this.sourceProductType != PolBandUtils.MATRIX.C2) {
                throw new OperatorException("Quad-pol or dual-pol product is expected");
            }
            this.isDualPol = true;
        }
    }

    private void getClusterCenters() throws IOException {
        if (this.isDualPol) {
            this.getDualPolClusterCenters();
        } else {
            this.getQuadPolClusterCenters();
        }
    }

    private void getDualPolClusterCenters() throws IOException {
        Properties clusterCenterProperties = ResourceUtils.loadProperties((String)this.trainingDataSet.getAbsolutePath());
        int numOfClusters = Integer.parseInt(clusterCenterProperties.getProperty("number_of_clusters"));
        this.clusterCenters = new PolClassifierBase.ClusterInfo[numOfClusters];
        this.clusterToClassMap = new int[numOfClusters];
        double[][] Cr = new double[2][2];
        double[][] Ci = new double[2][2];
        String currentClassName = "";
        for (int c = 0; c < numOfClusters; ++c) {
            String cluster = "cluster" + c;
            String clusterName = clusterCenterProperties.getProperty(cluster);
            String className = clusterName.substring(0, clusterName.lastIndexOf(95));
            if (!className.equals(currentClassName)) {
                currentClassName = className;
            }
            this.clusterToClassMap[c] = ++this.numClasses;
            Cr[0][0] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_C11"));
            Cr[0][1] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_C12_real"));
            Ci[0][1] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_C12_imag"));
            Cr[1][1] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_C22"));
            this.clusterCenters[c] = new PolClassifierBase.ClusterInfo();
            this.clusterCenters[c].setClusterCenter(c, Cr, Ci, 0);
        }
    }

    private void getQuadPolClusterCenters() throws IOException {
        Properties clusterCenterProperties = ResourceUtils.loadProperties((String)this.trainingDataSet.getAbsolutePath());
        int numOfClusters = Integer.parseInt(clusterCenterProperties.getProperty("number_of_clusters"));
        this.clusterCenters = new PolClassifierBase.ClusterInfo[numOfClusters];
        this.clusterToClassMap = new int[numOfClusters];
        double[][] Tr = new double[3][3];
        double[][] Ti = new double[3][3];
        String currentClassName = "";
        for (int c = 0; c < numOfClusters; ++c) {
            String cluster = "cluster" + c;
            String clusterName = clusterCenterProperties.getProperty(cluster);
            String className = clusterName.substring(0, clusterName.lastIndexOf(95));
            if (!className.equals(currentClassName)) {
                currentClassName = className;
            }
            this.clusterToClassMap[c] = ++this.numClasses;
            Tr[0][0] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T11"));
            Tr[0][1] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T12_real"));
            Ti[0][1] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T12_imag"));
            Tr[1][2] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T13_real"));
            Ti[1][2] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T13_imag"));
            Tr[1][1] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T22"));
            Tr[1][2] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T23_real"));
            Ti[1][2] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T23_imag"));
            Tr[2][2] = Double.parseDouble(clusterCenterProperties.getProperty(cluster + "_T33"));
            this.clusterCenters[c] = new PolClassifierBase.ClusterInfo();
            this.clusterCenters[c].setClusterCenter(c, Tr, Ti, 0);
        }
    }

    private void createTargetProduct() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        IndexCoding indexCoding = new IndexCoding("Cluster_classes");
        for (int i = 0; i < this.numClasses; ++i) {
            indexCoding.addIndex("class_" + (i + 1), i, "Cluster " + (i + 1));
        }
        this.targetProduct.getIndexCodingGroup().add((ProductNode)indexCoding);
        String targetBandName = "supervised_wishart_class";
        Band targetBand = new Band("supervised_wishart_class", 20, this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
        targetBand.setUnit("zone_index");
        targetBand.setSampleCoding((SampleCoding)indexCoding);
        this.targetProduct.addBand(targetBand);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct).setAttributeInt("polsar_data", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetRectangle = targetTile.getRectangle();
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            int maxY = y0 + h;
            int maxX = x0 + w;
            ProductData targetData = targetTile.getDataBuffer();
            TileIndex trgIndex = new TileIndex(targetTile);
            for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
                Tile[] sourceTiles = new Tile[bandList.srcBands.length];
                ProductData[] dataBuffers = new ProductData[bandList.srcBands.length];
                Rectangle sourceRectangle = this.getSourceRectangle(x0, y0, w, h);
                for (int i = 0; i < sourceTiles.length; ++i) {
                    sourceTiles[i] = this.getSourceTile((RasterDataNode)bandList.srcBands[i], sourceRectangle);
                    dataBuffers[i] = sourceTiles[i].getDataBuffer();
                }
                if (this.isDualPol) {
                    double[][] Cr = new double[2][2];
                    double[][] Ci = new double[2][2];
                    for (int y = y0; y < maxY; ++y) {
                        trgIndex.calculateStride(y);
                        for (int x = x0; x < maxX; ++x) {
                            DualPolOpUtils.getMeanCovarianceMatrixC2((int)x, (int)y, (int)this.halfWindowSize, (int)this.halfWindowSize, (int)this.sourceImageWidth, (int)this.sourceImageHeight, (PolBandUtils.MATRIX)this.sourceProductType, (Tile[])sourceTiles, (ProductData[])dataBuffers, (double[][])Cr, (double[][])Ci);
                            targetData.setElemIntAt(trgIndex.getIndex(x), this.clusterToClassMap[HAlphaWishartC2.findZoneIndex(Cr, Ci, this.clusterCenters) - 1]);
                        }
                    }
                    continue;
                }
                TileIndex srcIndex = new TileIndex(sourceTiles[0]);
                double[][] Tr = new double[3][3];
                double[][] Ti = new double[3][3];
                for (int y = y0; y < maxY; ++y) {
                    trgIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        PolOpUtils.getMeanCoherencyMatrix((int)x, (int)y, (int)this.halfWindowSize, (int)this.halfWindowSize, (int)this.sourceImageWidth, (int)this.sourceImageHeight, (PolBandUtils.MATRIX)this.sourceProductType, (TileIndex)srcIndex, (ProductData[])dataBuffers, (double[][])Tr, (double[][])Ti);
                        targetData.setElemIntAt(trgIndex.getIndex(x), this.clusterToClassMap[HAlphaWishart.findZoneIndex(Tr, Ti, this.clusterCenters) - 1]);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int x0 = Math.max(0, tx0 - this.halfWindowSize);
        int y0 = Math.max(0, ty0 - this.halfWindowSize);
        int xMax = Math.min(tx0 + tw - 1 + this.halfWindowSize, this.sourceImageWidth);
        int yMax = Math.min(ty0 + th - 1 + this.halfWindowSize, this.sourceImageHeight);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SupervisedWishartClassificationOp.class);
        }
    }
}

