/*
 * Decompiled with CFR 0.152.
 */
package org.csa.rstb.classification.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.util.HashMap;
import java.util.Map;
import org.csa.rstb.classification.gpf.classifiers.CloudePottier;
import org.csa.rstb.classification.gpf.classifiers.CloudePottierC2;
import org.csa.rstb.classification.gpf.classifiers.FreemanDurdenWishart;
import org.csa.rstb.classification.gpf.classifiers.HAlphaWishart;
import org.csa.rstb.classification.gpf.classifiers.HAlphaWishartC2;
import org.csa.rstb.classification.gpf.classifiers.PolClassifier;
import org.esa.s1tbx.io.PolBandUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="Polarimetric-Classification", category="Radar/Polarimetric", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Perform Polarimetric classification of a given product")
public class PolarimetricClassificationOp
extends Operator {
    @SourceProduct(alias="source")
    protected Product sourceProduct;
    @TargetProduct
    protected Product targetProduct;
    @Parameter(valueSet={"Cloude-Pottier", "Cloude-Pottier Dual Pol", "H Alpha Wishart", "H Alpha Wishart Dual Pol", "Freeman-Durden Wishart"}, defaultValue="H Alpha Wishart", label="Classification")
    protected String classification = "H Alpha Wishart";
    @Parameter(description="The sliding window size", interval="(1, 100]", defaultValue="5", label="Window Size")
    private int windowSize = 5;
    @Parameter(description="The maximum number of iterations", interval="[1, 100]", defaultValue="3", label="Maximum Number of Iterations")
    protected int maxIterations = 3;
    @Parameter(description="The initial number of classes", interval="[9, 1000]", defaultValue="90", label="The Initial Number of Classes")
    private int numInitialClasses = 90;
    @Parameter(description="The desired number of classes", interval="[9, 100]", defaultValue="15", label="The Final Number of Classes")
    private int numFinalClasses = 15;
    @Parameter(description="The threshold for classifying pixels to mixed category", interval="(0, *)", defaultValue="0.5", label="Threshold for Mixed Category")
    private double mixedCategoryThreshold = 0.5;
    protected int sourceImageWidth = 0;
    protected int sourceImageHeight = 0;
    protected PolBandUtils.PolSourceBand[] srcBandList;
    protected final Map<Band, PolBandUtils.PolSourceBand> bandMap = new HashMap<Band, PolBandUtils.PolSourceBand>();
    public static final String UNSUPERVISED_CLOUDE_POTTIER_CLASSIFICATION = "Cloude-Pottier";
    public static final String UNSUPERVISED_CLOUDE_POTTIER_DUAL_POL_CLASSIFICATION = "Cloude-Pottier Dual Pol";
    public static final String UNSUPERVISED_HALPHA_WISHART_CLASSIFICATION = "H Alpha Wishart";
    public static final String UNSUPERVISED_HALPHA_WISHART_DUAL_POL_CLASSIFICATION = "H Alpha Wishart Dual Pol";
    public static final String UNSUPERVISED_FREEMAN_DURDEN_CLASSIFICATION = "Freeman-Durden Wishart";
    protected PolBandUtils.MATRIX sourceProductType;
    protected PolClassifier classifier;
    private static final String PRODUCT_SUFFIX = "_Class";

    public void SetClassification(String s) {
        if (!(s.equals(UNSUPERVISED_CLOUDE_POTTIER_CLASSIFICATION) || s.equals(UNSUPERVISED_CLOUDE_POTTIER_DUAL_POL_CLASSIFICATION) || s.equals(UNSUPERVISED_HALPHA_WISHART_CLASSIFICATION) || s.equals(UNSUPERVISED_HALPHA_WISHART_DUAL_POL_CLASSIFICATION) || s.equals(UNSUPERVISED_FREEMAN_DURDEN_CLASSIFICATION))) {
            throw new OperatorException(s + " is an invalid classification name.");
        }
        this.classification = s;
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSLC();
            validator.checkIfTOPSARBurstProduct(false);
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.checkSourceProductType(this.sourceProductType);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.sourceProductType = PolBandUtils.getSourceProductType((Product)this.sourceProduct);
            this.srcBandList = PolBandUtils.getSourceBands((Product)this.sourceProduct, (PolBandUtils.MATRIX)this.sourceProductType);
            this.classifier = this.createClassifier(this.classification);
            this.createTargetProduct();
            if (this.targetProduct.getNumBands() > 1 && !this.classifier.canProcessStacks()) {
                throw new OperatorException("Stack processing is not supported with this classifier.");
            }
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkSourceProductType(PolBandUtils.MATRIX sourceProductType) {
        if (sourceProductType == PolBandUtils.MATRIX.UNKNOWN) {
            throw new OperatorException("Input should be a polarimetric product");
        }
        switch (this.classification) {
            case "Cloude-Pottier": 
            case "H Alpha Wishart": 
            case "Freeman-Durden Wishart": {
                if (!PolBandUtils.isDualPol((PolBandUtils.MATRIX)sourceProductType)) break;
                throw new OperatorException("Input product cannot be dual pol");
            }
            case "Cloude-Pottier Dual Pol": 
            case "H Alpha Wishart Dual Pol": {
                if (!PolBandUtils.isQuadPol((PolBandUtils.MATRIX)sourceProductType)) break;
                throw new OperatorException("Input product cannot be quad pol");
            }
        }
    }

    private PolClassifier createClassifier(String classification) throws OperatorException {
        switch (classification) {
            case "Cloude-Pottier": {
                return new CloudePottier(this.sourceProductType, this.sourceImageWidth, this.sourceImageHeight, this.windowSize, this.bandMap, this);
            }
            case "Cloude-Pottier Dual Pol": {
                return new CloudePottierC2(this.sourceProductType, this.sourceImageWidth, this.sourceImageHeight, this.windowSize, this.bandMap, this);
            }
            case "H Alpha Wishart": {
                return new HAlphaWishart(this.sourceProductType, this.sourceImageWidth, this.sourceImageHeight, this.windowSize, this.bandMap, this.maxIterations, this);
            }
            case "H Alpha Wishart Dual Pol": {
                return new HAlphaWishartC2(this.sourceProductType, this.sourceImageWidth, this.sourceImageHeight, this.windowSize, this.windowSize, this.bandMap, this.maxIterations, this);
            }
            case "Freeman-Durden Wishart": {
                return new FreemanDurdenWishart(this.sourceProductType, this.sourceImageWidth, this.sourceImageHeight, this.windowSize, this.bandMap, this.maxIterations, this.numInitialClasses, this.numFinalClasses, this.mixedCategoryThreshold, this);
            }
        }
        throw new OperatorException(classification + " is an invalid classification name.");
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        String targetBandName = this.classifier.getTargetBandName();
        IndexCoding indexCoding = this.classifier.createIndexCoding();
        this.targetProduct.getIndexCodingGroup().add((ProductNode)indexCoding);
        for (PolBandUtils.PolSourceBand bandList : this.srcBandList) {
            Band targetBand = new Band(targetBandName + bandList.suffix, 20, this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
            targetBand.setUnit("zone_index");
            targetBand.setNoDataValue(0.0);
            targetBand.setNoDataValueUsed(true);
            this.targetProduct.addBand(targetBand);
            this.bandMap.put(targetBand, bandList);
            targetBand.setSampleCoding((SampleCoding)indexCoding);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.setAttributeInt("polsar_data", 1);
    }

    public void checkIfCancelled() {
        this.checkForCancellation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            this.classifier.computeTile(targetBand, targetTile);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PolarimetricClassificationOp.class);
        }
    }
}

